/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelData;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PokeDisplayTileEntity
extends BlockEntity {
    private Pokemon storedPoke;
    private String originalForm = null;
    private String originalPalette = null;
    private PixelmonEntity storedEntity;
    private String label = "";
    private EnumStatueTextureType textureMode = EnumStatueTextureType.OriginalTexture;
    private AnimationType animation = AnimationType.IDLE;
    private int animationFrame = 0;
    private boolean animate = true;
    private boolean isFlying = false;
    private Optional<UUID> locked = Optional.empty();

    public PokeDisplayTileEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    public PokeDisplayTileEntity(BlockPos p_155229_, BlockState p_155230_) {
        this((BlockEntityType)TileEntityRegistration.POKE_DISPLAY.get(), p_155229_, p_155230_);
    }

    public void setLocked(Player player) {
        if (player == null) {
            this.locked = Optional.empty();
            return;
        }
        this.locked = Optional.ofNullable(player.m_20148_());
    }

    public boolean isLocked() {
        return this.locked.isPresent();
    }

    public boolean isLockedBy(Player player) {
        return this.isLocked() && Objects.equals(this.locked.get(), player.m_20148_());
    }

    public Optional<Pokemon> getStoredPoke() {
        return Optional.ofNullable(this.storedPoke);
    }

    public PixelmonEntity getStoredEntity() {
        if (this.storedEntity == null) {
            this.setStoredPoke(null);
        }
        return this.storedEntity;
    }

    public void setStoredPoke(Pokemon storedPoke) {
        this.storedPoke = storedPoke;
        if (storedPoke != null) {
            this.storedEntity = storedPoke.getOrCreatePixelmon(this.f_58857_, (double)this.m_58899_().m_123341_() + 0.5, this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_() + 0.5, 0.0f, 0.0f);
        } else {
            this.storedEntity = PokemonFactory.create(PixelmonSpecies.MISSINGNO.getValueUnsafe()).getOrCreatePixelmon(this.f_58857_, (double)this.m_58899_().m_123341_() + 0.5, this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_() + 0.5, 0.0f, 0.0f);
            this.storedEntity.getPokemon().setGrowth(EnumGrowth.Ordinary);
        }
        this.storedEntity.setDisableNametag(true);
        this.storedEntity.setAnimation(this.animation);
        if (!this.animate) {
            if (this.storedEntity.getAnimationVariables() != null && this.storedEntity.getAnimationVariables().getCounter(-1) != null) {
                this.storedEntity.getAnimationVariables().getCounter((int)-1).value = this.animationFrame;
            } else {
                this.animate = true;
            }
        }
        if (this.textureMode.color != null) {
            this.storedEntity.setColor(this.textureMode.color);
        }
        if (this.textureMode.texture != null) {
            this.storedEntity.setOverrideTexture(this.textureMode.texture);
        }
        if (this.isFlying) {
            this.storedEntity.setAnimation(AnimationType.FLY);
        }
        this.m_6596_();
    }

    public String getOriginalForm() {
        return this.originalForm;
    }

    public void setOriginalForm(String form) {
        this.originalForm = form;
        this.m_6596_();
    }

    public String getOriginalPalette() {
        return this.originalPalette;
    }

    public void setOriginalPalette(String palette) {
        this.originalPalette = palette;
        this.m_6596_();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public EnumStatueTextureType getTextureMode() {
        return this.textureMode;
    }

    public void setTextureMode(EnumStatueTextureType textureMode) {
        this.textureMode = textureMode;
        if (textureMode.color != null) {
            this.getStoredEntity().setColor(textureMode.color);
        }
        this.getStoredEntity().setOverrideTexture(textureMode.texture);
    }

    public AnimationType getAnimation() {
        return this.animation;
    }

    public void setAnimation(AnimationType animation) {
        this.animation = animation;
        this.getStoredEntity().setAnimation(animation);
    }

    public int getAnimationFrame() {
        return this.animationFrame;
    }

    public void setAnimationFrame(int animationFrame) {
        this.animationFrame = animationFrame;
        this.storedEntity.getAnimationVariables().getCounter((int)-1).value = animationFrame;
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.isFlying = flying;
    }

    public void tick() {
        if (this.f_58857_.f_46443_ && this.animate) {
            this.getStoredEntity().getAnimationVariables().tick();
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.m_183515_(nbt);
        return nbt;
    }

    public void m_183515_(CompoundTag nbt) {
        if (this.storedPoke != null) {
            nbt.m_128365_("PokeDisplayPokemon", (Tag)this.storedPoke.writeToNBT(new CompoundTag()));
        }
        if (this.originalForm != null) {
            nbt.m_128359_("PokeDisplayOriginalForm", this.originalForm);
        }
        if (this.originalPalette != null) {
            nbt.m_128359_("PokeDisplayOriginalPalette", this.originalPalette);
        }
        nbt.m_128359_("PokeDisplayLabel", this.label);
        nbt.m_128405_("PokeDisplayTextureMode", this.textureMode.ordinal());
        nbt.m_128405_("PokeDisplayAnimation", this.animation.ordinal());
        nbt.m_128379_("PokeDisplayAnimate", this.animate);
        nbt.m_128379_("PokeDisplayFlying", this.isFlying);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("PokeDisplayLabel")) {
            this.label = nbt.m_128461_("PokeDisplayLabel");
        }
        if (nbt.m_128441_("PokeDisplayTextureMode")) {
            this.textureMode = EnumStatueTextureType.values()[nbt.m_128451_("PokeDisplayTextureMode")];
        }
        if (nbt.m_128441_("PokeDisplayAnimation")) {
            this.animation = AnimationType.values()[nbt.m_128451_("PokeDisplayAnimation")];
        }
        if (nbt.m_128441_("PokeDisplayAnimate")) {
            this.animate = nbt.m_128471_("PokeDisplayAnimate");
        }
        if (nbt.m_128441_("PokeDisplayFlying")) {
            this.isFlying = nbt.m_128471_("PokeDisplayFlying");
        }
        if (nbt.m_128441_("PokeDisplayPokemon")) {
            this.setStoredPoke(PokemonFactory.create(nbt.m_128469_("PokeDisplayPokemon")));
        } else {
            this.setStoredPoke(null);
        }
        if (nbt.m_128441_("PokeDisplayOriginalForm")) {
            this.originalForm = nbt.m_128461_("PokeDisplayOriginalForm");
        } else {
            this.setOriginalForm(null);
        }
        if (nbt.m_128441_("PokeDisplayOriginalPalette")) {
            this.originalPalette = nbt.m_128461_("PokeDisplayOriginalPalette");
        } else {
            this.setOriginalPalette(null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFrameCount() {
        int n = 0;
        ModelData[] modelDataArray = this.getModel();
        int n2 = modelDataArray.length;
        if (n < n2) {
            ModelData modelData = modelDataArray[n];
            return modelData.getModel().currentSequence.current().totalFrames;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<AnimationType> getAllAnimations() {
        ArrayList animationTypes = Lists.newArrayList();
        for (ModelData modelData : this.getModel()) {
            animationTypes.addAll(modelData.getModel().anims.keySet());
        }
        return animationTypes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModelData[] getModel() {
        return this.getStoredEntity().getPalette().getModel(this.storedEntity);
    }
}

