/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.LootClaim;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokeChestType;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PokeChestTileEntity
extends BlockEntity {
    private EnumPokechestVisibility visibility = EnumPokechestVisibility.Visible;
    private EnumPokeChestType type = null;
    private UUID ownerID = null;
    private boolean chestOneTime = true;
    private boolean dropOneTime = true;
    private boolean doCustomDrop = false;
    private boolean timeEnabled = false;
    private ItemStack[] customDrops = null;
    private int frontFace = 4;
    private boolean grotto = false;
    private boolean isEvent = false;
    private List<LootClaim> claimed = new ArrayList<LootClaim>();

    public PokeChestTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.POKE_CHEST.get(), blockPos, blockState);
    }

    public PokeChestTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void setOwner(UUID id) {
        this.ownerID = id;
    }

    public UUID getOwner() {
        return this.ownerID;
    }

    public void setChestType(EnumPokeChestType type) {
        this.type = type;
    }

    public EnumPokeChestType getChestType() {
        if (this.type == null) {
            Block blockType = this.m_58900_().m_60734_();
            this.type = this.isEvent ? EnumPokeChestType.SPECIAL : (blockType == PixelmonBlocks.poke_chest ? EnumPokeChestType.POKEBALL : (blockType == PixelmonBlocks.ultra_chest ? EnumPokeChestType.ULTRABALL : (blockType == PixelmonBlocks.beast_chest ? EnumPokeChestType.BEASTBALL : (blockType == PixelmonBlocks.master_chest ? EnumPokeChestType.MASTERBALL : EnumPokeChestType.POKEBALL))));
        }
        return this.type;
    }

    public void setGrotto() {
        this.grotto = true;
    }

    public boolean isGrotto() {
        return this.grotto;
    }

    public void m_183515_(CompoundTag tagger) {
        ListTag list;
        super.m_183515_(tagger);
        tagger.m_128362_("Owner", this.ownerID == null ? Util.f_137441_ : this.ownerID);
        tagger.m_128379_("chestOneTime", this.chestOneTime);
        tagger.m_128379_("dropOneTime", this.dropOneTime);
        tagger.m_128379_("customDrop", this.doCustomDrop);
        tagger.m_128379_("timeEnabled", this.timeEnabled);
        tagger.m_128379_("grotto", this.grotto);
        tagger.m_128376_("visibility", (short)this.visibility.ordinal());
        tagger.m_128379_("specialEvent", this.isEvent);
        if (!this.claimed.isEmpty()) {
            list = new ListTag();
            for (int i = 0; i < this.claimed.size(); ++i) {
                CompoundTag playerInfoTag = new CompoundTag();
                LootClaim playerClaim = this.claimed.get(i);
                playerInfoTag.m_128362_("Claimer", playerClaim.getPlayerID());
                playerInfoTag.m_128356_("timeClaimed", playerClaim.getTimeClaimed());
                list.add((Object)playerInfoTag);
            }
            tagger.m_128365_("claimedPlayers", (Tag)list);
        }
        if (this.customDrops != null) {
            list = new ListTag();
            for (ItemStack customDrop : this.customDrops) {
                CompoundTag stackCompound = new CompoundTag();
                if (customDrop == null) continue;
                list.add((Object)customDrop.m_41739_(stackCompound));
            }
            tagger.m_128365_("customDrops", (Tag)list);
        }
    }

    public void writeToNBTClient(CompoundTag tagger) {
        tagger.m_128379_("specialEvent", this.isEvent);
        tagger.m_128376_("visibility", (short)this.visibility.ordinal());
        super.m_183515_(tagger);
    }

    public void readFromNBTClient(CompoundTag tagger) {
        this.isEvent = tagger.m_128471_("specialEvent");
        this.visibility = EnumPokechestVisibility.values()[tagger.m_128448_("visibility")];
        super.m_142466_(tagger);
    }

    public void m_142466_(CompoundTag tagger) {
        UUID uuid = tagger.m_128403_("Owner") ? tagger.m_128342_("Owner") : Util.f_137441_;
        this.ownerID = Objects.equals(Util.f_137441_, uuid) ? null : uuid;
        this.chestOneTime = tagger.m_128471_("chestOneTime");
        this.dropOneTime = tagger.m_128471_("dropOneTime");
        this.timeEnabled = tagger.m_128471_("timeEnabled");
        this.grotto = tagger.m_128471_("grotto");
        this.isEvent = tagger.m_128471_("specialEvent");
        this.visibility = EnumPokechestVisibility.values()[tagger.m_128448_("visibility")];
        this.doCustomDrop = tagger.m_128471_("customDrop");
        if (this.isEvent) {
            this.timeEnabled = false;
            this.dropOneTime = true;
            this.chestOneTime = false;
        }
        if (tagger.m_128441_("claimedPlayers")) {
            ListTag claimedTag = tagger.m_128437_("claimedPlayers", 10);
            for (Tag inbt : claimedTag) {
                CompoundTag nbt = (CompoundTag)inbt;
                this.claimed.add(new LootClaim(nbt.m_128342_("Claimer"), nbt.m_128454_("timeClaimed")));
            }
        }
        ListTag dropList = tagger.m_128437_("customDrops", 10);
        this.customDrops = new ItemStack[dropList.size()];
        for (int i = 0; i < this.customDrops.length; ++i) {
            this.customDrops[i] = ItemStack.m_41712_((CompoundTag)dropList.m_128728_(i));
        }
        super.m_142466_(tagger);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.writeToNBTClient(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readFromNBTClient(pkt.m_131708_());
    }

    public boolean canClaim(UUID playerID) {
        if (!this.dropOneTime) {
            return true;
        }
        LootClaim claim = this.getLootClaim(playerID);
        if (claim != null) {
            return this.timeEnabled && (System.currentTimeMillis() - claim.getTimeClaimed()) / 1000L > (long)(PixelmonConfigProxy.getSpawning().getPokeLoot().getLootTime() * 3600);
        }
        return true;
    }

    public LootClaim getLootClaim(UUID playerID) {
        for (LootClaim claim : this.claimed) {
            if (!claim.getPlayerID().equals(playerID)) continue;
            return claim;
        }
        return null;
    }

    public void addClaimer(UUID playerID) {
        if (this.dropOneTime || this.timeEnabled) {
            this.claimed.add(new LootClaim(playerID, System.currentTimeMillis()));
        }
    }

    public void removeClaimer(UUID playerID) {
        this.claimed.remove(this.getLootClaim(playerID));
    }

    public boolean shouldBreakBlock() {
        return this.chestOneTime && !this.timeEnabled;
    }

    public void setChestOneTime(boolean val) {
        this.chestOneTime = val;
    }

    public boolean getChestMode() {
        return this.chestOneTime;
    }

    public void setDropOneTime(boolean val) {
        this.dropOneTime = val;
    }

    public boolean getDropMode() {
        return this.dropOneTime;
    }

    public boolean isCustomDrop() {
        return this.doCustomDrop && this.customDrops != null;
    }

    public boolean isTimeEnabled() {
        return this.timeEnabled;
    }

    public void setTimeEnabled(boolean val) {
        this.timeEnabled = val;
    }

    public ItemStack[] getCustomDrops() {
        if (this.isEvent) {
            for (ItemStack s : this.customDrops) {
                if (s.m_41753_()) continue;
                if (!s.m_41782_()) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128379_("specialEvent", true);
                    s.m_41751_(nbt);
                    continue;
                }
                s.m_41783_().m_128379_("specialEvent", true);
            }
        }
        return this.customDrops;
    }

    public void setCustomDrops(ItemStack ... customDrops) {
        this.doCustomDrop = true;
        this.customDrops = new ItemStack[customDrops.length];
        int index = 0;
        for (ItemStack stack : customDrops) {
            this.customDrops[index] = stack.m_41777_();
            ++index;
        }
    }

    public void setCustomDropEnabled(boolean enabled) {
        this.doCustomDrop = enabled;
    }

    public boolean isUsableByPlayer(Player player) {
        return this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) < 64.0;
    }

    public void setFrontFace(int face) {
        this.frontFace = face;
    }

    public int getFrontFace() {
        return this.frontFace;
    }

    public void setSpecialEventDrop(ItemStack itemStack) {
        this.isEvent = true;
        this.chestOneTime = false;
        this.dropOneTime = true;
        this.setCustomDrops(itemStack);
    }

    public EnumPokechestVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(EnumPokechestVisibility visible) {
        this.visibility = visible;
        ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
    }
}

