/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.BossRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.LevelRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.NoDropsRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.PaletteRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.ShinyRequirement;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.spawning.PixelmonSpawnerEvent;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.machines.PokemonRarity;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Event;

public class PixelmonSpawnerTileEntity
extends BlockEntity {
    public static final Set<Block> VALID_LAND_FLOOR_MATERIALS = Sets.newHashSet((Object[])new Block[]{Blocks.f_50034_, Blocks.f_50440_, Blocks.f_50336_, Blocks.f_50041_, Blocks.f_50058_, Blocks.f_50705_, Blocks.f_50493_, Blocks.f_50069_, Blocks.f_49992_, Blocks.f_50126_, Blocks.f_50127_, Blocks.f_50125_, Blocks.f_50449_});
    public static final Set<Block> VALID_LAND_AIR_MATERIALS = Sets.newHashSet((Object[])new Block[]{Blocks.f_50016_, Blocks.f_50127_, Blocks.f_50034_, Blocks.f_50359_});
    private static final Set<Block> VALID_WATER_FLOOR_MATERIALS = Sets.newHashSet((Object[])new Block[]{Blocks.f_49990_});
    private static final Set<Block> VALID_WATER_AIR_MATERIALS = Sets.newHashSet((Object[])new Block[]{Blocks.f_50016_, Blocks.f_49990_});
    public List<PokemonRarity> pokemonList = Lists.newArrayList();
    public int spawnTick = 40;
    public int spawnRadius = 8;
    public int maxSpawns = 5;
    public int levelMin = 5;
    public int levelMax = 10;
    public float bossRatio = 100.0f;
    public float shinyRatio = PixelmonConfigProxy.getSpawning().getShinyRate();
    public float gmaxRatio = PixelmonConfigProxy.getSpawning().getGigantamaxFactorRate();
    public boolean uncatchable = false;
    public boolean unbreedable = false;
    public boolean unbattleable = false;
    public boolean fireOnTick = true;
    public SpawnLocationType spawnLocation = SpawnLocationType.LAND;
    public Aggression aggression = Aggression.PASSIVE;
    public List<PixelmonEntity> spawnedPokemon = Lists.newArrayList();
    private boolean editing = false;
    private int tick = -1;

    public PixelmonSpawnerTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.PIXELMON_SPAWNER.get(), blockPos, blockState);
    }

    public PixelmonSpawnerTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("spawnTick", this.spawnTick);
        nbt.m_128376_("spawnRadius", (short)this.spawnRadius);
        nbt.m_128376_("maxSpawns", (short)this.maxSpawns);
        nbt.m_128376_("levelMin", (short)this.levelMin);
        nbt.m_128376_("levelMax", (short)this.levelMax);
        nbt.m_128379_("fireOnTick", this.fireOnTick);
        nbt.m_128376_("aggression", (short)this.aggression.ordinal());
        nbt.m_128350_("bossRatio", this.bossRatio);
        nbt.m_128376_("spawnLocation", (short)this.spawnLocation.ordinal());
        nbt.m_128350_("shinyRatio", this.shinyRatio);
        nbt.m_128350_("gmaxRatio", this.gmaxRatio);
        nbt.m_128379_("unbattleable", this.unbattleable);
        nbt.m_128379_("uncatchable", this.uncatchable);
        nbt.m_128379_("unbreedable", this.unbreedable);
        PokemonRarity.addToNbt(nbt, this.pokemonList);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.spawnTick = nbt.m_128451_("spawnTick");
        this.spawnRadius = nbt.m_128448_("spawnRadius");
        this.maxSpawns = nbt.m_128448_("maxSpawns");
        this.levelMin = nbt.m_128448_("levelMin");
        this.levelMax = nbt.m_128448_("levelMax");
        this.fireOnTick = nbt.m_128471_("fireOnTick");
        this.aggression = Aggression.getAggression(nbt.m_128448_("aggression"));
        this.bossRatio = nbt.m_128457_("bossRatio");
        this.spawnLocation = SpawnLocationType.getFromIndex(nbt.m_128448_("spawnLocation"));
        this.shinyRatio = nbt.m_128457_("shinyRatio");
        this.gmaxRatio = nbt.m_128457_("gmaxRatio");
        this.unbattleable = nbt.m_128471_("unbattleable");
        this.uncatchable = nbt.m_128471_("uncatchable");
        this.unbreedable = nbt.m_128471_("unbreedable");
        this.pokemonList.clear();
        this.pokemonList = PokemonRarity.fromNbt(nbt);
    }

    protected static boolean isMostlyEnclosedSpace(Level world, BlockPos pos, int radius) {
        for (Direction dir : Direction.values()) {
            boolean ok = false;
            for (int i = 0; i < radius; ++i) {
                BlockPos pos2 = new BlockPos(pos.m_123341_() + dir.m_122429_() * i, pos.m_123342_() + dir.m_122430_() * i, pos.m_123343_() + dir.m_122431_() * i);
                BlockState state = world.m_8055_(pos2);
                if (!state.m_60796_((BlockGetter)world, pos2)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlockValidForPixelmonSpawning(Level world, BlockPos pos, AreaType type) {
        BlockState groundBlock = world.m_8055_(pos.m_7495_());
        Block[] spawnAirMaterial = new Block[]{world.m_8055_(pos).m_60734_(), world.m_8055_(pos.m_7494_()).m_60734_()};
        if (type == AreaType.LAND) {
            return VALID_LAND_FLOOR_MATERIALS.contains(groundBlock.m_60734_()) && VALID_LAND_AIR_MATERIALS.contains(spawnAirMaterial[0]) && VALID_LAND_AIR_MATERIALS.contains(spawnAirMaterial[1]);
        }
        if (type == AreaType.WATER) {
            return VALID_WATER_FLOOR_MATERIALS.contains(groundBlock.m_60734_()) && VALID_WATER_AIR_MATERIALS.contains(spawnAirMaterial[0]) && VALID_WATER_AIR_MATERIALS.contains(spawnAirMaterial[1]);
        }
        return PixelmonSpawnerTileEntity.isMostlyEnclosedSpace(world, pos, 5) && VALID_LAND_FLOOR_MATERIALS.contains(groundBlock.m_60734_()) && VALID_LAND_AIR_MATERIALS.contains(spawnAirMaterial[0]) && VALID_LAND_AIR_MATERIALS.contains(spawnAirMaterial[1]);
    }

    private void spawnPixelmon(PokemonSpecification spec) {
        this.checkForDead();
        if (this.spawnedPokemon.size() >= this.maxSpawns) {
            return;
        }
        if (this.spawnLocation == null) {
            return;
        }
        int x = this.f_58858_.m_123341_() + RandomHelper.getRandom().nextInt(this.spawnRadius * 2 + 1) - this.spawnRadius;
        int y = this.f_58858_.m_123342_() - 1;
        int z = this.f_58858_.m_123343_() + RandomHelper.getRandom().nextInt(this.spawnRadius * 2 + 1) - this.spawnRadius;
        boolean valid = false;
        if (this.spawnLocation == SpawnLocationType.LAND) {
            y = this.getTopSolidBlock(x, y, z);
            valid = PixelmonSpawnerTileEntity.isBlockValidForPixelmonSpawning(this.f_58857_, new BlockPos(x, y, z), AreaType.LAND);
        } else if (this.spawnLocation == SpawnLocationType.AIR) {
            y = this.getTopSolidBlock(x, y, z);
            valid = PixelmonSpawnerTileEntity.isBlockValidForPixelmonSpawning(this.f_58857_, new BlockPos(x, y, z), AreaType.LAND);
        } else if (this.spawnLocation == SpawnLocationType.AIR_PERSISTENT) {
            ytmp = this.getFirstAirBlock(x, y, z);
            if (ytmp != null) {
                y = ytmp;
                valid = true;
            }
        } else if (this.spawnLocation == SpawnLocationType.WATER) {
            ytmp = this.getFirstWaterBlock(x, y, z);
            if (ytmp != null) {
                y = ytmp;
                valid = PixelmonSpawnerTileEntity.isBlockValidForPixelmonSpawning(this.f_58857_, new BlockPos(x, y + 1, z), AreaType.WATER);
            }
        } else if (this.spawnLocation == SpawnLocationType.UNDERGROUND) {
            y = this.getTopSolidBlock(x, y, z);
            valid = PixelmonSpawnerTileEntity.isBlockValidForPixelmonSpawning(this.f_58857_, new BlockPos(x, y, z), AreaType.UNDERGROUND);
        }
        if (valid) {
            PixelmonSpawnerEvent.Pre event = new PixelmonSpawnerEvent.Pre(this, spec, new BlockPos(x, y, z));
            if (Pixelmon.EVENT_BUS.post((Event)event)) {
                return;
            }
            PixelmonEntity pixelmon = event.getSpec().create(this.f_58857_);
            pixelmon.m_6034_(x, y, z);
            if (!event.getSpec().getValue(LevelRequirement.class).isPresent()) {
                pixelmon.getPokemon().setLevel(RandomHelper.getRandomNumberBetween(this.levelMin, this.levelMax));
            }
            if (!event.getSpec().getValue(ShinyRequirement.class).isPresent() && !event.getSpec().getValue(PaletteRequirement.class).isPresent() && RandomHelper.getRandomChance(1.0f / this.shinyRatio)) {
                pixelmon.getPokemon().setShiny();
            }
            if (!event.getSpec().getValue(BossRequirement.class).isPresent()) {
                BossTier bossTier = BossTierRegistry.getBossTierOrNotBoss("notboss");
                if (RandomHelper.getRandomChance(1.0f / this.bossRatio)) {
                    if (PixelmonConfigProxy.getSpawning().getBossSpawning().isBossesAlwaysMegaIfPossible()) {
                        boolean legendary = pixelmon.getPokemon().getForm().getTags().isLegendary();
                        if (pixelmon.getPokemon().getForm().hasMegaForm()) {
                            bossTier = legendary ? BossTierRegistry.getBossTierOrNotBoss("ultimate") : BossTierRegistry.getRandomSpawnableMegaBossTier();
                        } else if (legendary) {
                            bossTier = BossTierRegistry.getBossTierOrNotBoss("ultimate");
                        }
                    }
                    if (bossTier.isNotBoss()) {
                        bossTier = BossTierRegistry.getRandomSpawnableBossTier();
                    }
                }
                pixelmon.setBossTier(bossTier);
            }
            if (RandomHelper.getRandomChance(1.0f / this.gmaxRatio)) {
                List<Stats> forms = pixelmon.getSpecies().getForms("gmax");
                if (forms.size() > 1) {
                    pixelmon.setForm(RandomHelper.getRandomElementFromCollection(forms));
                } else if (!forms.isEmpty()) {
                    pixelmon.setForm(forms.get(0));
                }
            }
            if (this.uncatchable) {
                pixelmon.getPokemon().addFlag("uncatchable");
            }
            if (this.unbreedable) {
                pixelmon.getPokemon().addFlag("unbreedable");
            }
            if (this.unbattleable) {
                pixelmon.getPokemon().addFlag("unbattleable");
            }
            if (event.getSpec().getValue(NoDropsRequirement.class).isPresent()) {
                pixelmon.getPokemon().addFlag("nodrops");
            }
            pixelmon.resetDataWatchers();
            this.f_58857_.m_7967_((Entity)pixelmon);
            pixelmon.aggression = this.aggression;
            pixelmon.setSpawnLocation(this.spawnLocation);
            pixelmon.resetAI();
            pixelmon.setSpawnerParent(this);
            this.spawnedPokemon.add(pixelmon);
            Pixelmon.EVENT_BUS.post((Event)new PixelmonSpawnerEvent.Post(this, event.getSpec(), event.getSpawnPosition(), pixelmon));
        }
    }

    private int getTopSolidBlock(int x, int y, int z) {
        BlockPos pos;
        int i;
        boolean valid = false;
        for (i = 1; i <= this.spawnRadius / 2; ++i) {
            pos = new BlockPos(x, y + i, z);
            if (!VALID_LAND_AIR_MATERIALS.contains(this.f_58857_.m_8055_(pos).m_60734_()) || !this.isSolidSurface(this.f_58857_, pos)) continue;
            y += i;
            valid = true;
            break;
        }
        if (!valid) {
            for (i = 1; i <= this.spawnRadius / 2; ++i) {
                pos = new BlockPos(x, y - i, z);
                if (!VALID_LAND_AIR_MATERIALS.contains(this.f_58857_.m_8055_(pos).m_60734_()) || !this.isSolidSurface(this.f_58857_, pos)) continue;
                y -= i;
                break;
            }
        }
        return y;
    }

    private boolean isSolidSurface(Level worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)worldIn, pos, Direction.UP) && !worldIn.m_8055_(pos).m_280296_() && !worldIn.m_8055_(pos.m_7494_()).m_280296_();
    }

    private Integer getFirstAirBlock(int x, int y, int z) {
        int i = 0;
        while (this.f_58857_.m_8055_(new BlockPos(x, y + i, z)).m_60713_(Blocks.f_50016_)) {
            if (i > this.spawnRadius / 2) {
                return null;
            }
            ++i;
        }
        return y + i;
    }

    private Integer getFirstWaterBlock(int x, int y, int z) {
        int i = 0;
        while (!this.f_58857_.m_8055_(new BlockPos(x, y + i, z)).m_60713_(Blocks.f_49990_)) {
            if (this.f_58857_.m_8055_(new BlockPos(x, y + i, z)).m_60713_(Blocks.f_50016_)) {
                return null;
            }
            ++i;
        }
        return y + i;
    }

    private void doSpawning(boolean override) {
        if (this.tick == 0 || override) {
            PokemonSpecification p = this.selectPokemonForSpawn();
            if (p == null) {
                return;
            }
            this.spawnPixelmon(p);
            this.resetSpawnTick();
            if (override) {
                return;
            }
        }
        if (this.tick == -1) {
            this.resetSpawnTick();
        }
        --this.tick;
    }

    private void doEffects() {
        if (this.isNearPlayer()) {
            Level world = this.m_58904_();
            BlockPos blockpos = this.m_58899_();
            if (!(world instanceof ServerLevel)) {
                double d3 = (double)blockpos.m_123341_() + RandomHelper.getRandom().nextDouble();
                double d4 = (double)blockpos.m_123342_() + RandomHelper.getRandom().nextDouble();
                double d5 = (double)blockpos.m_123343_() + RandomHelper.getRandom().nextDouble();
                world.m_7106_((ParticleOptions)ParticleTypes.f_123745_, d3, d4, d5, 0.0, 0.0, 0.0);
            }
        }
    }

    private boolean isNearPlayer() {
        BlockPos blockpos = this.m_58899_();
        return this.m_58904_().m_45914_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, 16.0);
    }

    private void checkForDead() {
        for (int i = 0; i < this.spawnedPokemon.size(); ++i) {
            PixelmonEntity p = this.spawnedPokemon.get(i);
            if (p.isLoaded(false) && p.m_6084_()) continue;
            this.spawnedPokemon.remove(i);
            --i;
        }
    }

    private void resetSpawnTick() {
        this.tick = (int)((double)this.spawnTick * (1.0 + (RandomHelper.getRandom().nextDouble() - 0.5) * 0.2));
    }

    private PokemonSpecification selectPokemonForSpawn() {
        int total = 0;
        for (PokemonRarity aPokemonList1 : this.pokemonList) {
            total += aPokemonList1.rarity;
        }
        if (total <= 0) {
            return null;
        }
        int rand = RandomHelper.getRandom().nextInt(total);
        total = 0;
        for (PokemonRarity aPokemonList : this.pokemonList) {
            if (rand >= (total += aPokemonList.rarity)) continue;
            return aPokemonList.pokemon;
        }
        return null;
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void updateRedstone() {
        if (!this.fireOnTick && !this.editing) {
            this.doSpawning(true);
        }
    }

    public void onActivate() {
        this.editing = true;
    }

    public void finishEdit() {
        this.editing = false;
        this.resetSpawnTick();
        while (!this.spawnedPokemon.isEmpty()) {
            this.spawnedPokemon.get(0).unloadEntity();
            this.spawnedPokemon.remove(0);
        }
        for (int i = 0; i < this.pokemonList.size(); ++i) {
            PokemonRarity pkr = this.pokemonList.get(i);
            if (pkr.pokemon.toString().length() <= 0) continue;
            pkr.pokemon = PokemonSpecificationProxy.create(pkr.pokemon.toString()).get();
        }
    }

    public void despawnAllPokemon() {
        while (!this.spawnedPokemon.isEmpty()) {
            this.spawnedPokemon.get(0).unloadEntity();
            this.spawnedPokemon.remove(0);
        }
    }

    public static void tick(Level level, BlockPos p_155254_, BlockState p_155255_, PixelmonSpawnerTileEntity blockEntity) {
        if (!level.f_46443_ && blockEntity.fireOnTick && !blockEntity.editing) {
            blockEntity.doSpawning(false);
        } else if (level.f_46443_) {
            blockEntity.doEffects();
        }
        blockEntity.updateRedstone();
    }

    public static enum AreaType {
        LAND,
        WATER,
        UNDERGROUND;

    }
}

