/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.blocks.MysteryBoxEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.MysteryBoxBlock;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Event;

public class MysteryBoxTileEntity
extends BlockEntity {
    private long lastOpenTime;
    private long nextOpenTime;
    private long openUntil;
    private int scrapsTotal;
    private int scrapsLeft;
    private transient float animTicker = 0.0f;
    private transient float rotation = 0.0f;
    private transient float velocity = 0.0f;
    private transient long previousTick = -1L;
    private transient boolean open = false;
    private transient int lastPower = -1;

    public MysteryBoxTileEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)TileEntityRegistration.MYSTERY_BOX.get(), blockPos, blockState);
    }

    public MysteryBoxTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.resetValues();
    }

    public void resetValues() {
        this.openUntil = -1L;
        this.nextOpenTime = -1L;
        this.lastOpenTime = -1L;
        this.scrapsTotal = this.scrapsLeft = PixelmonConfigProxy.getSpawning().getMeltanBoxInitialScrapsCount();
    }

    public boolean isOpen() {
        return this.openUntil > System.currentTimeMillis();
    }

    public boolean canOpen() {
        return this.scrapsLeft <= 0 && !this.isOpen() && !this.isOnCooldown();
    }

    public boolean isOnCooldown() {
        return this.nextOpenTime > System.currentTimeMillis();
    }

    public void removeCooldown() {
        this.nextOpenTime = -1L;
    }

    public boolean tryOpen(Player player, BlockState state, ItemStack item) {
        MysteryBoxEvent.Open.Pre pre = new MysteryBoxEvent.Open.Pre(this, player, state, item, this.canOpen());
        if (!Pixelmon.EVENT_BUS.post((Event)pre) && pre.canOpen()) {
            this.lastOpenTime = System.currentTimeMillis();
            this.openUntil = this.lastOpenTime + PixelmonConfigProxy.getSpawning().getMeltanBoxOpenDurationMillis();
            this.nextOpenTime = this.openUntil + PixelmonConfigProxy.getSpawning().getMeltanBoxCooldownDurationMillis();
            this.scrapsLeft = this.scrapsTotal = (int)((double)this.scrapsTotal * PixelmonConfigProxy.getSpawning().getMeltanBoxScrapsMultiplier());
            MysteryBoxEvent.Open.Post post = new MysteryBoxEvent.Open.Post(this, player, state, item, this.lastOpenTime, this.openUntil, this.nextOpenTime, this.scrapsTotal, this.scrapsLeft);
            Pixelmon.EVENT_BUS.post((Event)post);
            this.lastOpenTime = post.getLastOpenTime();
            this.openUntil = post.getOpenUntil();
            this.nextOpenTime = post.getNextOpenTime();
            this.scrapsTotal = post.getScrapsTotal();
            this.scrapsLeft = post.getScrapsLeft();
            this.m_6596_();
            player.f_19853_.m_5594_(null, this.m_58899_(), (SoundEvent)SoundRegistration.MYSTERY_BOX_OPEN.get(), SoundSource.BLOCKS, 0.5f, 0.5f);
            return true;
        }
        return false;
    }

    public boolean feedScrap(Player player, BlockState state, ItemStack item) {
        MysteryBoxEvent.Feed event;
        if (this.scrapsLeft > 0 && !Pixelmon.EVENT_BUS.post((Event)(event = new MysteryBoxEvent.Feed(this, player, state, item, this.scrapsLeft)))) {
            this.scrapsLeft = event.getScrapsLeft();
            --this.scrapsLeft;
            return true;
        }
        return false;
    }

    public int getPower() {
        if (!this.open) {
            return 0;
        }
        int power = this.isOpen() ? Math.max(1, (int)(15.0f * (float)(this.openUntil - System.currentTimeMillis()) / (float)(this.openUntil - this.lastOpenTime)) + 1) : 0;
        MysteryBoxEvent.ComparatorPower event = new MysteryBoxEvent.ComparatorPower(this, this.m_58900_(), power);
        Pixelmon.EVENT_BUS.post((Event)event);
        return event.getPower();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128356_("LastOpenTime", this.lastOpenTime);
        nbt.m_128356_("NextOpenTime", this.nextOpenTime);
        nbt.m_128356_("OpenUntil", this.openUntil);
        nbt.m_128405_("ScrapsTotal", this.scrapsTotal);
        nbt.m_128405_("ScrapsLeft", this.scrapsLeft);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.lastOpenTime = nbt.m_128441_("LastOpenTime") ? nbt.m_128454_("LastOpenTime") : -1L;
        this.nextOpenTime = nbt.m_128441_("NextOpenTime") ? nbt.m_128454_("NextOpenTime") : -1L;
        this.openUntil = nbt.m_128441_("OpenUntil") ? nbt.m_128454_("OpenUntil") : -1L;
        this.scrapsTotal = nbt.m_128441_("ScrapsTotal") ? nbt.m_128451_("ScrapsTotal") : PixelmonConfigProxy.getSpawning().getMeltanBoxInitialScrapsCount();
        this.scrapsLeft = nbt.m_128441_("ScrapsLeft") ? nbt.m_128451_("ScrapsLeft") : PixelmonConfigProxy.getSpawning().getMeltanBoxInitialScrapsCount();
    }

    private BlockPos findYSpawnOffset(Level level, BlockPos initialPos, int maxOffset) {
        if (this.isValidSpawn(level, initialPos)) {
            return initialPos;
        }
        BlockPos.MutableBlockPos offsetPos = initialPos.m_122032_();
        for (int offset = 1; offset < maxOffset; ++offset) {
            offsetPos.m_142448_(initialPos.m_123342_() + offset);
            if (this.isValidSpawn(level, (BlockPos)offsetPos)) {
                return offsetPos;
            }
            offsetPos.m_142448_(initialPos.m_123342_() - offset);
            if (!this.isValidSpawn(level, (BlockPos)offsetPos)) continue;
            return offsetPos;
        }
        return null;
    }

    private boolean isValidSpawn(Level level, BlockPos pos) {
        boolean topIsAir = level.m_8055_(pos).m_60713_(Blocks.f_50016_);
        boolean bottomIsNotAir = !level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50016_);
        return topIsAir && bottomIsNotAir;
    }

    public float[] getOpenness() {
        long now = System.currentTimeMillis();
        if (this.isOpen()) {
            long openWindow = 5000L;
            long sinceOpen = this.previousTick - this.lastOpenTime;
            long untilClose = this.openUntil - now;
            float normalization = now - this.previousTick;
            if (sinceOpen < 5000L) {
                this.animTicker = 0.0f;
                this.previousTick = now;
                return new float[]{Math.min(1.0f, (float)sinceOpen / 5000.0f), 0.0f};
            }
            if (untilClose < 5000L) {
                this.animTicker = Math.max(0.0f, this.animTicker - 0.01f);
                this.velocity = 0.0f;
                this.rotation = (float)((double)this.rotation + Math.min((double)0.01f, (Math.PI * 2 - (double)this.rotation % (Math.PI * 2)) / 100.0) * (double)normalization);
                this.previousTick = now;
                return new float[]{Math.min(1.0f, (float)untilClose / 5000.0f) + this.animTicker, this.rotation};
            }
            this.animTicker += 0.004f;
            if (this.animTicker >= 1.8f) {
                this.animTicker = -1.8f;
            }
            this.velocity = Math.min(0.01f, this.velocity + 1.0E-6f * normalization);
            this.rotation += this.velocity * normalization;
            this.previousTick = now;
            return new float[]{1.0f + Math.abs(this.animTicker), this.rotation};
        }
        this.animTicker = 0.0f;
        this.rotation = 0.0f;
        this.velocity = 0.0f;
        this.previousTick = now;
        return new float[]{0.0f, 0.0f};
    }

    public void activate(Player player, BlockState state, ItemStack item) {
        MysteryBoxEvent.Activate event = new MysteryBoxEvent.Activate(this, player, state, item, Items.f_42419_);
        if (!Pixelmon.EVENT_BUS.post((Event)event)) {
            if (this.tryOpen(player, state, item)) {
                return;
            }
            if (this.isOnCooldown()) {
                player.m_213846_((Component)Component.m_237115_((String)"block.pixelmon.mystery_box.cooldown"));
            } else if (item.m_41720_() == event.getAcceptedItem()) {
                if (this.feedScrap(player, state, item)) {
                    if (!player.m_7500_()) {
                        item.m_41774_(1);
                    }
                    player.f_19853_.m_5594_(null, this.m_58899_(), this.scrapsLeft <= 0 ? (SoundEvent)SoundRegistration.MYSTERY_BOX_ADD_DONE.get() : (SoundEvent)SoundRegistration.MYSTERY_BOX_ADD.get(), SoundSource.BLOCKS, 1.0f, 0.5f + RandomHelper.getRandom().nextFloat());
                }
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"block.pixelmon.mystery_box.scraps"));
            }
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
        super.m_6596_();
    }

    public void prepareForDrop() {
        this.openUntil = -1L;
    }

    protected void updateSignal() {
        Block block;
        int power = this.getPower();
        if (this.lastPower != power && (block = this.m_58900_().m_60734_()) instanceof MysteryBoxBlock) {
            this.f_58857_.m_7696_(this.f_58858_, block, 1, power);
            this.f_58857_.m_46672_(this.f_58858_, block);
        }
        this.lastPower = power;
    }

    public static void tick(Level level, BlockPos p_155254_, BlockState p_155255_, MysteryBoxTileEntity blockEntity) {
        if (blockEntity.isOpen() && !Pixelmon.EVENT_BUS.post((Event)new MysteryBoxEvent.Tick.Start(blockEntity, blockEntity.m_58900_())) && level != null) {
            boolean nearlyClosed;
            long untilClose = blockEntity.openUntil - System.currentTimeMillis();
            boolean bl = nearlyClosed = untilClose <= 6000L;
            if (!nearlyClosed) {
                blockEntity.open = true;
                if (blockEntity.m_58904_().m_5776_()) {
                    if (System.currentTimeMillis() - blockEntity.lastOpenTime > 5000L && RandomHelper.getRandomChance(100)) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)blockEntity.m_58899_().m_123341_() + 0.5, (double)blockEntity.m_58899_().m_123342_() + 0.9, (double)blockEntity.m_58899_().m_123343_() + 0.5, (RandomHelper.getRandom().nextDouble() - 0.5) * 0.75, 0.0, (RandomHelper.getRandom().nextDouble() - 0.5) * 0.75);
                    }
                } else {
                    MysteryBoxEvent.Tick.TrySpawn trySpawn = new MysteryBoxEvent.Tick.TrySpawn(blockEntity, blockEntity.m_58900_(), PixelmonConfigProxy.getSpawning().getMeltanBoxSpawnRate());
                    if (!Pixelmon.EVENT_BUS.post((Event)trySpawn) && trySpawn.rollChance()) {
                        int r = PixelmonConfigProxy.getSpawning().getMeltanBoxSpawnRadius();
                        BlockPos initialPos = blockEntity.m_58899_().m_7918_(RandomHelper.getRandom().nextInt(r * 2) - r, 0, RandomHelper.getRandom().nextInt(r * 2) - r);
                        BlockPos pos = blockEntity.findYSpawnOffset(level, initialPos, r);
                        if (pos != null) {
                            PixelmonSpecies.MELTAN.getValue().ifPresent(meltan -> {
                                Pokemon toSpawn = PokemonFactory.create(meltan);
                                boolean shiny = PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)level.m_46472_()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)level.m_46472_()));
                                toSpawn.setShiny(shiny);
                                PixelmonEntity entity = toSpawn.getOrCreatePixelmon(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                                entity.setAggression(Aggression.TIMID);
                                if (!Pixelmon.EVENT_BUS.post((Event)new MysteryBoxEvent.Tick.DoSpawn(blockEntity, blockEntity.m_58900_(), entity))) {
                                    level.m_7967_((Entity)entity);
                                    level.m_5594_(null, blockEntity.m_58899_(), (SoundEvent)SoundRegistration.MYSTERY_BOX_SPAWN.get(), SoundSource.BLOCKS, 1.0f, RandomHelper.getRandom().nextFloat());
                                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 15, (RandomHelper.getRandom().nextDouble() - 0.5) * 0.01, RandomHelper.getRandom().nextDouble() * 0.01, (RandomHelper.getRandom().nextDouble() - 0.5) * 0.01, 0.1);
                                }
                            });
                        }
                    }
                }
            } else if (blockEntity.open && !Pixelmon.EVENT_BUS.post((Event)new MysteryBoxEvent.Tick.AboutToClose(blockEntity, blockEntity.m_58900_()))) {
                level.m_5594_(null, blockEntity.m_58899_(), (SoundEvent)SoundRegistration.MYSTERY_BOX_CLOSE.get(), SoundSource.BLOCKS, 0.2f, 0.5f);
                blockEntity.open = false;
            }
        }
        blockEntity.updateSignal();
    }
}

