/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.MusicBlock;
import com.pixelmonmod.pixelmon.client.music.BattleMusic;
import com.pixelmonmod.pixelmon.client.music.VoidMusicTicker;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MusicBlockTileEntity
extends BlockEntity {
    private ResourceLocation track = ResourceLocationHelper.of("pixelmon", "pixelmon.music.pokecenter");
    private BlockPos offset = new BlockPos(0, 0, 0);
    private BlockPos size = new BlockPos(1, 1, 1);
    @OnlyIn(value=Dist.CLIENT)
    private BlockSoundRecord soundRecord;

    public MusicBlockTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.MUSIC_BLOCK.get(), blockPos, blockState);
    }

    public MusicBlockTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientUpdate() {
        if (this.f_58857_.m_46467_() % 8L != 1L) {
            return;
        }
        AABB aabb = new AABB(this.f_58858_).m_82338_(this.offset);
        aabb = aabb.m_82363_((double)this.size.m_123341_(), (double)this.size.m_123342_(), (double)this.size.m_123343_());
        aabb = aabb.m_82363_((double)(-this.size.m_123341_()), (double)(-this.size.m_123342_()), (double)(-this.size.m_123343_()));
        if (this.soundRecord == null && this.track != null) {
            BlockPos pos = this.m_58899_();
            this.soundRecord = new BlockSoundRecord(this.track, SoundSource.MUSIC, 0, pos, aabb);
        }
        Minecraft mc = Minecraft.m_91087_();
        if (aabb.m_82381_(mc.f_91074_.m_20191_()) && !mc.m_91106_().m_120403_((SoundInstance)this.soundRecord) && !BattleMusic.isPlaying()) {
            this.soundRecord = new BlockSoundRecord(this.track, SoundSource.MUSIC, 0, this.f_58858_, aabb);
            mc.m_91106_().m_120367_((SoundInstance)this.soundRecord);
            VoidMusicTicker.replaceMusicTicker();
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("track")) {
            this.track = ResourceLocationHelper.of(compound.m_128461_("track"));
        }
        if (compound.m_128441_("offsetX") || compound.m_128441_("offsetY") || compound.m_128441_("offsetZ")) {
            this.offset = new BlockPos(compound.m_128451_("offsetX"), compound.m_128451_("offsetY"), compound.m_128451_("offsetZ"));
        }
        if (compound.m_128441_("sizeX") || compound.m_128441_("sizeY") || compound.m_128441_("sizeZ")) {
            this.size = new BlockPos(compound.m_128451_("sizeX"), compound.m_128451_("sizeY"), compound.m_128451_("sizeZ"));
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128359_("track", this.track.toString());
        if (this.offset.m_121878_() != 0L) {
            compound.m_128405_("offsetX", this.offset.m_123341_());
            compound.m_128405_("offsetY", this.offset.m_123342_());
            compound.m_128405_("offsetZ", this.offset.m_123343_());
        }
        compound.m_128405_("sizeX", this.size.m_123341_());
        compound.m_128405_("sizeY", this.size.m_123342_());
        compound.m_128405_("sizeZ", this.size.m_123343_());
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public static void tick(Level level, BlockPos p_155254_, BlockState p_155255_, MusicBlockTileEntity blockEntity) {
        if (level.f_46443_) {
            blockEntity.clientUpdate();
        }
    }

    public static class BlockSoundRecord
    extends SimpleSoundInstance
    implements TickableSoundInstance {
        BlockPos pos;
        AABB aabb;
        int endTick;

        public BlockSoundRecord(ResourceLocation soundId, SoundSource categoryIn, int repeatDelayIn, BlockPos pos, AABB aabb) {
            super(soundId, categoryIn, 0.1f, 1.0f, RandomSource.m_216327_(), true, repeatDelayIn, SoundInstance.Attenuation.NONE, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), false);
            this.pos = pos;
            this.aabb = aabb;
        }

        public void m_7788_() {
            Minecraft mc = Minecraft.m_91087_();
            if (!this.aabb.m_82381_(mc.f_91074_.m_20191_()) || !(mc.f_91073_.m_8055_(this.pos).m_60734_() instanceof MusicBlock)) {
                ++this.endTick;
                this.f_119573_ = Math.max(0.0f, 1.0f - (float)this.endTick / 100.0f);
            } else {
                this.endTick = 0;
                if (this.f_119573_ != 1.0f) {
                    this.f_119573_ = Math.min(1.0f, this.f_119573_ + 0.05f);
                }
            }
        }

        public boolean m_7801_() {
            if (this.endTick >= 100 || BattleMusic.isPlaying()) {
                if (!BattleMusic.isPlaying()) {
                    VoidMusicTicker.restoreMusicTicker();
                }
                return true;
            }
            return false;
        }
    }
}

