/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.blocks.tileentity.IBasicInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class InventoryTileEntity
extends BlockEntity
implements IBasicInventory,
MenuProvider {
    private final int inventorySize;
    private final int rows;
    private final String inventoryName;
    private NonNullList<ItemStack> contents;
    private String customName;

    protected InventoryTileEntity(BlockEntityType<?> type, String inventoryName, int rows, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
        this.rows = rows;
        this.inventorySize = rows * 9;
        this.inventoryName = inventoryName;
        this.contents = NonNullList.m_122780_((int)this.inventorySize, (Object)ItemStack.f_41583_);
    }

    public NonNullList<ItemStack> getContents() {
        return this.contents;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("CustomName", 8)) {
            this.customName = nbt.m_128461_("CustomName");
        }
        this.contents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (nbt.m_128441_("Items")) {
            ListTag itemsList = nbt.m_128437_("Items", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                CompoundTag nbttagcompound = itemsList.m_128728_(i);
                byte slot = nbttagcompound.m_128445_("Slot");
                if (slot < 0 || slot >= this.contents.size()) continue;
                this.contents.set((int)slot, (Object)ItemStack.m_41712_((CompoundTag)nbttagcompound));
            }
        }
    }

    public boolean addToInventory(ItemStack stack) {
        for (int i = 0; i < this.contents.size(); ++i) {
            if (((ItemStack)this.contents.get(i)).m_41619_()) {
                this.contents.set(i, (Object)stack);
                return true;
            }
            if (((ItemStack)this.contents.get(i)).m_41613_() >= 64) continue;
            if (((ItemStack)this.contents.get(i)).m_41613_() + stack.m_41613_() > 64) {
                stack.m_41764_((((ItemStack)this.contents.get(i)).m_41613_() + stack.m_41613_()) % 64);
                ((ItemStack)this.contents.get(i)).m_41764_(64);
                return this.addToInventory(stack);
            }
            ((ItemStack)this.contents.get(i)).m_41764_(((ItemStack)this.contents.get(i)).m_41613_() + stack.m_41613_());
            return true;
        }
        return false;
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.hasCustomName()) {
            nbt.m_128359_("CustomName", this.customName);
        }
        ListTag itemsList = new ListTag();
        nbt.m_128365_("Items", (Tag)itemsList);
        for (int slot = 0; slot < this.contents.size(); ++slot) {
            if (((ItemStack)this.contents.get(slot)).m_41619_()) continue;
            CompoundTag item = ((ItemStack)this.contents.get(slot)).serializeNBT();
            item.m_128344_("Slot", (byte)slot);
            itemsList.add((Object)item);
        }
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.contents) {
            if (itemstack == null || itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.contents.get(index);
    }

    @Override
    public ItemStack m_7407_(int index, int count) {
        if (!((ItemStack)this.contents.get(index)).m_41619_()) {
            if (((ItemStack)this.contents.get(index)).m_41613_() <= count) {
                ItemStack itemStack = (ItemStack)this.contents.get(index);
                this.contents.set(index, (Object)ItemStack.f_41583_);
                this.m_6596_();
                return itemStack;
            }
            ItemStack itemstack = ((ItemStack)this.contents.get(index)).m_41620_(count);
            if (((ItemStack)this.contents.get(index)).m_41613_() == 0) {
                this.contents.set(index, (Object)ItemStack.f_41583_);
                this.m_6596_();
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack m_8016_(int index) {
        ItemStack itemStack = (ItemStack)this.contents.get(index);
        this.contents.set(index, (Object)ItemStack.f_41583_);
        this.m_6596_();
        return itemStack;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.contents.set(index, (Object)stack);
        this.m_6596_();
    }

    @Override
    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public String getCustomName() {
        return this.hasCustomName() ? this.customName : this.inventoryName;
    }

    public boolean hasCustomName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public Component m_5446_() {
        return this.hasCustomName() ? Component.m_237113_((String)this.getCustomName()) : Component.m_237115_((String)this.getCustomName());
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        MenuType containerType = MenuType.f_39959_;
        switch (this.rows) {
            case 1: {
                containerType = MenuType.f_39957_;
                break;
            }
            case 2: {
                containerType = MenuType.f_39958_;
                break;
            }
            case 3: {
                containerType = MenuType.f_39959_;
                break;
            }
            case 4: {
                containerType = MenuType.f_39960_;
                break;
            }
            case 5: {
                containerType = MenuType.f_39961_;
                break;
            }
            case 6: {
                containerType = MenuType.f_39962_;
            }
        }
        return new ChestMenu(containerType, id, inventory, (Container)this, this.rows);
    }

    public int m_6643_() {
        return this.inventorySize;
    }
}

