/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.api.recipe.InfuserRecipe;
import com.pixelmonmod.pixelmon.client.gui.machines.infuser.InfuserContainer;
import com.pixelmonmod.pixelmon.init.registry.RecipeTypeRegistration;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class InfuserTileEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer {
    private static final int INFUSION_TIME = 200;
    public int infuserRunTime;
    public int currentItemRunTime;
    public int infuserProgressTime;
    public int renderPass = 0;
    public boolean isRunning = false;
    public Item itemOnInfuser = null;
    public Item secondItemOnInfuser = null;
    public int state = 0;
    public int frame = 0;
    private NonNullList<ItemStack> infuserItemStacks = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private int stateTimer = 0;

    public InfuserTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.INFUSER.get(), blockPos, blockState);
    }

    public InfuserTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public int m_6643_() {
        return this.infuserItemStacks.size();
    }

    public NonNullList<ItemStack> getInfuserItemStacks() {
        return this.infuserItemStacks;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.infuserItemStacks) {
            if (itemstack == null || itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slotIndex) {
        return (ItemStack)this.infuserItemStacks.get(slotIndex);
    }

    public ItemStack m_7407_(int slotIndex, int decreaseBy) {
        if (!((ItemStack)this.infuserItemStacks.get(slotIndex)).m_41619_()) {
            ItemStack itemStack;
            if (((ItemStack)this.infuserItemStacks.get(slotIndex)).m_41613_() <= decreaseBy) {
                itemStack = (ItemStack)this.infuserItemStacks.get(slotIndex);
                this.infuserItemStacks.set(slotIndex, (Object)ItemStack.f_41583_);
            } else {
                itemStack = ((ItemStack)this.infuserItemStacks.get(slotIndex)).m_41777_();
                itemStack.m_41774_(decreaseBy);
                this.infuserItemStacks.set(slotIndex, (Object)itemStack);
                if (((ItemStack)this.infuserItemStacks.get(slotIndex)).m_41613_() == 0) {
                    this.infuserItemStacks.set(slotIndex, (Object)ItemStack.f_41583_);
                }
            }
            itemStack = itemStack.m_41777_();
            itemStack.m_41764_(decreaseBy);
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int slotIndex) {
        if (!((ItemStack)this.infuserItemStacks.get(slotIndex)).m_41619_()) {
            ItemStack itemStack = (ItemStack)this.infuserItemStacks.get(slotIndex);
            this.infuserItemStacks.set(slotIndex, (Object)ItemStack.f_41583_);
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slotIndex, ItemStack itemStack) {
        this.infuserItemStacks.set(slotIndex, (Object)itemStack);
        if (!itemStack.m_41619_() && itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int slotIndex, ItemStack itemStack) {
        ItemStack item = this.m_8020_(3);
        if (item != null && !item.m_41619_()) {
            return false;
        }
        switch (slotIndex) {
            case 0: {
                return ForgeHooks.getBurnTime((ItemStack)itemStack, (RecipeType)RecipeType.f_44108_) > 0;
            }
            case 1: {
                return itemStack.m_204131_().anyMatch(r -> r.f_203868_().toString().equalsIgnoreCase("pixelmon:berries")) || itemStack.m_41720_() == Items.f_42533_;
            }
            case 3: {
                return false;
            }
        }
        return true;
    }

    public int[] m_7071_(Direction side) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int slotIndex, ItemStack itemStack, Direction direction) {
        switch (slotIndex) {
            case 0: {
                return itemStack.m_41720_() == Items.f_42446_;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        nbt.m_128379_("isRunning", this.isRunning());
        if (!((ItemStack)this.infuserItemStacks.get(1)).m_41619_()) {
            nbt.m_128365_("itemInInfuser", (Tag)((ItemStack)this.infuserItemStacks.get(1)).m_41739_(new CompoundTag()));
        }
        if (!((ItemStack)this.infuserItemStacks.get(2)).m_41619_()) {
            nbt.m_128365_("secondaryItemInInfuser", (Tag)((ItemStack)this.infuserItemStacks.get(2)).m_41739_(new CompoundTag()));
        }
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbt = pkt.m_131708_();
        this.isRunning = nbt.m_128471_("isRunning");
        this.itemOnInfuser = nbt.m_128441_("itemInInfuser") ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_("itemInInfuser")).m_41720_() : null;
        this.secondItemOnInfuser = nbt.m_128441_("secondaryItemInInfuser") ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_("secondaryItemInInfuser")).m_41720_() : null;
        if (this.isRunning) {
            this.frame = 0;
        } else {
            this.itemOnInfuser = null;
            this.secondItemOnInfuser = null;
        }
    }

    public void m_142466_(CompoundTag nbtTagCompound) {
        super.m_142466_(nbtTagCompound);
        ListTag nbttaglist = nbtTagCompound.m_128437_("Items", 10);
        this.infuserItemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundTag nbttagcompound1 = nbttaglist.m_128728_(i);
            byte b0 = nbttagcompound1.m_128445_("Slot");
            if (b0 < 0 || b0 >= this.infuserItemStacks.size()) continue;
            this.infuserItemStacks.set((int)b0, (Object)ItemStack.m_41712_((CompoundTag)nbttagcompound1));
        }
        this.infuserRunTime = nbtTagCompound.m_128448_("RunTime");
        this.infuserProgressTime = nbtTagCompound.m_128448_("InfusionTime");
        this.currentItemRunTime = ((ItemStack)this.infuserItemStacks.get(1)).getBurnTime(RecipeType.f_44108_);
    }

    public void m_183515_(CompoundTag nbtTagCompound) {
        super.m_183515_(nbtTagCompound);
        nbtTagCompound.m_128376_("RunTime", (short)this.infuserRunTime);
        nbtTagCompound.m_128376_("InfusionTime", (short)this.infuserProgressTime);
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < this.infuserItemStacks.size(); ++i) {
            if (((ItemStack)this.infuserItemStacks.get(i)).m_41619_()) continue;
            CompoundTag nbttagcompound1 = new CompoundTag();
            nbttagcompound1.m_128344_("Slot", (byte)i);
            ((ItemStack)this.infuserItemStacks.get(i)).m_41739_(nbttagcompound1);
            nbttaglist.add((Object)nbttagcompound1);
        }
        nbtTagCompound.m_128365_("Items", (Tag)nbttaglist);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getInfusionProgressScaled(int p_145953_1_) {
        return this.infuserProgressTime * p_145953_1_ / 200;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBurnTimeRemainingScaled(int p_145955_1_) {
        if (this.currentItemRunTime == 0) {
            this.currentItemRunTime = 200;
        }
        return this.infuserRunTime * p_145955_1_ / this.currentItemRunTime;
    }

    public boolean isRunning() {
        return this.infuserRunTime > 0;
    }

    private boolean createInfuserItem(InfuserRecipe recipe, IItemHandler tileInventory) {
        ItemStack currentOut = (ItemStack)this.infuserItemStacks.get(3);
        if (currentOut.m_41619_()) {
            this.infuserProgressTime = 0;
            ((ItemStack)this.infuserItemStacks.get(1)).m_41774_(recipe.getQualifiedIngredients().get((int)0).quantity);
            ((ItemStack)this.infuserItemStacks.get(2)).m_41774_(recipe.getQualifiedIngredients().get((int)1).quantity);
            this.infuserItemStacks.set(3, (Object)recipe.m_5874_((Container)this, (RegistryAccess)RegistryAccess.f_243945_).m_41777_());
            return true;
        }
        if (tileInventory != null && recipe != null && Math.min(tileInventory.getSlotLimit(3), ((ItemStack)this.infuserItemStacks.get(3)).m_41741_()) >= currentOut.m_41613_() + recipe.m_5874_((Container)this, (RegistryAccess)RegistryAccess.f_243945_).m_41613_()) {
            this.infuserProgressTime = 0;
            ((ItemStack)this.infuserItemStacks.get(1)).m_41774_(recipe.getQualifiedIngredients().get((int)0).quantity);
            ((ItemStack)this.infuserItemStacks.get(2)).m_41774_(recipe.getQualifiedIngredients().get((int)1).quantity);
            currentOut.m_41769_(recipe.m_5874_((Container)this, (RegistryAccess)RegistryAccess.f_243945_).m_41613_());
            this.infuserItemStacks.set(3, (Object)currentOut);
            return true;
        }
        return false;
    }

    public void m_5856_(Player playerIn) {
    }

    public void m_5785_(Player playerIn) {
    }

    public void m_6211_() {
    }

    public Component m_5446_() {
        return Component.m_237119_();
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new InfuserContainer(id, inventory, this);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, InfuserTileEntity blockEntity) {
        boolean flag = blockEntity.infuserRunTime > 0;
        boolean flag1 = false;
        if (!blockEntity.f_58857_.f_46443_) {
            if (blockEntity.infuserRunTime > 0) {
                --blockEntity.infuserRunTime;
                if (blockEntity.infuserRunTime == 0) {
                    ((ServerLevel)blockEntity.f_58857_).m_7726_().m_8450_(blockEntity.f_58858_);
                    blockEntity.isRunning = false;
                }
            }
            if (((ItemStack)blockEntity.infuserItemStacks.get(1)).m_41619_() || ((ItemStack)blockEntity.infuserItemStacks.get(2)).m_41619_()) {
                blockEntity.infuserProgressTime = 0;
            }
            if (blockEntity.infuserRunTime != 0 || !((ItemStack)blockEntity.infuserItemStacks.get(2)).m_41619_() && !((ItemStack)blockEntity.infuserItemStacks.get(1)).m_41619_() && !((ItemStack)blockEntity.infuserItemStacks.get(0)).m_41619_()) {
                if (blockEntity.infuserRunTime == 0) {
                    blockEntity.currentItemRunTime = blockEntity.infuserRunTime = ForgeHooks.getBurnTime((ItemStack)((ItemStack)blockEntity.infuserItemStacks.get(0)), (RecipeType)RecipeType.f_44108_);
                    ((ServerLevel)blockEntity.f_58857_).m_7726_().m_8450_(blockEntity.f_58858_);
                    if (blockEntity.infuserRunTime > 0) {
                        flag1 = true;
                        blockEntity.isRunning = true;
                        if (!((ItemStack)blockEntity.infuserItemStacks.get(0)).m_41619_()) {
                            if (((ItemStack)blockEntity.infuserItemStacks.get(0)).m_41613_() == 1) {
                                blockEntity.infuserItemStacks.set(0, (Object)((ItemStack)blockEntity.infuserItemStacks.get(0)).m_41720_().getCraftingRemainingItem((ItemStack)blockEntity.infuserItemStacks.get(0)));
                            } else {
                                ((ItemStack)blockEntity.infuserItemStacks.get(0)).m_41774_(1);
                            }
                        }
                    }
                }
                if (blockEntity.isRunning) {
                    LazyOptional cap = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN);
                    Object tileInventory = cap.isPresent() ? (IItemHandler)cap.orElseThrow(AssertionError::new) : new InvWrapper((Container)blockEntity);
                    boolean nonColorfulShakeFound = false;
                    for (RecipeHolder recipe : ServerLifecycleHooks.getCurrentServer().m_129894_().m_44013_(RecipeTypeRegistration.INFUSER_RECIPE_TYPE)) {
                        if (recipe == null || Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((InfuserRecipe)recipe.f_291008_()).m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41720_()).m_135815_().equalsIgnoreCase("colorful_shake")).booleanValue() || !((InfuserRecipe)recipe.f_291008_()).m_5818_((Container)blockEntity, blockEntity.f_58857_)) continue;
                        ++blockEntity.infuserProgressTime;
                        if (blockEntity.infuserProgressTime >= 200) {
                            blockEntity.createInfuserItem((InfuserRecipe)recipe.f_291008_(), (IItemHandler)tileInventory);
                        }
                        flag1 = true;
                        nonColorfulShakeFound = true;
                        break;
                    }
                    if (!nonColorfulShakeFound) {
                        for (RecipeHolder recipe : ServerLifecycleHooks.getCurrentServer().m_129894_().m_44013_(RecipeTypeRegistration.INFUSER_RECIPE_TYPE)) {
                            if (recipe == null || !Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((InfuserRecipe)recipe.f_291008_()).m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41720_()).m_135815_().equalsIgnoreCase("colorful_shake")).booleanValue() || !((InfuserRecipe)recipe.f_291008_()).m_5818_((Container)blockEntity, blockEntity.f_58857_)) continue;
                            ++blockEntity.infuserProgressTime;
                            if (blockEntity.infuserProgressTime >= 200) {
                                blockEntity.createInfuserItem((InfuserRecipe)recipe.f_291008_(), (IItemHandler)tileInventory);
                            }
                            flag1 = true;
                            break;
                        }
                    }
                }
            }
            if (flag != blockEntity.infuserRunTime > 0) {
                flag1 = true;
            }
        }
        if (flag1) {
            blockEntity.m_6596_();
        }
        if (blockEntity.isRunning) {
            blockEntity.frame += 2;
            if (blockEntity.frame == 200) {
                blockEntity.f_58857_.m_5594_(null, blockEntity.f_58858_, SoundEvents.f_12059_, SoundSource.BLOCKS, 0.7f, 1.0f);
            }
            if (blockEntity.frame > 399) {
                blockEntity.frame = 0;
            }
            ++blockEntity.stateTimer;
            if (blockEntity.stateTimer > 66 && blockEntity.state == 0) {
                blockEntity.state = 1;
            }
            if (blockEntity.stateTimer > 133 && blockEntity.state == 1) {
                blockEntity.state = 2;
            }
            if (blockEntity.stateTimer >= 199) {
                blockEntity.state = 0;
            }
            if (blockEntity.stateTimer == 200) {
                blockEntity.stateTimer = 0;
            }
        } else {
            blockEntity.frame = 0;
            blockEntity.stateTimer = 0;
            blockEntity.state = 0;
        }
    }
}

