/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.legendary.IlexShrineEvent;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.EncounterData;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.blocks.enums.EnumBlockPos;
import com.pixelmonmod.pixelmon.blocks.machines.IlexShrineBlock;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.PokeBallPart;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.Event;

public class IlexShrineTileEntity
extends BlockEntity {
    public EncounterData encounters = new EncounterData(PixelmonConfigProxy.getGeneral().getShrineEncounterMode());

    public IlexShrineTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.ILEX_SHRINE.get(), blockPos, blockState);
    }

    public IlexShrineTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("EncounterData", (Tag)this.encounters.write(new CompoundTag()));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.encounters = new EncounterData(PixelmonConfigProxy.getGeneral().getShrineEncounterMode());
        if (nbt.m_128441_("EncounterData")) {
            this.encounters.read(nbt.m_128469_("EncounterData"));
        }
    }

    public void activate(Player player, IlexShrineBlock block, BlockState state, ItemStack item) {
        if (item != null && item.m_41720_() == PixelmonItems.poke_ball && !player.f_19853_.f_46443_) {
            PokeBallPart.getPokeBall(item).ifPresent(ball -> {
                if (ball.is(PokeBallRegistry.GS_BALL)) {
                    Species species = PixelmonSpecies.CELEBI.getValueUnsafe();
                    PlayerPartyStorage party = StorageProxy.getPartyNow((ServerPlayer)player);
                    if (BattleRegistry.getBattle(player) == null) {
                        boolean shiny;
                        String spec = species.getName();
                        PixelmonEntity pixelmonEntity = PokemonSpecificationProxy.create(spec).get().create(player.f_19853_);
                        boolean bl = shiny = PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)this.f_58857_.m_46472_()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)this.f_58857_.m_46472_()));
                        if (shiny) {
                            pixelmonEntity.getPokemon().setPalette("shiny");
                        }
                        pixelmonEntity.m_6034_(this.f_58858_.m_123341_(), this.f_58858_.m_123342_() + 2, this.f_58858_.m_123343_());
                        IlexShrineEvent.Pre pre = new IlexShrineEvent.Pre((ServerPlayer)player, block, pixelmonEntity, this);
                        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                            return;
                        }
                        if (this.encounters.canEncounter(player)) {
                            PixelmonEntity startingPixelmon;
                            if (Pixelmon.EVENT_BUS.post((Event)new IlexShrineEvent((ServerPlayer)player, block, pre.getEntity(), this))) {
                                return;
                            }
                            if (this.encounters.getMode() == EnumEncounterMode.Once) {
                                player.f_19853_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)IlexShrineBlock.USED, (Comparable)Boolean.valueOf(true)), 2);
                                player.f_19853_.m_7731_(this.f_58858_.m_7494_(), (BlockState)((BlockState)state.m_61124_((Property)IlexShrineBlock.USED, (Comparable)Boolean.valueOf(true))).m_61124_(IlexShrineBlock.BLOCKPOS, (Comparable)((Object)EnumBlockPos.TOP)), 2);
                            }
                            if ((startingPixelmon = party.getAndSendOutFirstAblePokemon((Entity)player)) == null) {
                                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.partyfainted", new Object[0]);
                                return;
                            }
                            this.encounters.registerEncounter(player);
                            player.f_19853_.m_7967_((Entity)pre.getEntity());
                            item.m_41774_(1);
                            PlayerParticipant playerParticipant = new PlayerParticipant((ServerPlayer)player, startingPixelmon);
                            WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(false, pre.getEntity());
                            wildPixelmonParticipant.startedBattle = true;
                            BattleRegistry.startBattle(playerParticipant, wildPixelmonParticipant);
                            Pixelmon.EVENT_BUS.post((Event)new IlexShrineEvent.Post((ServerPlayer)player, block, pre.getEntity(), this));
                        } else if (this.encounters.getMode().isTimedAccess()) {
                            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.shrine.today", new Object[0]);
                        } else {
                            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.shrine.encountered", new Object[0]);
                        }
                    } else {
                        ChatHandler.sendChat((Entity)player, "pixelmon.blocks.partyfainted", new Object[0]);
                    }
                }
            });
        }
    }
}

