/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class HealerTileEntity
extends BlockEntity {
    private static final int TICKS_TO_PLACE = 5;
    private static final int TICKS_TO_HEAL = 100;
    private UUID owner = null;
    public boolean beingUsed = false;
    public PokeBall[] pokeballType = new PokeBall[6];
    private PlayerPartyStorage storage;
    public Player player;
    private int pokemonLastPlaced = -1;
    private float healingRate = 1.0f;
    private int tickCount = 0;
    public float rotation = 0.0f;
    public int flashTimer = 0;
    public boolean allPlaced = false;
    public boolean playSound = false;
    public boolean stayDark = false;

    public HealerTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.HEALER.get(), blockPos, blockState);
    }

    public HealerTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void use(NPCNurseJoy npc, Player player) {
        this.startHealing(player, 2.0f, npc.getTextureIndex());
    }

    public void use(Player player) {
        this.startHealing(player, 1.0f, 0);
    }

    private void startHealing(Player player, float healingRate, int textureIndex) {
        this.healingRate = healingRate;
        this.storage = StorageProxy.getPartyNow((ServerPlayer)player);
        this.storage.teleportPos.store((ResourceKey<Level>)player.m_20193_().m_46472_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), player.f_19857_, player.f_19858_);
        this.player = player;
        this.beingUsed = true;
        if (healingRate == 2.0f) {
            OpenScreenPacket.open(player, EnumGuiScreen.HealerNurseJoy, textureIndex);
        } else {
            OpenScreenPacket.open(player, EnumGuiScreen.Healer, new int[0]);
        }
        this.tickCount = 0;
        this.allPlaced = false;
        this.pokemonLastPlaced = -1;
        for (int i = 0; i < this.pokeballType.length; ++i) {
            this.pokeballType[i] = null;
        }
        this.stayDark = false;
        if (!this.f_58857_.f_46443_ && this.beingUsed) {
            this.sendRedstoneSignal();
        }
    }

    public void setColor(DyeColor dyeColor) {
        this.f_58857_.m_7731_(this.m_58899_(), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("pixelmon", dyeColor.name().toLowerCase(Locale.ROOT) + "_healer"))).m_49966_(), 3);
    }

    private int getTicksToHeal() {
        return (int)(100.0f / this.healingRate);
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.m_6596_();
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.owner != null) {
            compound.m_128359_("owner", this.owner.toString());
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("owner")) {
            this.owner = UUID.fromString(compound.m_128461_("owner"));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        for (int i = 0; i < this.pokeballType.length; ++i) {
            if (this.pokeballType[i] == null) continue;
            nbt.m_128359_("PokeballType" + i, this.pokeballType[i].getName());
        }
        nbt.m_128379_("BeingUsed", this.beingUsed);
        nbt.m_128379_("AllPlaced", this.allPlaced);
        nbt.m_128379_("StayDark", this.stayDark);
        nbt.m_128350_("HealRate", this.healingRate);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compound = pkt.m_131708_();
        this.m_142466_(compound);
        for (int i = 0; i < this.pokeballType.length; ++i) {
            this.pokeballType[i] = null;
            if (!compound.m_128441_("PokeballType" + i)) continue;
            this.pokeballType[i] = PokeBallRegistry.getPokeBall(compound.m_128461_("PokeballType" + i)).orElse((Object)null);
        }
        if (compound.m_128441_("BeingUsed")) {
            this.beingUsed = compound.m_128471_("BeingUsed");
            this.allPlaced = compound.m_128471_("AllPlaced");
            this.stayDark = compound.m_128471_("StayDark");
        }
        if (compound.m_128441_("HealRate")) {
            this.healingRate = compound.m_128457_("HealRate");
        }
    }

    private void sendRedstoneSignal() {
        Block block = this.m_58900_().m_60734_();
        this.f_58857_.m_46672_(this.f_58858_, block);
    }

    private void refreshTexture() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
            this.m_6596_();
        }
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean isBeingUsed() {
        return this.beingUsed;
    }

    public PokeBall[] getPokeballType() {
        return this.pokeballType;
    }

    public PlayerPartyStorage getStorage() {
        return this.storage;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getPokemonLastPlaced() {
        return this.pokemonLastPlaced;
    }

    public float getHealingRate() {
        return this.healingRate;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public float getRotation() {
        return this.rotation;
    }

    public int getFlashTimer() {
        return this.flashTimer;
    }

    public boolean isAllPlaced() {
        return this.allPlaced;
    }

    public boolean isPlaySound() {
        return this.playSound;
    }

    public boolean isStayDark() {
        return this.stayDark;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HealerTileEntity blockEntity) {
        if (level.f_46443_) {
            blockEntity.rotation += 19.0f;
            ++blockEntity.flashTimer;
            return;
        }
        if (blockEntity.beingUsed) {
            int ticksToHeal;
            if (blockEntity.allPlaced && !blockEntity.playSound) {
                level.m_5594_(null, blockEntity.f_58858_, (SoundEvent)SoundRegistration.HEALER_ACTIVATE.get(), SoundSource.BLOCKS, 0.7f, 1.0f);
                blockEntity.playSound = true;
            }
            ++blockEntity.tickCount;
            if (!blockEntity.allPlaced && blockEntity.tickCount == 5) {
                boolean hasNextPokemon = false;
                blockEntity.storage.retrieveAll("BlockInteract");
                for (int i = blockEntity.pokemonLastPlaced + 1; i < blockEntity.storage.getTeam().size(); ++i) {
                    if (blockEntity.storage.getTeam().get(i) == null) continue;
                    blockEntity.pokemonLastPlaced = i;
                    hasNextPokemon = true;
                    blockEntity.pokeballType[i] = blockEntity.storage.getTeam().get(i).getBall();
                    break;
                }
                if (!hasNextPokemon) {
                    blockEntity.allPlaced = true;
                }
                blockEntity.tickCount = 0;
                blockEntity.refreshTexture();
            }
            if (blockEntity.tickCount == (ticksToHeal = blockEntity.getTicksToHeal()) - 30) {
                blockEntity.stayDark = true;
                blockEntity.refreshTexture();
            }
            if (blockEntity.tickCount == ticksToHeal) {
                blockEntity.storage.getTeam().forEach(Pokemon::heal);
                blockEntity.beingUsed = false;
                blockEntity.playSound = false;
                blockEntity.refreshTexture();
                blockEntity.player.m_6915_();
                if (!blockEntity.f_58857_.f_46443_) {
                    blockEntity.sendRedstoneSignal();
                }
            }
            level.m_7260_(blockEntity.f_58858_, state, state, 3);
        }
    }
}

