/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.enums.GymSignType;
import com.pixelmonmod.pixelmon.blocks.tileentity.ISpecialTexture;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class GymSignTileEntity
extends BlockEntity
implements ISpecialTexture {
    private ItemStack itemInSign = null;
    private UUID owner = null;
    private String colour = "red";
    private ResourceLocation texture = ResourceLocationHelper.of("pixelmon:textures/block/gymsign/red.png");
    private boolean itemDrops = true;
    private final GymSignType gymSignType;

    public GymSignTileEntity(GymSignType gymSignType, BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.GYM_SIGN.get(), blockPos, blockState);
        this.gymSignType = gymSignType;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemInSign = nbt.m_128441_("ItemIn") ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ItemIn")) : null;
        if (nbt.m_128441_("ItemDrops")) {
            this.itemDrops = nbt.m_128471_("ItemDrops");
        }
        if (nbt.m_128441_("owner")) {
            this.owner = UUID.fromString(nbt.m_128461_("owner"));
            this.colour = nbt.m_128461_("colour");
            this.refreshTexture();
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.itemInSign == null) {
            nbt.m_128473_("ItemIn");
        } else {
            CompoundTag itemTag = new CompoundTag();
            this.itemInSign.m_41739_(itemTag);
            nbt.m_128365_("ItemIn", (Tag)itemTag);
        }
        nbt.m_128379_("ItemDrops", this.itemDrops);
        if (this.owner != null) {
            nbt.m_128359_("colour", this.colour);
            nbt.m_128359_("owner", this.owner.toString());
        }
    }

    private void refreshTexture() {
        this.texture = ResourceLocationHelper.of("pixelmon:textures/block/gymsign/texture_" + this.colour.toLowerCase(Locale.ROOT) + ".png");
    }

    public String getColour() {
        return this.colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
        this.sendChanges();
        this.m_6596_();
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void sendChanges() {
        if (this.m_58898_() && this.m_58904_() instanceof ServerLevel) {
            this.f_58857_.m_6550_(this.f_58858_, this.m_58900_(), this.m_58900_());
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("colour", this.colour);
        this.m_183515_(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        CompoundTag data = pkt.m_131708_();
        this.colour = data.m_128461_("colour");
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.m_6596_();
    }

    public ItemStack getItemInSign() {
        return this.itemInSign;
    }

    public NonNullList<ItemStack> getContents() {
        return NonNullList.m_122780_((int)1, (Object)this.getItemInSign());
    }

    public void setItemInSign(ItemStack item) {
        this.itemInSign = item;
        this.m_6596_();
    }

    public void setDroppable(boolean b) {
        this.itemDrops = false;
    }

    public boolean isDroppable() {
        return this.itemDrops;
    }

    public GymSignType getGymSignType() {
        return this.gymSignType;
    }
}

