/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class GracideaTileEntity
extends BlockEntity {
    public static final float NEEDED_LIGHT = 14.0f;
    public static final int GROWTH_RANGE = 2;
    public static final float GROWTH_CHANCE = 1.0E-6f;
    private int ticks = 0;

    public GracideaTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.GRACIDEA.get(), blockPos, blockState);
    }

    public GracideaTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public boolean canGrow() {
        return !((float)this.f_58857_.m_45517_(LightLayer.SKY, this.f_58858_) < 14.0f);
    }

    public void doGrow() {
        this.ticks = 0;
        ArrayList dirs = Lists.newArrayList((Object[])new BlockPos[]{this.f_58858_.m_122019_(), this.f_58858_.m_122012_(), this.f_58858_.m_122029_(), this.f_58858_.m_122024_(), this.f_58858_.m_122019_().m_122029_(), this.f_58858_.m_122012_().m_122029_(), this.f_58858_.m_122019_().m_122024_(), this.f_58858_.m_122012_().m_122024_()});
        dirs.removeIf(pos -> {
            if (this.f_58857_.m_8055_(pos).m_60734_() != Blocks.f_50016_) {
                return true;
            }
            if (this.f_58857_.m_8055_(pos.m_7495_()).m_60734_() != Blocks.f_50440_) {
                return true;
            }
            if (this.f_58857_.m_8055_(pos).m_60734_() == PixelmonBlocks.gracidea) {
                return true;
            }
            return (float)this.f_58857_.m_45517_(LightLayer.SKY, pos) < 14.0f;
        });
        ArrayList<BlockPos> chosen = new ArrayList<BlockPos>();
        if (dirs.size() > 1) {
            chosen.add((BlockPos)dirs.remove(RandomHelper.getRandomNumberBetween(0, dirs.size() - 1)));
        } else if (dirs.size() == 1) {
            chosen.add((BlockPos)dirs.remove(0));
        }
        for (BlockPos pos2 : chosen) {
            BlockState state = PixelmonBlocks.gracidea.m_49966_();
            this.f_58857_.m_46597_(pos2, state);
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GracideaTileEntity blockEntity) {
        ++blockEntity.ticks;
        if (blockEntity.ticks % 20 == 0 && RandomHelper.getRandomChance(1.0E-6f) && blockEntity.canGrow()) {
            blockEntity.doGrow();
        }
    }
}

