/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.enums.items.EnumFossils;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.FossilItem;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FossilMachineTileEntity
extends BlockEntity {
    public static final int MAX_POKEMON_PROGRESS = 3200;
    public static final int MAX_FOSSIL_PROGRESS = 1600;
    public int renderPass = 0;
    public StatueEntity statue = null;
    public float fossilJitter;
    public int screenFlickerTick;
    public boolean staticFlicker = false;
    public int dotTicks = 0;
    public String dots = "";
    public boolean pokemonOccupied = false;
    public EnumFossils currentFossil = EnumFossils.NULL;
    public float fossilProgress = 0.0f;
    public String currentPokemon = "";
    public float pokemonProgress = 0.0f;
    public int completionRate = (int)((this.fossilProgress + this.pokemonProgress) * 2.0f / 96.0f);
    public int completionSync = 0;
    public boolean isShiny = false;
    public PokeBall pokeball = null;

    public FossilMachineTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.FOSSIL_MACHINE.get(), blockPos, blockState);
    }

    public FossilMachineTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void swapFossilForPokemon() {
        this.currentPokemon = this.currentFossil.getPokemon().getName();
        this.pokemonOccupied = true;
        ResourceKey world = this.m_58904_() == null ? null : this.m_58904_().m_46472_();
        this.isShiny = PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)world) > 0.0f && RandomHelper.getRandom().nextFloat() < 1.0f / PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)world);
        this.currentFossil = EnumFossils.NULL;
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.pokeball != null) {
            nbt.m_128359_("PokeballID", this.pokeball.getName());
        }
        nbt.m_128405_("CurrentFossil", this.currentFossil.getIndex());
        nbt.m_128405_("FossilType", this.currentFossil.getIndex());
        nbt.m_128350_("PokemonProgress", this.pokemonProgress);
        nbt.m_128350_("FossilProgress", this.fossilProgress);
        nbt.m_128359_("CurrentPokemon", this.currentPokemon);
        nbt.m_128379_("IsShiny", this.isShiny);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.pokeball = nbt.m_128425_("PokeballID", 8) ? PokeBallRegistry.getPokeBall(nbt.m_128461_("PokeballID")).orElse((Object)null) : null;
        if (nbt.m_128441_("CurrentFossil")) {
            int curFos = nbt.m_128451_("CurrentFossil");
            this.currentFossil = Item.m_41445_((int)curFos) instanceof FossilItem ? ((FossilItem)Item.m_41445_((int)curFos)).fossil : EnumFossils.NULL;
        }
        if (nbt.m_128441_("FossilType")) {
            this.currentFossil = EnumFossils.fromIndex(nbt.m_128451_("FossilType"));
        }
        this.fossilProgress = nbt.m_128457_("FossilProgress");
        this.pokemonProgress = nbt.m_128457_("PokemonProgress");
        this.currentPokemon = nbt.m_128461_("CurrentPokemon");
        this.pokemonOccupied = !this.currentPokemon.equals("");
        this.completionRate = (int)((this.fossilProgress + this.pokemonProgress) * 2.0f / 96.0f);
        if (nbt.m_128441_("IsShiny")) {
            this.isShiny = nbt.m_128471_("IsShiny");
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        nbt.m_128405_("CurrentFossil", this.currentFossil.getIndex());
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FossilMachineTileEntity blockEntity) {
        if (blockEntity.completionRate != 100 && (blockEntity.fossilProgress > 0.0f || blockEntity.pokemonProgress > 0.0f)) {
            blockEntity.completionRate = (int)((blockEntity.fossilProgress + blockEntity.pokemonProgress) * 2.0f / 96.0f);
            if (!level.f_46443_ && blockEntity.completionRate % 10 == 0 && blockEntity.completionSync != blockEntity.completionRate) {
                level.m_6550_(blockEntity.f_58858_, blockEntity.m_58900_(), blockEntity.m_58900_());
                blockEntity.completionSync = blockEntity.completionRate;
            }
        }
        if (blockEntity.currentFossil.getPokemon() != null) {
            if (blockEntity.fossilProgress < 1600.0f) {
                blockEntity.fossilProgress += 1.0f;
            } else if (!level.f_46443_) {
                blockEntity.swapFossilForPokemon();
                level.m_6550_(blockEntity.f_58858_, blockEntity.m_58900_(), blockEntity.m_58900_());
            }
        }
        if (blockEntity.pokemonOccupied && blockEntity.pokemonProgress < 3200.0f) {
            blockEntity.pokemonProgress += 1.0f;
        }
        if (++blockEntity.dotTicks > 10) {
            blockEntity.dotTicks = 0;
            blockEntity.dots = blockEntity.dots.length() < 6 ? blockEntity.dots + "." : "";
        }
        float f = blockEntity.fossilJitter = blockEntity.fossilJitter == 0.0f ? 0.01f : 0.0f;
        blockEntity.screenFlickerTick = blockEntity.staticFlicker ? --blockEntity.screenFlickerTick : ++blockEntity.screenFlickerTick;
        if (blockEntity.screenFlickerTick >= 8) {
            blockEntity.staticFlicker = true;
        } else if (blockEntity.screenFlickerTick <= 0) {
            blockEntity.staticFlicker = false;
        }
        if (blockEntity.completionRate < 98) {
            int num = blockEntity.completionRate <= 50 ? blockEntity.completionRate / 4 : (100 - blockEntity.completionRate) / 4;
            double var9 = (float)blockEntity.m_58899_().m_123342_() + 0.4f;
            for (int i = 0; i < num; ++i) {
                WorldHelper.spawnRedstoneParticle(level, (double)blockEntity.m_58899_().m_123341_() + 0.1 + (double)RandomHelper.getRandom().nextFloat() * 0.7, var9 + (double)RandomHelper.getRandom().nextFloat() + (double)(RandomHelper.getRandom().nextFloat() * 0.4f), (double)blockEntity.m_58899_().m_123343_() + 0.1 + (double)RandomHelper.getRandom().nextFloat() * 0.7, 0.0, 1.2, 1.0);
            }
        }
    }
}

