/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.blocks.tileentity.IFrameCounter;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.FossilItem;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FossilDisplayTileEntity
extends BlockEntity
implements IFrameCounter {
    private FossilItem itemInDisplay = null;
    private UUID owner = null;
    public int renderPass = 0;
    public int frame = 0;

    public FossilDisplayTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.FOSSIL_DISPLAY.get(), blockPos, blockState);
    }

    public FossilDisplayTileEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void openGlass() {
        if (this.getLastFrame() != 30) {
            return;
        }
    }

    public void closeGlass() {
        if (this.getLastFrame() != 0 && this.getLastFrame() != 60) {
            return;
        }
    }

    public boolean isOpen() {
        return this.getLastFrame() == 0 || this.getLastFrame() == 60;
    }

    @Override
    public int getFrame() {
        return this.frame;
    }

    @Override
    public void setFrame(int frame) {
        this.frame = frame;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        Item item = Item.m_41445_((int)nbt.m_128451_("ItemIn"));
        this.setItemInDisplay((Item)(item instanceof FossilItem ? item : null));
        this.setLastFrame(nbt.m_128451_("frame"));
        if (nbt.m_128441_("owner")) {
            this.owner = UUID.fromString(nbt.m_128461_("owner"));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("ItemIn", Item.m_41393_((Item)this.itemInDisplay));
        if (this.frame > 30 || this.frame < 1) {
            nbt.m_128405_("frame", 0);
        } else {
            nbt.m_128405_("frame", 30);
        }
        if (this.owner != null) {
            nbt.m_128359_("owner", this.owner.toString());
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onLoad() {
        if (this.m_58898_() && this.m_58904_() instanceof ServerLevel) {
            ((ServerLevel)this.m_58904_()).m_7726_().m_8450_(this.f_58858_);
        }
    }

    public void sendAnimation(String str) {
        CompoundTag nbt = new CompoundTag();
        if (this.frame > 30 || this.frame < 1) {
            nbt.m_128405_("frame", 0);
        } else {
            nbt.m_128405_("frame", 30);
        }
        nbt.m_128359_("Animation", str);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbt = pkt.m_131708_();
        if (nbt.m_128425_("ItemIn", 3)) {
            Item item = Item.m_41445_((int)nbt.m_128451_("ItemIn"));
            this.setItemInDisplay((Item)(item instanceof FossilItem ? item : null));
        }
        this.setFrame(nbt.m_128451_("frame"));
        if (nbt.m_128425_("Animation", 8)) {
            if (nbt.m_128461_("Animation").equals("open")) {
                this.openGlass();
            } else {
                this.closeGlass();
            }
        }
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.m_6596_();
    }

    public FossilItem getItemInDisplay() {
        return this.itemInDisplay;
    }

    public void setItemInDisplay(Item item) {
        if (item == null || item instanceof FossilItem) {
            this.itemInDisplay = (FossilItem)item;
            this.m_6596_();
        }
    }

    public int getLastFrame() {
        return this.frame;
    }

    public void setLastFrame(int frame) {
        this.frame = frame;
    }
}

