/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleStartTypes;
import com.pixelmonmod.pixelmon.api.events.CurryFinishedEvent;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.spawning.BlockSpawningHandler;
import com.pixelmonmod.pixelmon.blocks.tileentity.IBasicInventory;
import com.pixelmonmod.pixelmon.client.gui.machines.cookingpot.CookingPotContainer;
import com.pixelmonmod.pixelmon.enums.BerryType;
import com.pixelmonmod.pixelmon.enums.EnumBerryFlavor;
import com.pixelmonmod.pixelmon.enums.EnumCurryKey;
import com.pixelmonmod.pixelmon.enums.EnumCurryRating;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.CurryKeyItem;
import com.pixelmonmod.pixelmon.items.heldItems.BerryItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemStackHandler;

public class CookingPotTileEntity
extends BlockEntity
implements IBasicInventory,
MenuProvider {
    public int renderPass = 0;
    public ItemStackHandler itemStacks = new ItemStackHandler(11){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 10) {
                return stack.m_41720_() instanceof CurryKeyItem;
            }
            return stack.m_41720_() instanceof BerryItem;
        }
    };
    private boolean cooking = false;
    private int cookingTicks = 0;
    private int berryQuality = 0;
    private EnumBerryFlavor cookingFlavor = EnumBerryFlavor.NONE;
    public double fanningPoints = 0.0;
    private double stirringPoints = 0.0;
    private EnumCurryKey curryKey = EnumCurryKey.PLAIN;
    private ServerPlayer startingPlayer = null;
    public double frame = 0.0;

    public CookingPotTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntityRegistration.COOKING_POT.get(), blockPos, blockState);
    }

    public int m_6643_() {
        return this.itemStacks.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.itemStacks.getSlots(); ++i) {
            if (this.itemStacks.getStackInSlot(i) == ItemStack.f_41583_) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slotIndex) {
        return this.itemStacks.getStackInSlot(slotIndex);
    }

    @Override
    public ItemStack m_7407_(int index, int count) {
        if (!this.itemStacks.getStackInSlot(index).m_41619_()) {
            ItemStack stack;
            if (this.itemStacks.getStackInSlot(index).m_41613_() <= count) {
                stack = this.itemStacks.getStackInSlot(index);
                this.itemStacks.setStackInSlot(index, ItemStack.f_41583_);
            } else {
                stack = this.itemStacks.getStackInSlot(index).m_41620_(count);
                if (this.itemStacks.getStackInSlot(index).m_41613_() == 0) {
                    this.itemStacks.setStackInSlot(index, ItemStack.f_41583_);
                }
            }
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int index) {
        if (!this.itemStacks.getStackInSlot(index).m_41619_()) {
            ItemStack itemStack = this.itemStacks.getStackInSlot(index);
            this.itemStacks.setStackInSlot(index, ItemStack.f_41583_);
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.itemStacks.setStackInSlot(index, stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    @Override
    public int m_6893_() {
        return 1;
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public boolean m_7013_(int slotIndex, ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        switch (slotIndex) {
            case 10: {
                return item instanceof CurryKeyItem;
            }
        }
        return item instanceof BerryItem;
    }

    @Override
    public void m_5856_(Player playerIn) {
    }

    @Override
    public void m_5785_(Player playerIn) {
    }

    @Override
    public void m_6211_() {
    }

    private void sendUpdates() {
        BlockState state = this.m_58900_();
        this.f_58857_.m_6550_(this.f_58858_, state, state);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    public boolean isCooking() {
        return this.cooking;
    }

    public boolean canStart() {
        for (int i = 0; i < this.itemStacks.getSlots() - 1; ++i) {
            if (this.itemStacks.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public void startCooking(ServerPlayer player) {
        int i;
        this.startingPlayer = player;
        int[] flavors = new int[]{0, 0, 0, 0, 0};
        int count = 0;
        for (int i2 = 0; i2 < this.itemStacks.getSlots() - 1; ++i2) {
            if (this.itemStacks.getStackInSlot(i2).m_41619_()) continue;
            BerryType berry = ((BerryItem)this.itemStacks.getStackInSlot(i2).m_41720_()).getBerry();
            flavors[0] = flavors[0] + berry.spicy;
            flavors[1] = flavors[1] + berry.dry;
            flavors[2] = flavors[2] + berry.sweet;
            flavors[3] = flavors[3] + berry.bitter;
            flavors[4] = flavors[4] + berry.sour;
            count = (byte)(count + 1);
            this.itemStacks.getStackInSlot(i2).m_41774_(1);
        }
        this.berryQuality = (flavors[0] + flavors[1] + flavors[2] + flavors[3] + flavors[4]) / (count + 2) + count * 2;
        int maxAt = -1;
        int maxVal = 0;
        for (i = 0; i < flavors.length; ++i) {
            if (flavors[i] <= maxVal) continue;
            maxAt = i;
            maxVal = flavors[i];
        }
        for (i = 0; i < flavors.length; ++i) {
            if (i == maxAt || flavors[i] + 20 < maxVal) continue;
            maxAt = -1;
            break;
        }
        this.cookingFlavor = maxAt != -1 ? EnumBerryFlavor.values()[maxAt] : EnumBerryFlavor.NONE;
        if (this.itemStacks.getStackInSlot(10) == null || this.itemStacks.getStackInSlot(10).m_41619_()) {
            this.curryKey = EnumCurryKey.PLAIN;
        } else {
            this.curryKey = ((CurryKeyItem)this.itemStacks.getStackInSlot(10).m_41720_()).getKey();
            this.itemStacks.getStackInSlot(10).m_41774_(1);
        }
        this.fanningPoints = 15.0;
        this.stirringPoints = 10.0;
        this.cookingTicks = 0;
        this.cooking = true;
    }

    public void processCookingInteract() {
        if (this.cookingTicks < 200) {
            this.fanningPoints += 1.5;
        } else {
            this.stirringPoints += 1.5;
        }
    }

    public void m_142466_(CompoundTag nbtTagCompound) {
        super.m_142466_(nbtTagCompound);
        this.itemStacks.deserializeNBT(nbtTagCompound.m_128469_("Items"));
        this.cooking = nbtTagCompound.m_128471_("Cooking");
        this.fanningPoints = nbtTagCompound.m_128445_("FanPoints");
        this.stirringPoints = nbtTagCompound.m_128445_("StirPoints");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Items", (Tag)this.itemStacks.serializeNBT());
        compound.m_128379_("Cooking", this.isCooking());
        compound.m_128344_("FanPoints", (byte)this.fanningPoints);
        compound.m_128344_("StirPoints", (byte)this.stirringPoints);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = super.m_5995_();
        compound.m_128379_("Cooking", this.isCooking());
        compound.m_128344_("FanPoints", (byte)this.fanningPoints);
        compound.m_128344_("StirPoints", (byte)this.stirringPoints);
        compound.m_128347_("frame", this.frame);
        return compound;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbtTagCompound = pkt.m_131708_();
        this.cooking = nbtTagCompound.m_128471_("Cooking");
        this.fanningPoints = nbtTagCompound.m_128445_("FanPoints");
        this.stirringPoints = nbtTagCompound.m_128445_("StirPoints");
        this.frame = nbtTagCompound.m_128459_("frame");
    }

    public Component m_5446_() {
        return Component.m_237119_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new CookingPotContainer(id, inventory, this);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CookingPotTileEntity blockEntity) {
        if (!level.f_46443_) {
            if (blockEntity.isCooking()) {
                ++blockEntity.cookingTicks;
                if (blockEntity.cookingTicks < 300) {
                    blockEntity.fanningPoints -= 0.05;
                    blockEntity.fanningPoints = Math.max(0.0, blockEntity.fanningPoints);
                } else if (blockEntity.cookingTicks < 600) {
                    blockEntity.stirringPoints -= 0.05;
                    blockEntity.stirringPoints = Math.max(0.0, blockEntity.stirringPoints);
                    blockEntity.frame += blockEntity.stirringPoints / 20.0;
                    if (blockEntity.frame > 80.0) {
                        blockEntity.frame = 0.0;
                    }
                } else {
                    blockEntity.cooking = false;
                    ItemStack curry = new ItemStack((ItemLike)blockEntity.curryKey.getDishItem());
                    CompoundTag tag = curry.m_41783_();
                    if (tag == null) {
                        tag = new CompoundTag();
                    }
                    int quality = (int)((double)blockEntity.berryQuality + Math.max(0.0, 25.0 - Math.abs(25.0 - blockEntity.fanningPoints)) + Math.max(0.0, 25.0 - Math.abs(25.0 - blockEntity.stirringPoints)) + (double)blockEntity.curryKey.getRatingBoost());
                    EnumCurryRating rating = EnumCurryRating.ratingFromQuality(quality);
                    tag.m_128344_("CurryQuality", (byte)rating.ordinal());
                    if (blockEntity.curryKey != EnumCurryKey.GIGANTAMIX) {
                        tag.m_128344_("BerryFlavor", (byte)blockEntity.cookingFlavor.ordinal());
                    }
                    curry.m_41751_(tag);
                    level.m_7967_((Entity)new ItemEntity(level, (double)blockEntity.f_58858_.m_123341_(), (double)blockEntity.f_58858_.m_123342_() + 2.5, (double)blockEntity.f_58858_.m_123343_(), curry));
                    Pixelmon.EVENT_BUS.post((Event)new CurryFinishedEvent(blockEntity.startingPlayer, rating, blockEntity.curryKey, blockEntity.cookingFlavor));
                    if (blockEntity.startingPlayer != null) {
                        StorageProxy.getPartyNow(blockEntity.startingPlayer).updateSingleCurryData(blockEntity.curryKey, blockEntity.cookingFlavor, rating);
                        BlockSpawningHandler.getInstance().performBattleStartCheck(level, blockEntity.f_58858_, (Entity)blockEntity.startingPlayer, null, BattleStartTypes.CURRY, null, new Object[]{blockEntity.cookingFlavor, rating});
                    }
                    blockEntity.startingPlayer = null;
                }
                blockEntity.sendUpdates();
            }
        } else if (blockEntity.isCooking()) {
            SimpleParticleType type = null;
            if (blockEntity.fanningPoints > 25.0) {
                type = RandomHelper.getRandom().nextInt((int)blockEntity.fanningPoints) > 15 ? ParticleTypes.f_123755_ : ParticleTypes.f_123744_;
            } else if ((double)RandomHelper.getRandom().nextInt(25) < blockEntity.fanningPoints) {
                type = ParticleTypes.f_123744_;
            }
            if (type != null) {
                level.m_6493_((ParticleOptions)type, false, (double)blockEntity.f_58858_.m_123341_() + 0.5 + RandomHelper.getRandom().nextDouble() / 2.0 - 0.25, (double)blockEntity.f_58858_.m_123342_(), (double)blockEntity.f_58858_.m_123343_() + 0.5 + RandomHelper.getRandom().nextDouble() / 2.0 - 0.25, RandomHelper.getRandom().nextDouble() / 20.0, RandomHelper.getRandom().nextDouble() / 30.0, RandomHelper.getRandom().nextDouble() / 20.0);
            }
            if (blockEntity.stirringPoints > 25.0 && RandomHelper.getRandom().nextInt((int)blockEntity.stirringPoints) > 15) {
                level.m_6493_((ParticleOptions)ParticleTypes.f_123799_, false, (double)blockEntity.f_58858_.m_123341_() + 0.5 + RandomHelper.getRandom().nextDouble() / 2.0 - 0.25, (double)blockEntity.f_58858_.m_123342_() + 1.25, (double)blockEntity.f_58858_.m_123343_() + 0.5 + RandomHelper.getRandom().nextDouble() / 2.0 - 0.25, RandomHelper.getRandom().nextDouble() / 30.0, RandomHelper.getRandom().nextDouble() / 20.0, RandomHelper.getRandom().nextDouble() / 30.0);
            }
        }
    }
}

