/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.blocks.CloningCompleteEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MewStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.blocks.machines.CloningMachineBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.DecorativeBaseTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.Event;

public class CloningMachineTileEntity
extends DecorativeBaseTileEntity {
    public boolean processingClone = false;
    public boolean growingPokemon = false;
    public boolean isBroken = false;
    public float xboost = 0.0f;
    public float zboost = 0.0f;
    public PixelmonEntity pixelmon;
    public String pokemonName = "";
    public boolean isShiny = false;
    public Pokemon mew = null;
    public UUID owner = null;
    public int boostLevel = 0;
    public int boostCount = 0;
    public float lasPos = -2.0f;
    public int pokemonProgress = 0;
    public boolean isFinished = false;
    boolean boostSet = false;
    boolean travDown = true;
    int baseCount = 0;

    public CloningMachineTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityRegistration.CLONING_MACHINE.get(), pos, state);
    }

    private void resetMachine() {
        this.mew = null;
        this.owner = null;
        this.isFinished = false;
        this.growingPokemon = false;
        this.processingClone = false;
        this.isShiny = false;
        this.pokemonProgress = 0;
        this.boostLevel = 0;
        this.boostCount = 0;
        this.baseCount = 0;
        this.pokemonName = "";
        ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CloningMachineTileEntity blockEntity) {
        if (!blockEntity.boostSet) {
            Direction direction = (Direction)blockEntity.m_58900_().m_61143_((Property)CloningMachineBlock.FACING);
            if (direction == Direction.NORTH) {
                blockEntity.xboost = (float)((double)blockEntity.xboost + 3.35);
            } else if (direction == Direction.SOUTH) {
                blockEntity.xboost = (float)((double)blockEntity.xboost - 3.35);
            } else {
                blockEntity.zboost = direction == Direction.EAST ? (float)((double)blockEntity.zboost + 3.35) : (float)((double)blockEntity.zboost - 3.35);
            }
            blockEntity.boostSet = true;
        }
        if (!level.f_46443_) {
            if (!blockEntity.processingClone && blockEntity.boostCount == 3 && blockEntity.hasMew()) {
                if (blockEntity.baseCount < 30) {
                    ++blockEntity.baseCount;
                } else if (blockEntity.baseCount == 30) {
                    blockEntity.processingClone = true;
                    blockEntity.baseCount = 0;
                    ((ServerLevel)level).m_7726_().m_8450_(blockEntity.f_58858_);
                }
            }
            if (blockEntity.processingClone) {
                ++blockEntity.baseCount;
                if (blockEntity.baseCount >= 280) {
                    boolean madeMewtwo = Math.random() < (double)((float)blockEntity.boostLevel / 40.0f);
                    blockEntity.pixelmon = madeMewtwo ? new PixelmonEntity(level, PokemonFactory.create(PixelmonSpecies.MEWTWO.getValueUnsafe())) : new PixelmonEntity(level, PokemonFactory.create(PixelmonSpecies.DITTO.getValueUnsafe()));
                    blockEntity.pixelmon.initAnimation();
                    boolean bl = blockEntity.isShiny = PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)level.m_46472_()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)level.m_46472_()));
                    if (blockEntity.isShiny) {
                        blockEntity.pixelmon.getPokemon().setShiny();
                    }
                    blockEntity.pokemonName = blockEntity.pixelmon.getPokemonName();
                    ++((MewStats)blockEntity.mew.getExtraStats()).numCloned;
                    blockEntity.growingPokemon = true;
                    blockEntity.processingClone = false;
                    ((ServerLevel)level).m_7726_().m_8450_(blockEntity.f_58858_);
                }
            }
            if (blockEntity.growingPokemon) {
                if (blockEntity.pokemonProgress < 200) {
                    ++blockEntity.pokemonProgress;
                } else if (!Pixelmon.EVENT_BUS.post((Event)new CloningCompleteEvent(blockEntity.mew, blockEntity.pixelmon, (Player)(blockEntity.owner != null ? StorageProxy.getPartyNow(blockEntity.owner).getPlayer() : blockEntity.mew.getOwnerPlayer()), blockEntity.f_58858_))) {
                    if (blockEntity.owner != null) {
                        StorageProxy.getPartyNow(blockEntity.owner).add(blockEntity.mew);
                    }
                    blockEntity.mew = null;
                    blockEntity.owner = null;
                    if (blockEntity.pokemonName.equals("Mewtwo")) {
                        blockEntity.isBroken = true;
                        blockEntity.releasePokemon();
                    } else {
                        blockEntity.isFinished = true;
                    }
                    blockEntity.growingPokemon = false;
                    ((ServerLevel)level).m_7726_().m_8450_(blockEntity.f_58858_);
                } else {
                    --((MewStats)blockEntity.mew.getExtraStats()).numCloned;
                    StorageProxy.getPartyNow(blockEntity.owner).add(blockEntity.mew);
                    blockEntity.resetMachine();
                }
            }
        } else {
            if (blockEntity.travDown) {
                blockEntity.lasPos -= 0.1f;
                if (blockEntity.lasPos < -15.0f) {
                    blockEntity.travDown = false;
                }
            } else {
                blockEntity.lasPos += 0.1f;
                if (blockEntity.lasPos >= -2.0f) {
                    blockEntity.travDown = true;
                }
            }
            if (blockEntity.growingPokemon && blockEntity.pokemonProgress < 200) {
                ++blockEntity.pokemonProgress;
            }
            if (blockEntity.processingClone) {
                ++blockEntity.baseCount;
                if (blockEntity.baseCount > 80 && blockEntity.baseCount < 280) {
                    int i = 0;
                    while ((float)i < 30.0f * ((float)blockEntity.baseCount - 80.0f) / 200.0f) {
                        WorldHelper.spawnRedstoneParticle(level, (float)blockEntity.f_58858_.m_123341_() + blockEntity.xboost + RandomHelper.getRandom().nextFloat(), (float)blockEntity.f_58858_.m_123342_() + 0.3f + RandomHelper.getRandom().nextFloat() + RandomHelper.getRandom().nextFloat(), (float)blockEntity.f_58858_.m_123343_() + blockEntity.zboost + RandomHelper.getRandom().nextFloat(), -255.0, 1.0, 255.0);
                        ++i;
                    }
                }
            }
        }
        if (blockEntity.pokemonName.equals("") && blockEntity.pixelmon != null) {
            blockEntity.pixelmon = null;
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.boostCount = nbt.m_128448_("BoostCount");
        this.boostLevel = nbt.m_128448_("BoostLevel");
        this.isBroken = nbt.m_128471_("IsBroken");
        this.isFinished = nbt.m_128471_("IsFinished");
        this.processingClone = nbt.m_128471_("ProcessingClone");
        this.growingPokemon = nbt.m_128471_("GrowingPokemon");
        this.pokemonName = nbt.m_128461_("PokemonName");
        this.baseCount = nbt.m_128451_("BaseCount");
        this.pokemonProgress = nbt.m_128451_("PokemonProgress");
        this.mew = nbt.m_128441_("Mew") ? PokemonFactory.create(nbt.m_128469_("Mew")) : null;
        this.owner = nbt.m_128403_("Owner") ? nbt.m_128342_("Owner") : null;
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128376_("BoostCount", (short)this.boostCount);
        nbt.m_128376_("BoostLevel", (short)this.boostLevel);
        nbt.m_128379_("IsBroken", this.isBroken);
        nbt.m_128379_("IsFinished", this.isFinished);
        nbt.m_128379_("ProcessingClone", this.processingClone);
        nbt.m_128379_("GrowingPokemon", this.growingPokemon);
        nbt.m_128359_("PokemonName", this.pokemonName);
        nbt.m_128405_("BaseCount", this.baseCount);
        if (this.hasMew()) {
            CompoundTag mewnbt = new CompoundTag();
            this.mew.writeToNBT(mewnbt);
            nbt.m_128365_("Mew", (Tag)mewnbt);
        }
        if (this.owner != null) {
            nbt.m_128362_("Owner", this.owner);
        }
        nbt.m_128405_("PokemonProgress", this.pokemonProgress);
    }

    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    public boolean hasMew() {
        return this.mew != null;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
    }

    public void activate(Player player, ItemStack heldItem) {
        if (!PixelmonConfigProxy.getGeneral().isCloningMachineEnabled()) {
            ChatHandler.sendChat((Entity)player, "pixelmon.general.disabledblock", new Object[0]);
            return;
        }
        if (this.isBroken) {
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.clone.broken", new Object[0]);
            return;
        }
        if (this.isFinished) {
            PlayerPartyStorage storage = StorageProxy.getPartyNow((ServerPlayer)player);
            if (storage.countAblePokemon() < 1) {
                this.releasePokemon();
            } else {
                this.fightDitto((ServerPlayer)player, storage);
            }
            this.resetMachine();
        } else if (!this.hasMew()) {
            PlayerPartyStorage storage = StorageProxy.getPartyNow((ServerPlayer)player);
            if (storage.inTemporaryMode()) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.intemporarymode", new Object[0]);
                return;
            }
            if (storage.countPokemon() > 1) {
                Pokemon mew = storage.findOne(pokemon -> pokemon.getSpecies().is(PixelmonSpecies.MEW) && ((MewStats)pokemon.getExtraStats()).numCloned < 3);
                if (mew != null) {
                    this.mew = mew;
                    storage.set((StoragePosition)mew.getStorageAndPosition().m_14419_(), null);
                    mew.setStorage(null, null);
                    mew.retrieve("BlockInteract");
                    this.owner = storage.getIdentifier();
                    ((ServerLevel)player.f_19853_).m_7726_().m_8450_(this.f_58858_);
                } else {
                    ChatHandler.sendChat((Entity)player, "pixelmon.blocks.noclone", new Object[0]);
                }
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.lastpoke", new Object[0]);
            }
        } else if (this.hasMew() && player.m_6144_() && !this.growingPokemon && !this.processingClone) {
            if (this.owner != null) {
                StorageProxy.getPartyNow(this.owner).add(this.mew);
                this.resetMachine();
            }
        } else if (this.boostCount < 3 && heldItem != null && heldItem.m_41720_() instanceof BlockItem) {
            Block block = ((BlockItem)heldItem.m_41720_()).m_40614_();
            if (block == Blocks.f_50075_) {
                ++this.boostCount;
                ++this.boostLevel;
                ((ServerLevel)player.f_19853_).m_7726_().m_8450_(this.f_58858_);
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
            } else if (block == Blocks.f_50074_) {
                ++this.boostCount;
                this.boostLevel += 3;
                ((ServerLevel)player.f_19853_).m_7726_().m_8450_(this.f_58858_);
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
            } else if (block == Blocks.f_50090_) {
                ++this.boostCount;
                this.boostLevel += 5;
                ((ServerLevel)player.f_19853_).m_7726_().m_8450_(this.f_58858_);
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
            }
        }
    }

    private void fightDitto(ServerPlayer player, PlayerPartyStorage storage) {
        if (this.pixelmon == null) {
            return;
        }
        PixelmonEntity firstPokemon = storage.findOne(Pokemon::canBattle).getOrSpawnPixelmon((Entity)player);
        firstPokemon.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.f_19857_, 0.0f);
        WildPixelmonParticipant part = new WildPixelmonParticipant(this.pixelmon);
        this.pixelmon.startBattle(new PlayerParticipant(player, firstPokemon), part);
    }

    public void releasePokemon() {
        int xplus = 0;
        int zplus = 0;
        if (this.xboost > 0.0f) {
            ++zplus;
        } else if (this.xboost < 0.0f) {
            --zplus;
        } else if (this.zboost > 0.0f) {
            --xplus;
        } else if (this.zboost < 0.0f) {
            ++xplus;
        }
        if (this.pixelmon != null) {
            this.pixelmon.m_7678_((float)this.f_58858_.m_123341_() + this.xboost + (float)xplus, this.f_58858_.m_123342_(), (float)this.f_58858_.m_123343_() + this.zboost + (float)zplus, 0.0f, 0.0f);
            this.f_58857_.m_7967_((Entity)this.pixelmon);
        }
    }

    public void onDestroy() {
        if (!this.f_58857_.f_46443_ && this.hasMew()) {
            try {
                PlayerPartyStorage storage = StorageProxy.getPartyNow(this.owner);
                if (storage != null) {
                    storage.add(this.mew);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

