/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.enums.ShrineType;
import com.pixelmonmod.pixelmon.api.events.PlayerActivateShrineEvent;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.EncounterData;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.blocks.machines.ShrineBlock;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.ShrineOrbItem;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.Event;

public class BirdShrineTileEntity
extends BlockEntity {
    public EncounterData encounters = new EncounterData(PixelmonConfigProxy.getGeneral().getShrineEncounterMode());

    public BirdShrineTileEntity(BlockPos blockPos, BlockState state) {
        super((BlockEntityType)TileEntityRegistration.BIRD_SHRINE.get(), blockPos, state);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("EncounterData", (Tag)this.encounters.write(new CompoundTag()));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.encounters = new EncounterData(PixelmonConfigProxy.getGeneral().getShrineEncounterMode());
        if (nbt.m_128441_("EncounterData")) {
            this.encounters.read(nbt.m_128469_("EncounterData"));
        }
    }

    public void activate(Player player, ShrineBlock block, BlockState state, ItemStack item) {
        if (item != null && item.m_41720_() instanceof ShrineOrbItem) {
            if (item.m_41773_() == 0) {
                if (!player.f_19853_.f_46443_) {
                    boolean hasParty;
                    Species species;
                    if (item.m_41720_() == PixelmonItems.uno_orb && block.getRockType() == ShrineType.ARTICUNO) {
                        species = PixelmonSpecies.ARTICUNO.getValueUnsafe();
                    } else if (item.m_41720_() == PixelmonItems.dos_orb && block.getRockType() == ShrineType.ZAPDOS) {
                        species = PixelmonSpecies.ZAPDOS.getValueUnsafe();
                    } else if (item.m_41720_() == PixelmonItems.tres_orb && block.getRockType() == ShrineType.MOLTRES) {
                        species = PixelmonSpecies.MOLTRES.getValueUnsafe();
                    } else {
                        ChatHandler.sendChat((Entity)player, "pixelmon.blocks.orbwrong", new Object[0]);
                        return;
                    }
                    PlayerPartyStorage party = StorageProxy.getPartyNow((ServerPlayer)player);
                    boolean canEncounter = this.encounters.canEncounter(player);
                    PixelmonEntity pixelmonEntity = PokemonSpecificationProxy.create(species.getName()).get().create(player.f_19853_);
                    boolean shiny = PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)this.f_58857_.m_46472_()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)this.f_58857_.m_46472_()));
                    pixelmonEntity.getPokemon().setShiny(shiny);
                    pixelmonEntity.m_6034_(this.f_58858_.m_123341_(), this.f_58858_.m_123342_() + 2, this.f_58858_.m_123343_());
                    PixelmonEntity startingPixelmon = party.getAndSendOutFirstAblePokemon((Entity)player);
                    boolean bl = hasParty = startingPixelmon != null && BattleRegistry.getBattle(player) == null;
                    if (!hasParty) {
                        ChatHandler.sendChat((Entity)player, "pixelmon.blocks.partyfainted", new Object[0]);
                        return;
                    }
                    PlayerActivateShrineEvent.Pre event = new PlayerActivateShrineEvent.Pre(this.m_58899_(), (ServerPlayer)player, block, block.getRockType(), this, canEncounter, pixelmonEntity);
                    if (Pixelmon.EVENT_BUS.post((Event)event)) {
                        return;
                    }
                    if (event.canEncounter()) {
                        if (this.encounters.getMode() == EnumEncounterMode.Once) {
                            player.f_19853_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)ShrineBlock.USED, (Comparable)Boolean.valueOf(true)), 2);
                        }
                        this.encounters.registerEncounter(player);
                        item.m_41774_(1);
                        player.f_19853_.m_7967_((Entity)event.getPixelmonEntity());
                        PlayerParticipant playerParticipant = new PlayerParticipant((ServerPlayer)player, startingPixelmon);
                        WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(false, event.getPixelmonEntity());
                        wildPixelmonParticipant.startedBattle = true;
                        BattleRegistry.startBattle(playerParticipant, wildPixelmonParticipant);
                        Pixelmon.EVENT_BUS.post((Event)new PlayerActivateShrineEvent.Post(this.m_58899_(), (ServerPlayer)player, block, block.getRockType(), this, canEncounter, pixelmonEntity));
                    } else if (this.encounters.getMode().isTimedAccess()) {
                        ChatHandler.sendChat((Entity)player, "pixelmon.blocks.shrine.today", new Object[0]);
                    } else {
                        ChatHandler.sendChat((Entity)player, "pixelmon.blocks.shrine.encountered", new Object[0]);
                    }
                }
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.orbnotfull", new Object[0]);
            }
        }
    }
}

