/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.legendary.Gen2BellEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.blocks.BellBlock;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystems;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayParticleSystemPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.RotateEntityPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BellTileEntity
extends BlockEntity {
    private boolean spawning = false;
    private BellBlock.Type type;
    public UUID owner;
    private int ticks = 0;

    public BellTileEntity(BlockEntityType<?> p_155228_, BellBlock.Type type, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
        this.type = type;
    }

    public BellTileEntity(BellBlock.Type type, BlockPos p_155229_, BlockState p_155230_) {
        this(type.get(), type, p_155229_, p_155230_);
    }

    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("BellSpawning", this.spawning);
        nbt.m_128405_("BellType", this.type.ordinal());
        nbt.m_128362_("BellOwner", this.owner == null ? Util.f_137441_ : this.owner);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.spawning = nbt.m_128471_("BellSpawning");
        this.type = BellBlock.Type.values()[nbt.m_128451_("BellType")];
        UUID uuid = nbt.m_128342_("BellOwner");
        this.owner = Objects.equals(Util.f_137441_, uuid) ? null : uuid;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
    }

    public void m_6596_() {
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        super.m_6596_();
    }

    private int countNearbyBells() {
        int bells = 0;
        int radius = PixelmonConfigProxy.getSpawning().getBellInclusionRange();
        int diameter = radius + radius;
        int radiusSqr = radius * radius;
        for (BlockEntity te : WorldHelper.getBlockEntitiesWithinAABB(this.f_58857_, AABB.m_165882_((Vec3)new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()), (double)diameter, (double)diameter, (double)diameter))) {
            if (!(te instanceof BellTileEntity) || te == this || !(te.m_58899_().m_123331_((Vec3i)this.f_58858_) <= (double)radiusSqr)) continue;
            ++bells;
        }
        return bells;
    }

    public void spawnEntity(PixelmonEntity pixelmonEntity, double x, double y, double z, float rotation) {
        pixelmonEntity.m_19890_(x, y, z, rotation, pixelmonEntity.m_146909_());
        this.m_58904_().m_7967_((Entity)pixelmonEntity);
        NetworkHelper.sendToDimension(new RotateEntityPacket(pixelmonEntity.m_19879_(), rotation, pixelmonEntity.m_146909_()), pixelmonEntity.m_9236_());
        pixelmonEntity.m_6478_(null, new Vec3(0.1, 0.1, 0.1));
        pixelmonEntity.f_19859_ = rotation;
        pixelmonEntity.m_146922_(rotation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean isSpawning() {
        return this.spawning;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BellTileEntity blockEntity) {
        if (!level.f_46443_) {
            int clampedTime = (int)(level.m_46468_() % 24000L);
            if (blockEntity.spawning) {
                double d = RandomHelper.getRandom().nextDouble();
                double d2 = level.m_46467_() > 12000L ? (level.m_46467_() > 12500L ? 0.01 : 0.005) : 0.001;
                if (d < d2) {
                    level.m_5594_(null, blockEntity.f_58858_, (SoundEvent)SoundRegistration.BELL_RING.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
            if (clampedTime == 1) {
                if (!blockEntity.spawning) {
                    Gen2BellEvent.RollSuccessEvent event;
                    int count = blockEntity.countNearbyBells();
                    if (count == 0) {
                        ++count;
                    }
                    if (!Pixelmon.EVENT_BUS.post((Event)(event = new Gen2BellEvent.RollSuccessEvent(blockEntity.owner, blockEntity))) && RandomHelper.getRandomChance(event.chance * (double)count)) {
                        blockEntity.spawning = true;
                        blockEntity.m_6596_();
                    }
                }
            } else if (clampedTime == 13000 && blockEntity.spawning) {
                ServerPlayer ownerPlayer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(blockEntity.owner);
                if (ownerPlayer == null || ownerPlayer.m_20275_((double)blockEntity.f_58858_.m_123341_(), (double)blockEntity.f_58858_.m_123342_(), (double)blockEntity.f_58858_.m_123343_()) > 4096.0) {
                    blockEntity.spawning = false;
                    blockEntity.m_6596_();
                    return;
                }
                Pokemon pokemon = PokemonFactory.create(blockEntity.type == BellBlock.Type.TIDAL ? PixelmonSpecies.LUGIA.getValueUnsafe() : PixelmonSpecies.HOOH.getValueUnsafe());
                if (pokemon.getSpecies().is(PixelmonSpecies.HOOH)) {
                    if ((double)RandomHelper.getRandom().nextFloat() > 0.2) {
                        pokemon.setHeldItem(new ItemStack((ItemLike)PixelmonItems.sacredash));
                    } else {
                        pokemon.setHeldItem(new ItemStack((ItemLike)PixelmonItems.rainbow_wing));
                    }
                }
                if (blockEntity.owner != null) {
                    PlayerPartyStorage storage = StorageProxy.getPartyNow(ownerPlayer);
                    if (ownerPlayer == null || storage.countAblePokemon() < 1 || BattleRegistry.getBattle((Player)ownerPlayer) != null) {
                        PixelmonEntity pixelmon = pokemon.getOrCreatePixelmon(level, (double)blockEntity.f_58858_.m_123341_() + 0.5, blockEntity.f_58858_.m_123342_() - 1, (double)blockEntity.f_58858_.m_123343_() + 0.5);
                        Gen2BellEvent.SummonLegendary.Pre pre = new Gen2BellEvent.SummonLegendary.Pre(blockEntity.owner, blockEntity, pixelmon);
                        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                            return;
                        }
                        level.m_7967_((Entity)pixelmon);
                        Pixelmon.EVENT_BUS.post((Event)new Gen2BellEvent.SummonLegendary.Post(blockEntity.owner, blockEntity, pixelmon));
                    } else {
                        PixelmonEntity startingPixelmon = storage.findOne(Pokemon::canBattle).getOrSpawnPixelmon((Entity)ownerPlayer);
                        PixelmonEntity pixelmon = pokemon.getOrSpawnPixelmon(level, (double)blockEntity.f_58858_.m_123341_() + 0.5, blockEntity.f_58858_.m_123342_() - 1, (double)blockEntity.f_58858_.m_123343_() + 0.5);
                        Gen2BellEvent.SummonLegendary.Pre pre = new Gen2BellEvent.SummonLegendary.Pre(blockEntity.owner, blockEntity, pixelmon);
                        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
                            return;
                        }
                        PlayerParticipant playerParticipant = new PlayerParticipant(ownerPlayer, startingPixelmon);
                        WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(false, pre.getPixelmonEntity());
                        wildPixelmonParticipant.startedBattle = true;
                        BattleRegistry.startBattle(playerParticipant, wildPixelmonParticipant);
                        Pixelmon.EVENT_BUS.post((Event)new Gen2BellEvent.SummonLegendary.Post(ownerPlayer.m_20148_(), blockEntity, pixelmon));
                    }
                    NetworkHelper.sendToDimension(new PlayParticleSystemPacket(ParticleSystems.DISCHARGE, (double)blockEntity.f_58858_.m_123341_() + 0.5, blockEntity.f_58858_.m_123342_() - 1, (double)blockEntity.f_58858_.m_123343_() + 0.5, level, 0.0f, false, 0.0, 0.0, 0.0, 1.0), level);
                    level.m_7471_(blockEntity.f_58858_, false);
                    level.m_46747_(blockEntity.f_58858_);
                }
            }
        }
    }
}

