/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileentity;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.legendary.ArceusEvent;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.blocks.ArcChaliceBlock;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.enums.EnumPlate;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.ArrayUtils;

public class ArcChaliceTileEntity
extends BlockEntity {
    public List<Integer> platesIn = Lists.newArrayList();
    public short animationTimer = 0;
    public boolean animating = false;
    public byte plateAdded = (byte)-1;
    public boolean itemThere = false;
    private ItemEntity spawnedItem = null;
    private transient UUID lastUsedPlayer = null;

    public ArcChaliceTileEntity(BlockPos blockPos, BlockState state) {
        super((BlockEntityType)TileEntityRegistration.ARC_CHALICE.get(), blockPos, state);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128385_("Plates", ArrayUtils.toPrimitive((Integer[])this.platesIn.toArray(new Integer[0])));
        nbt.m_128376_("AnimationTimer", this.animationTimer);
        nbt.m_128379_("Animating", this.animating);
        nbt.m_128344_("CurrentPlate", this.plateAdded);
        nbt.m_128379_("ItemThere", this.itemThere);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        ArrayList platesRead = Lists.newArrayList();
        for (int i : nbt.m_128465_("Plates")) {
            platesRead.add(i);
        }
        this.platesIn = platesRead;
        this.animationTimer = nbt.m_128448_("AnimationTimer");
        this.animating = nbt.m_128471_("Animating");
        this.plateAdded = nbt.m_128445_("CurrentPlate");
        this.itemThere = nbt.m_128471_("ItemThere");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
    }

    public void activate(Player player, ArcChaliceBlock block, BlockState state, ItemStack item) {
        EnumPlate plate;
        if (!this.f_58857_.f_46443_ && (plate = EnumPlate.getPlateForItem(item.m_41720_())) != null) {
            if (!this.platesIn.contains(plate.ordinal()) && this.plateAdded != plate.ordinal()) {
                if (Pixelmon.EVENT_BUS.post((Event)new ArceusEvent.AddPlate((ServerPlayer)player, this, item))) {
                    return;
                }
                if (this.plateAdded != -1) {
                    this.platesIn.add(Integer.valueOf(this.plateAdded));
                }
                item.m_41774_(1);
                this.plateAdded = (byte)plate.ordinal();
                this.animationTimer = 0;
                this.animating = true;
                this.lastUsedPlayer = player.m_20148_();
                this.f_58857_.m_6263_(null, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), SoundEvents.f_11771_, SoundSource.BLOCKS, 0.6f, 0.75f);
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.plate.add", EnumPlate.values().length - this.platesIn.size() - 1);
                this.m_6596_();
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.plate.fail", new Object[0]);
            }
        }
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
        super.m_6596_();
    }

    public void tick() {
        if (!this.f_58857_.f_46443_) {
            if (this.spawnedItem != null && !this.spawnedItem.m_6084_() && this.itemThere || this.spawnedItem == null && this.itemThere) {
                this.spawnedItem = null;
                this.itemThere = false;
                this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
                this.m_6596_();
            }
            if (this.animating) {
                this.animationTimer = (short)(this.animationTimer + 1);
                if (this.platesIn.size() >= 17) {
                    if (this.animationTimer > 500) {
                        this.platesIn.clear();
                        this.plateAdded = (byte)-1;
                        this.animating = false;
                        this.animationTimer = 0;
                        ItemStack azureFlute = new ItemStack((ItemLike)PixelmonItems.azure_flute, 1);
                        ItemEntity item = new ItemEntity(this.m_58904_(), (double)this.f_58858_.m_123341_() + 0.5, (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_() + 0.5, azureFlute);
                        item.m_20242_(true);
                        item.m_20334_(0.0, 0.0, 0.0);
                        Pixelmon.EVENT_BUS.post((Event)new ArceusEvent.CreateFlute(this.lastUsedPlayer, this, item));
                        this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.25, (double)this.f_58858_.m_123343_() + 0.5, SoundEvents.f_11913_, SoundSource.AMBIENT, 0.5f, 1.0E-4f);
                        this.f_58857_.m_7967_((Entity)item);
                        this.spawnedItem = item;
                        this.itemThere = true;
                    }
                } else if (this.animationTimer > 100) {
                    this.platesIn.add(Integer.valueOf(this.plateAdded));
                    this.plateAdded = (byte)-1;
                    this.animating = false;
                    this.animationTimer = 0;
                }
                this.m_6596_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

