/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.spawning;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.PlayerHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.PixelmonSpawnerTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.PixelmonSpawnerData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ClientboundUpdateSpawnerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class PixelmonSpawnerBlock
extends BaseEntityBlock {
    public PixelmonSpawnerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(-1.0f, 6000000.0f).m_60955_().m_284180_(MapColor.f_283808_));
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new PixelmonSpawnerTileEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return PixelmonSpawnerBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)TileEntityRegistration.PIXELMON_SPAWNER.get()), PixelmonSpawnerTileEntity::tick);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!(player instanceof ServerPlayer) || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!PixelmonSpawnerBlock.checkPermission(serverPlayer)) {
            return InteractionResult.SUCCESS;
        }
        PixelmonSpawnerTileEntity spawner = BlockHelper.getTileEntity(PixelmonSpawnerTileEntity.class, (LevelReader)world, pos);
        serverPlayer.f_8906_.m_141995_((Packet)spawner.getUpdatePacket());
        NetworkHelper.sendPacket(serverPlayer, new ClientboundUpdateSpawnerPacket(new PixelmonSpawnerData(spawner.m_58899_(), spawner.m_5995_(), spawner.pokemonList)));
        spawner.onActivate();
        OpenScreenPacket.open(player, EnumGuiScreen.PixelmonSpawner, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        return InteractionResult.SUCCESS;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (world.m_5776_()) {
            super.m_5707_(world, pos, state, player);
            return;
        }
        PixelmonSpawnerTileEntity pixelmonSpawner = BlockHelper.getTileEntity(PixelmonSpawnerTileEntity.class, (LevelReader)world, pos);
        if (pixelmonSpawner != null) {
            pixelmonSpawner.despawnAllPokemon();
        }
        super.m_5707_(world, pos, state, player);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        boolean bl = flag = world.m_276867_(pos) || world.m_276867_(new BlockPos(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_()));
        if (flag) {
            world.m_183326_().m_183588_(pos, (Object)this);
        }
    }

    public static boolean checkPermission(ServerPlayer player) {
        if (!PixelmonConfigProxy.getGeneral().isSpawnersOpOnly() && player.m_7500_()) {
            return true;
        }
        if (PixelmonConfigProxy.getGeneral().isSpawnersOpOnly() && PlayerHelper.hasPermission(player, "pixelmon.spawner.use")) {
            return true;
        }
        ChatHandler.sendChat((Entity)player, "pixelmon.general.needop", new Object[0]);
        return false;
    }
}

