/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.spawning;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BattleStartTypes;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.blocks.spawning.BlockSpawningHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class PixelmonGrassBlock
extends Block
implements BonemealableBlock,
IForgeShearable,
IPlantable {
    private static final AABB AABB = new AABB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);

    public PixelmonGrassBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(3.0f).m_60918_(SoundType.f_56740_).m_60910_().m_60977_().m_284180_(MapColor.f_283898_));
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return PlantType.PLAINS;
    }

    protected boolean canPlaceBlockOn(BlockState ground) {
        return ground.m_60713_(Blocks.f_50493_) || ground.m_60713_(Blocks.f_49992_) || ground.m_60713_(Blocks.f_50440_);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entityIn;
            if (BattleRegistry.getBattle((Player)player) != null) {
                return;
            }
            PlayerPartyStorage storage = StorageProxy.getPartyNow(player);
            if (storage.getTicksTillEncounter() <= 1 && player.m_20186_() == (double)pos.m_123342_()) {
                BlockSpawningHandler.getInstance().performBattleStartCheck(worldIn, pos, (Entity)player, null, BattleStartTypes.PUGRASSSINGLE, state, new Object[0]);
            }
            storage.updateTicksTillEncounter();
        }
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        ArrayList ret = Lists.newArrayList();
        ret.add(new ItemStack((ItemLike)PixelmonBlocks.pixelmon_grass, 1));
        return ret;
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return true;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void m_213897_(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        this.checkAndDropBlock((Level)level, blockPos, blockState);
    }

    protected void checkAndDropBlock(Level worldIn, BlockPos pos, BlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)this.m_5456_())));
            worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    public boolean canBlockStay(Level worldIn, BlockPos pos, BlockState state) {
        BlockPos down = pos.m_7495_();
        BlockState belowState = worldIn.m_8055_(down);
        if (belowState.m_60734_() != this) {
            return this.canPlaceBlockOn(belowState);
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return Shapes.m_83064_((AABB)AABB);
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() != this) {
            return this.m_49966_();
        }
        return state;
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        return true;
    }

    public boolean m_7370_(LevelReader p_256559_, BlockPos p_50898_, BlockState p_50899_) {
        return true;
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
    }
}

