/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.spawning;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleStartTypes;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.events.PixelmonBlockStartingBattleEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonBlockTriggeredBattleEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IVStore;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PokemonLevel;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners.TriggerSpawner;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractHasStatsEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumBerryFlavor;
import com.pixelmonmod.pixelmon.enums.EnumCurryRating;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Event;

public class BlockSpawningHandler {
    private static final BlockSpawningHandler instance = new BlockSpawningHandler();

    public static BlockSpawningHandler getInstance() {
        return instance;
    }

    public void performBattleStartCheck(Level world, BlockPos pos, Entity entity, PixelmonEntity entityPixelmon, BattleStartTypes startType, BlockState state, Object ... extra) {
        ServerPlayer playerMP = (ServerPlayer)entity;
        if (BattleRegistry.getBattle((Player)playerMP) != null) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getPartyNow(playerMP);
        if (party.guiOpened) {
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PixelmonBlockTriggeredBattleEvent(this, world, pos, playerMP, entityPixelmon, startType))) {
            return;
        }
        if (startType == BattleStartTypes.HEADBUTT) {
            if (RandomHelper.getRandom().nextInt(100) <= 25) {
                playerMP.m_213846_((Component)Component.m_237115_((String)"pixelmon.moveskill.headbutt.nothing"));
                return;
            }
            this.grabSpawns(world, pos, playerMP, startType, entityPixelmon, state, extra);
        } else if (startType == BattleStartTypes.ROCKSMASH) {
            if (RandomHelper.getRandom().nextInt(100) <= 40) {
                return;
            }
            this.grabSpawns(world, pos, playerMP, startType, entityPixelmon, state, extra);
        } else if (startType == BattleStartTypes.CURRY) {
            if (RandomHelper.getRandom().nextInt(100) <= 7) {
                return;
            }
            this.grabSpawns(world, pos, playerMP, startType, entityPixelmon, state, extra);
        } else if (startType == BattleStartTypes.FORAGE) {
            if (!RandomHelper.getRandomChance(PixelmonConfigProxy.getExternalMoves().getForageChance())) {
                playerMP.m_213846_((Component)Component.m_237110_((String)"pixelmon.moveskill.forage.nothing", (Object[])new Object[]{entityPixelmon.getNickname()}));
                return;
            }
            this.grabSpawns(world, pos, playerMP, startType, entityPixelmon, state, extra);
        } else {
            this.grabSpawns(world, pos, playerMP, startType, entityPixelmon, state, extra);
        }
    }

    private void grabSpawns(Level worldIn, BlockPos pos, ServerPlayer player, BattleStartTypes startType, PixelmonEntity fightingPokemon, BlockState state, Object ... extra) {
        AbstractHasStatsEntity pixelmon = null;
        ItemEntity item = null;
        PlayerPartyStorage party = StorageProxy.getPartyNow(player);
        Pokemon firstAble = party.findOne(Pokemon::canBattle);
        if (firstAble == null) {
            return;
        }
        if (startType == BattleStartTypes.PUGRASSSINGLE) {
            if (PixelmonSpawning.grassSpawner != null && PixelmonSpawning.coordinator != null) {
                SpatialData data = TriggerSpawner.calculateSpatialData(worldIn, pos.m_7494_(), 10, true, block -> true);
                SpawnLocation spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.GRASS}), worldIn.m_8055_(pos).m_60734_(), data.uniqueSurroundingBlocks, (Holder<Biome>)worldIn.m_204166_(pos), worldIn.m_45527_(pos), 6, worldIn.m_46803_(pos.m_7494_()));
                Entity entity = PixelmonSpawning.grassSpawner.trigger(spawnLocation);
                if (entity instanceof PixelmonEntity) {
                    pixelmon = (PixelmonEntity)entity;
                }
            }
            if (pixelmon == null) {
                return;
            }
            if (PixelmonConfigProxy.getBattle().isScaleGrassBattles()) {
                int minLvl;
                int maxLvl = Math.min(party.getHighestLevel(), PixelmonServerConfig.maxLevel);
                if (maxLvl - (minLvl = party.getLowestLevel()) > 5) {
                    minLvl = maxLvl - minLvl;
                }
                PokemonLevel pokemonLevel = pixelmon.getLvl();
                if (minLvl < maxLvl) {
                    int lvl = RandomHelper.getRandom().nextInt(maxLvl - minLvl) + minLvl;
                    pokemonLevel.setLevel(lvl);
                } else {
                    pokemonLevel.setLevel(maxLvl);
                }
                pixelmon.getPokemon().getMoveset().clear();
                pixelmon.getPokemon().getMoveset().addAll(pixelmon.getForm().getMoves().loadMoveset(pokemonLevel.getPokemonLevel()));
            }
            PixelmonEntity startingPixelmon = firstAble.getOrSpawnPixelmon((Entity)player);
            this.setupBattle(worldIn, pos, player, startType, startingPixelmon, (PixelmonEntity)pixelmon);
        } else if (startType == BattleStartTypes.PUGRASSDOUBLE) {
            if (PixelmonSpawning.tallGrassSpawner != null && PixelmonSpawning.coordinator != null) {
                SpatialData data = TriggerSpawner.calculateSpatialData(worldIn, pos.m_7494_(), 10, true, block -> true);
                SpawnLocation spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.DOUBLE_GRASS}), worldIn.m_8055_(pos).m_60734_(), data.uniqueSurroundingBlocks, (Holder<Biome>)worldIn.m_204166_(pos), worldIn.m_45527_(pos), 6, worldIn.m_46803_(pos.m_7494_()));
                Entity entity = PixelmonSpawning.tallGrassSpawner.trigger(spawnLocation);
                if (entity instanceof PixelmonEntity) {
                    pixelmon = (PixelmonEntity)entity;
                }
            }
            if (pixelmon == null) {
                return;
            }
            if (PixelmonConfigProxy.getBattle().isScaleGrassBattles()) {
                int minLvl;
                int maxLvl = Math.min(party.getHighestLevel(), PixelmonServerConfig.maxLevel);
                if (maxLvl - (minLvl = party.getLowestLevel()) > 5) {
                    minLvl = maxLvl - minLvl;
                }
                PokemonLevel pokemonLevel = pixelmon.getLvl();
                if (minLvl < maxLvl) {
                    int lvl = RandomHelper.getRandom().nextInt(maxLvl - minLvl) + minLvl;
                    pokemonLevel.setLevel(lvl);
                } else {
                    pokemonLevel.setLevel(maxLvl);
                }
                pixelmon.getPokemon().getMoveset().clear();
                pixelmon.getPokemon().getMoveset().addAll(pixelmon.getForm().getMoves().loadMoveset(pokemonLevel.getPokemonLevel()));
            }
            PixelmonEntity startingPixelmon = firstAble.getOrSpawnPixelmon((Entity)player);
            this.setupBattle(worldIn, pos, player, startType, startingPixelmon, (PixelmonEntity)pixelmon);
        } else if (startType == BattleStartTypes.CAVEROCK) {
            if (PixelmonSpawning.caveRockSpawner != null && PixelmonSpawning.coordinator != null) {
                SpatialData data = TriggerSpawner.calculateSpatialData(worldIn, pos.m_7494_(), 10, true, block -> true);
                SpawnLocation spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos.m_7494_()), Sets.newHashSet((Object[])new LocationType[]{LocationType.CAVE_ROCK}), worldIn.m_8055_(pos).m_60734_(), data.uniqueSurroundingBlocks, (Holder<Biome>)worldIn.m_204166_(pos), worldIn.m_45527_(pos), 6, worldIn.m_46803_(pos.m_7494_()));
                Entity entity = PixelmonSpawning.caveRockSpawner.trigger(spawnLocation);
                if (entity instanceof PixelmonEntity) {
                    pixelmon = (PixelmonEntity)entity;
                }
            }
            if (pixelmon == null) {
                return;
            }
            if (PixelmonConfigProxy.getBattle().isScaleGrassBattles()) {
                int minLvl;
                int maxLvl = Math.min(party.getHighestLevel(), PixelmonServerConfig.maxLevel);
                if (maxLvl - (minLvl = party.getLowestLevel()) > 5) {
                    minLvl = maxLvl - minLvl;
                }
                PokemonLevel pokemonLevel = pixelmon.getLvl();
                if (minLvl < maxLvl) {
                    int lvl = RandomHelper.getRandom().nextInt(maxLvl - minLvl) + minLvl;
                    pokemonLevel.setLevel(lvl);
                } else {
                    pokemonLevel.setLevel(maxLvl);
                }
                pixelmon.getPokemon().getMoveset().clear();
                pixelmon.getPokemon().getMoveset().addAll(pixelmon.getForm().getMoves().loadMoveset(pokemonLevel.getPokemonLevel()));
            }
            PixelmonEntity startingPixelmon = firstAble.getOrSpawnPixelmon((Entity)player);
            this.setupBattle(worldIn, pos.m_7494_(), player, startType, startingPixelmon, (PixelmonEntity)pixelmon);
        } else if (startType == BattleStartTypes.HEADBUTT) {
            if (PixelmonSpawning.headbuttSpawner != null && PixelmonSpawning.coordinator != null) {
                SpatialData data = TriggerSpawner.calculateSpatialData(worldIn, pos.m_7494_(), 10, true, block -> true);
                data.baseBlock = worldIn.m_8055_(pos).m_60734_();
                SpawnLocation spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.HEADBUTT}), worldIn.m_8055_(pos).m_60734_(), data.uniqueSurroundingBlocks, (Holder<Biome>)worldIn.m_204166_(pos), worldIn.m_45527_(pos), 6, worldIn.m_46803_(pos.m_7494_()));
                Entity entity = PixelmonSpawning.headbuttSpawner.trigger(spawnLocation);
                if (entity instanceof PixelmonEntity) {
                    pixelmon = (PixelmonEntity)entity;
                } else if (entity instanceof ItemEntity) {
                    item = (ItemEntity)entity;
                }
            }
            if (pixelmon != null) {
                this.setupBattle(worldIn, pos, player, startType, fightingPokemon, (PixelmonEntity)pixelmon);
                player.m_213846_((Component)Component.m_237110_((String)"pixelmon.moveskill.headbutt.battle", (Object[])new Object[]{pixelmon.getLocalizedName()}));
            } else if (item != null) {
                player.m_213846_((Component)Component.m_237110_((String)"pixelmon.moveskill.headbutt.item", (Object[])new Object[]{item.m_32055_().m_41720_().m_7626_(item.m_32055_())}));
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"pixelmon.moveskill.headbutt.nothing"));
            }
        } else if (startType == BattleStartTypes.ROCKSMASH) {
            if (PixelmonSpawning.rocksmashSpawner != null && PixelmonSpawning.coordinator != null) {
                SpatialData data = TriggerSpawner.calculateSpatialData(worldIn, pos.m_7494_(), 10, true, block -> true);
                data.baseBlock = state.m_60734_();
                SpawnLocation spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.ROCK_SMASH}), data.baseBlock, data.uniqueSurroundingBlocks, (Holder<Biome>)worldIn.m_204166_(pos), worldIn.m_45527_(pos), 10, worldIn.m_46803_(pos.m_7494_()));
                Entity entity = PixelmonSpawning.rocksmashSpawner.trigger(spawnLocation);
                if (entity instanceof PixelmonEntity) {
                    pixelmon = (PixelmonEntity)entity;
                }
            }
            if (pixelmon != null) {
                this.setupBattle(worldIn, pos, player, startType, fightingPokemon, (PixelmonEntity)pixelmon);
            }
        } else if (startType == BattleStartTypes.SWEETSCENT) {
            if (PixelmonSpawning.sweetscentSpawner != null && PixelmonSpawning.coordinator != null) {
                SpatialData data = TriggerSpawner.calculateSpatialData(worldIn, pos.m_7494_(), 10, true, block -> true);
                SpawnLocation spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.SWEET_SCENT}), worldIn.m_8055_(pos).m_60734_(), data.uniqueSurroundingBlocks, (Holder<Biome>)worldIn.m_204166_(pos), worldIn.m_45527_(pos), 6, worldIn.m_46803_(pos.m_7494_()));
                Entity entity = PixelmonSpawning.sweetscentSpawner.trigger(spawnLocation);
                if (entity instanceof PixelmonEntity) {
                    pixelmon = (PixelmonEntity)entity;
                }
                if (pixelmon != null) {
                    this.setupBattle(worldIn, pos, player, startType, fightingPokemon, (PixelmonEntity)pixelmon);
                }
            }
        } else if (startType == BattleStartTypes.CURRY) {
            if (PixelmonSpawning.currySpawner != null && PixelmonSpawning.coordinator != null) {
                SpawnLocation spawnLocation;
                Entity entity;
                SpatialData data = TriggerSpawner.calculateSpatialData(worldIn, pos.m_7494_(), 10, true, block -> true);
                LocationType type = LocationType.CURRY_NONE;
                if (extra != null && extra[0] instanceof EnumBerryFlavor) {
                    switch ((EnumBerryFlavor)((Object)extra[0])) {
                        case SPICY: {
                            type = LocationType.CURRY_SPICY;
                            break;
                        }
                        case DRY: {
                            type = LocationType.CURRY_DRY;
                            break;
                        }
                        case SWEET: {
                            type = LocationType.CURRY_SWEET;
                            break;
                        }
                        case BITTER: {
                            type = LocationType.CURRY_BITTER;
                            break;
                        }
                        case SOUR: {
                            type = LocationType.CURRY_SOUR;
                        }
                    }
                }
                if ((entity = PixelmonSpawning.currySpawner.trigger(spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{type}), worldIn.m_8055_(pos).m_60734_(), data.uniqueSurroundingBlocks, (Holder<Biome>)worldIn.m_204166_(pos), worldIn.m_45527_(pos), 6, worldIn.m_46803_(pos.m_7494_())))) instanceof PixelmonEntity) {
                    pixelmon = (PixelmonEntity)entity;
                }
                if (pixelmon != null) {
                    if (extra != null && extra.length >= 2) {
                        EnumCurryRating rating = (EnumCurryRating)((Object)extra[1]);
                        IVStore ivs = pixelmon.getPokemon().getIVs();
                        switch (rating) {
                            case KOFFING: {
                                for (BattleStatsType t : BattleStatsType.values()) {
                                    ivs.setStat(t, RandomHelper.getRandomNumberBetween(0, 15));
                                }
                                break;
                            }
                            case MILCERY: {
                                for (int i : RandomHelper.getRandomDistinctNumbersBetween(0, 5, 1)) {
                                    ivs.setStat(BattleStatsType.values()[i], 31);
                                }
                                break;
                            }
                            case COPPERAJAH: {
                                for (int i : RandomHelper.getRandomDistinctNumbersBetween(0, 5, 2)) {
                                    ivs.setStat(BattleStatsType.values()[i], 31);
                                }
                                break;
                            }
                            case CHARIZARD: {
                                for (int i : RandomHelper.getRandomDistinctNumbersBetween(0, 5, 3)) {
                                    ivs.setStat(BattleStatsType.values()[i], 31);
                                }
                                break;
                            }
                        }
                    }
                    pixelmon.getPokemon().addRibbon(RibbonRegistry.CURRY.getValueUnsafe());
                }
            }
        } else if (startType == BattleStartTypes.FORAGE && PixelmonSpawning.forageSpawner != null && PixelmonSpawning.coordinator != null) {
            BlockPos up = pos.m_7494_();
            SpatialData data = TriggerSpawner.calculateSpatialData(worldIn, up, 10, true, block -> true);
            data.baseBlock = worldIn.m_8055_(pos).m_60734_();
            SpawnLocation spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.FORAGE}), worldIn.m_8055_(pos).m_60734_(), data.uniqueSurroundingBlocks, (Holder<Biome>)worldIn.m_204166_(pos), worldIn.m_45527_(up), 6, worldIn.m_46803_(up));
            Entity entity = PixelmonSpawning.forageSpawner.trigger(spawnLocation);
            if (entity instanceof PixelmonEntity) {
                pixelmon = (PixelmonEntity)entity;
            }
            if (pixelmon != null) {
                this.setupBattle(worldIn, pos, player, startType, fightingPokemon, (PixelmonEntity)pixelmon);
            }
        }
    }

    private void setupBattle(Level worldIn, BlockPos pos, ServerPlayer player, BattleStartTypes startType, PixelmonEntity fightingPokemon, PixelmonEntity pixelmon) {
        PlayerParticipant playerParticipant = new PlayerParticipant(player, fightingPokemon);
        WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(true, pixelmon);
        if (pixelmon == null || Pixelmon.EVENT_BUS.post((Event)new PixelmonBlockStartingBattleEvent(worldIn, pos, player, startType, fightingPokemon, pixelmon, null))) {
            return;
        }
        wildPixelmonParticipant.startedBattle = true;
        BattleRegistry.startBattle(playerParticipant, wildPixelmonParticipant);
    }
}

