/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.spawning;

import com.pixelmonmod.pixelmon.api.battles.BattleStartTypes;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.blocks.spawning.BlockSpawnData;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.level.Level;

public class BlockSpawnArea {
    public String name;
    public BattleStartTypes type;
    public HashMap<String, BlockSpawnData> blockSpawns = new HashMap();

    public BlockSpawnArea(String name, BattleStartTypes type, HashMap<String, BlockSpawnData> blockSpawns) {
        this.name = name;
        this.type = type;
        this.blockSpawns = blockSpawns;
    }

    public String getRandomPokemon(Level world) {
        return this.getPokemonFromList(world);
    }

    public String getPokemonFromList(Level world) {
        List<WorldTime> times = WorldTime.getCurrent(world);
        int totalRarity = 0;
        for (BlockSpawnData spawnList : this.blockSpawns.values()) {
            totalRarity += spawnList.getRarity(times);
        }
        if (totalRarity > 0) {
            int num = RandomHelper.getRandomNumberBetween(0, totalRarity - 1);
            int sum = 0;
            for (BlockSpawnData spawnList : this.blockSpawns.values()) {
                int rarity = 0;
                if (num < sum + (rarity += spawnList.getRarity(times))) {
                    return spawnList.name;
                }
                sum += rarity;
            }
        }
        return null;
    }
}

