/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.multi;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.enums.MultiBlockPosition;
import com.pixelmonmod.pixelmon.blocks.multi.BlockGenericSittableModelMultiblock;
import com.pixelmonmod.pixelmon.blocks.tileentity.MultiCouchTileEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class CouchBlock
extends BlockGenericSittableModelMultiblock {
    private final DyeColor color;

    public CouchBlock(DyeColor color) {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_60918_(SoundType.f_56745_).m_60955_().m_284180_(MapColor.f_283930_), 3, 1.25, 1, true);
        this.color = color;
    }

    public RenderShape m_7514_(BlockState state) {
        if (state.m_61143_(MultiBlock.MULTIPOS) == MultiBlockPosition.BASE) {
            return RenderShape.MODEL;
        }
        return super.m_7514_(state);
    }

    @Override
    protected Optional<BlockEntity> getTileEntity(BlockPos pos, BlockState state) {
        return Optional.of(new MultiCouchTileEntity(pos, state));
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    @Override
    float getSittingHeight() {
        return 0.6f;
    }

    public static Block getCouchBlock(DyeColor dyeColor) {
        switch (dyeColor) {
            default: {
                return PixelmonBlocks.white_couch;
            }
            case BLACK: {
                return PixelmonBlocks.black_couch;
            }
            case RED: {
                return PixelmonBlocks.red_couch;
            }
            case GREEN: {
                return PixelmonBlocks.green_couch;
            }
            case BROWN: {
                return PixelmonBlocks.brown_couch;
            }
            case BLUE: {
                return PixelmonBlocks.blue_couch;
            }
            case PURPLE: {
                return PixelmonBlocks.purple_couch;
            }
            case CYAN: {
                return PixelmonBlocks.cyan_couch;
            }
            case LIGHT_GRAY: {
                return PixelmonBlocks.light_gray_couch;
            }
            case GRAY: {
                return PixelmonBlocks.gray_couch;
            }
            case PINK: {
                return PixelmonBlocks.pink_couch;
            }
            case LIME: {
                return PixelmonBlocks.lime_couch;
            }
            case YELLOW: {
                return PixelmonBlocks.yellow_couch;
            }
            case LIGHT_BLUE: {
                return PixelmonBlocks.light_blue_couch;
            }
            case MAGENTA: {
                return PixelmonBlocks.magenta_couch;
            }
            case ORANGE: 
        }
        return PixelmonBlocks.orange_couch;
    }
}

