/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.enums.MultiBlockPosition;
import com.pixelmonmod.pixelmon.blocks.machines.VendingMachineShop;
import com.pixelmonmod.pixelmon.blocks.tileentity.VendingMachineTileEntity;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.vendingMachine.SetVendingMachineDataPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class VendingMachineBlock
extends MultiBlock {
    private VendingMachineShop shop;

    public VendingMachineBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(2.0f).m_60918_(SoundType.f_56743_).m_60955_().m_60953_(state -> 10).m_284180_(MapColor.f_283906_), 1, 2.0, 1);
    }

    @Override
    protected Optional<BlockEntity> getTileEntity(BlockPos pos, BlockState state) {
        return Optional.of(new VendingMachineTileEntity(pos, state));
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return ((MultiBlockPosition)((Object)p_149645_1_.m_61143_((Property)MULTIPOS))).equals((Object)MultiBlockPosition.BASE) ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public boolean m_7420_(BlockState p_200123_1_, BlockGetter p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        if (hand != InteractionHand.OFF_HAND) {
            NetworkHelper.sendPacket(new SetVendingMachineDataPacket(this.getShop().getItems()), (ServerPlayer)player);
            OpenScreenPacket.open(player, EnumGuiScreen.VendingMachine, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
        return InteractionResult.SUCCESS;
    }

    public VendingMachineShop getShop() {
        if (this.shop == null) {
            this.shop = new VendingMachineShop();
        }
        return this.shop;
    }

    @Override
    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 10;
    }

    public static Block getVendingMachineBlock(DyeColor dyeColor) {
        switch (dyeColor) {
            default: {
                return PixelmonBlocks.white_vending_machine;
            }
            case BLACK: {
                return PixelmonBlocks.black_vending_machine;
            }
            case RED: {
                return PixelmonBlocks.red_vending_machine;
            }
            case GREEN: {
                return PixelmonBlocks.green_vending_machine;
            }
            case BROWN: {
                return PixelmonBlocks.brown_vending_machine;
            }
            case BLUE: {
                return PixelmonBlocks.blue_vending_machine;
            }
            case PURPLE: {
                return PixelmonBlocks.purple_vending_machine;
            }
            case CYAN: {
                return PixelmonBlocks.cyan_vending_machine;
            }
            case LIGHT_GRAY: {
                return PixelmonBlocks.light_gray_vending_machine;
            }
            case GRAY: {
                return PixelmonBlocks.gray_vending_machine;
            }
            case PINK: {
                return PixelmonBlocks.pink_vending_machine;
            }
            case LIME: {
                return PixelmonBlocks.lime_vending_machine;
            }
            case YELLOW: {
                return PixelmonBlocks.yellow_vending_machine;
            }
            case LIGHT_BLUE: {
                return PixelmonBlocks.light_blue_vending_machine;
            }
            case MAGENTA: {
                return PixelmonBlocks.magenta_vending_machine;
            }
            case ORANGE: 
        }
        return PixelmonBlocks.orange_vending_machine;
    }
}

