/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.enums.MultiBlockPosition;
import com.pixelmonmod.pixelmon.blocks.tileentity.TradeMachineTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class TradeMachineBlock
extends MultiBlock
implements IBlockHasOwner {
    private DyeColor color;

    public TradeMachineBlock(DyeColor color) {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(3.5f).m_60918_(SoundType.f_56742_).m_60955_().m_284180_(MapColor.f_283906_), 3, 1.875, 1, true);
        this.color = color;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return TradeMachineBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)TileEntityRegistration.TRADE_MACHINE.get()), TradeMachineTileEntity::tick);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_() || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.SUCCESS;
        }
        pos = this.findBaseBlock((BlockGetter)world, pos.m_122032_(), state);
        if (!(player.f_36096_ instanceof InventoryMenu)) {
            return InteractionResult.FAIL;
        }
        TradeMachineTileEntity tileEntityTradeMachine = BlockHelper.getTileEntity(TradeMachineTileEntity.class, (LevelReader)world, pos);
        if (tileEntityTradeMachine != null) {
            if (tileEntityTradeMachine.playerCount < 2) {
                tileEntityTradeMachine.registerPlayer((ServerPlayer)player);
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.tradefull", new Object[0]);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape m_7514_(BlockState state) {
        if (state.m_61143_(MultiBlock.MULTIPOS) == MultiBlockPosition.BASE) {
            return RenderShape.MODEL;
        }
        return super.m_7514_(state);
    }

    @Override
    public void setOwner(BlockPos pos, Player playerIn) {
        TradeMachineTileEntity tileEntityTradeMachine = BlockHelper.getTileEntity(TradeMachineTileEntity.class, (LevelReader)playerIn.m_20193_(), pos);
        tileEntityTradeMachine.setOwner(playerIn.m_20148_());
    }

    @Override
    protected Optional<BlockEntity> getTileEntity(BlockPos pos, BlockState state) {
        return Optional.of(new TradeMachineTileEntity(pos, state));
    }

    public static Block getTradeMachineBlock(DyeColor dyeColor) {
        switch (dyeColor) {
            default: {
                return PixelmonBlocks.white_trade_machine;
            }
            case BLACK: {
                return PixelmonBlocks.black_trade_machine;
            }
            case RED: {
                return PixelmonBlocks.red_trade_machine;
            }
            case GREEN: {
                return PixelmonBlocks.green_trade_machine;
            }
            case BROWN: {
                return PixelmonBlocks.brown_trade_machine;
            }
            case BLUE: {
                return PixelmonBlocks.blue_trade_machine;
            }
            case PURPLE: {
                return PixelmonBlocks.purple_trade_machine;
            }
            case CYAN: {
                return PixelmonBlocks.cyan_trade_machine;
            }
            case LIGHT_GRAY: {
                return PixelmonBlocks.light_gray_trade_machine;
            }
            case GRAY: {
                return PixelmonBlocks.gray_trade_machine;
            }
            case PINK: {
                return PixelmonBlocks.pink_trade_machine;
            }
            case LIME: {
                return PixelmonBlocks.lime_trade_machine;
            }
            case YELLOW: {
                return PixelmonBlocks.yellow_trade_machine;
            }
            case LIGHT_BLUE: {
                return PixelmonBlocks.light_blue_trade_machine;
            }
            case MAGENTA: {
                return PixelmonBlocks.magenta_trade_machine;
            }
            case ORANGE: 
        }
        return PixelmonBlocks.orange_trade_machine;
    }
}

