/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.enums.EnumBlockPos;
import com.pixelmonmod.pixelmon.blocks.tileentity.TimespaceAltarTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TimespaceAltarBlock
extends GenericRotatableModelBlock {
    public static final EnumProperty<EnumBlockPos> BLOCKPOS = EnumProperty.m_61587_((String)"blockpos", EnumBlockPos.class);
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)30.0, (double)16.0);

    public TimespaceAltarBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(-1.0f, 6000000.0f).m_60977_().m_284180_(MapColor.f_283761_));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return TimespaceAltarBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)TileEntityRegistration.TIMESPACE_ALTAR.get()), TimespaceAltarTileEntity::tick);
    }

    public VoxelShape m_5939_(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return SHAPE;
    }

    public VoxelShape m_6079_(BlockState p_199600_1_, BlockGetter p_199600_2_, BlockPos p_199600_3_) {
        return SHAPE;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BLOCKPOS});
    }

    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        if (blockState.m_61143_(BLOCKPOS) == EnumBlockPos.BOTTOM) {
            return new TimespaceAltarTileEntity(blockPos, blockState);
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        TimespaceAltarTileEntity tile;
        ItemStack heldItem = player.m_21120_(hand);
        if (level.f_46443_ || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.SUCCESS;
        }
        if (blockState.m_61143_(BLOCKPOS) == EnumBlockPos.TOP) {
            blockPos = blockPos.m_7495_();
        }
        if ((tile = BlockHelper.getTileEntity(TimespaceAltarTileEntity.class, (LevelReader)level, blockPos)) != null) {
            if (!heldItem.m_41619_() && heldItem.m_41720_() == PixelmonItems.red_chain && tile.chainIn) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timespace.alreadychain", new Object[0]);
                return InteractionResult.FAIL;
            }
            tile.activate(player, this, blockState, heldItem);
        }
        return player.m_7500_() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(BLOCKPOS, (Comparable)((Object)EnumBlockPos.BOTTOM));
    }

    @Override
    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState p_220080_1_, BlockGetter p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }
}

