/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.pixelmon.api.enums.ShrineType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.BirdShrineTileEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShrineBlock
extends GenericRotatableModelBlock {
    public static final BooleanProperty USED = BooleanProperty.m_61465_((String)"used");
    private ShrineType rockType;

    public ShrineBlock(ShrineType rockType) {
        super(BlockBehaviour.Properties.m_284310_().m_60988_().m_60955_().m_60913_(-1.0f, 3600000.0f).m_222994_().m_60977_().m_284180_(MapColor.f_283825_));
        this.rockType = rockType;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)USED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{USED});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)USED, (Comparable)Boolean.valueOf(false));
    }

    public ItemStack m_7397_(BlockGetter p_49823_, BlockPos p_49824_, BlockState p_49825_) {
        if (this.rockType == ShrineType.ARTICUNO) {
            return new ItemStack((ItemLike)Item.m_41439_((Block)PixelmonBlocks.articuno_shrine));
        }
        if (this.rockType == ShrineType.ZAPDOS) {
            return new ItemStack((ItemLike)Item.m_41439_((Block)PixelmonBlocks.zapdos_shrine));
        }
        if (this.rockType == ShrineType.MOLTRES) {
            return new ItemStack((ItemLike)Item.m_41439_((Block)PixelmonBlocks.moltres_shrine));
        }
        return null;
    }

    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new BirdShrineTileEntity(blockPos, blockState);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (world.f_46443_ || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.SUCCESS;
        }
        BirdShrineTileEntity tile = BlockHelper.getTileEntity(BirdShrineTileEntity.class, (LevelReader)world, pos);
        if (tile != null) {
            tile.activate(player, this, state, heldItem);
            world.m_46717_(pos, state.m_60734_());
            world.m_46717_(pos, (Block)this);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean getIsUsed(BirdShrineTileEntity tile) {
        return (Boolean)tile.m_58904_().m_8055_(tile.m_58899_()).m_61143_((Property)USED);
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        level.m_46717_(pos, state.m_60734_());
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BirdShrineTileEntity tile = (BirdShrineTileEntity)blockAccess.m_7702_(pos);
        if (this.getIsUsed(tile)) {
            return 15;
        }
        return 0;
    }

    @Override
    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    @Override
    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            BlockItem.m_40582_((Level)worldIn, (Player)((Player)placer), (BlockPos)pos, (ItemStack)stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState p_220080_1_, BlockGetter p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public ShrineType getRockType() {
        return this.rockType;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }
}

