/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.FormRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.GenderRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.PaletteRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.ShinyRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class PokemonRarity {
    public PokemonSpecification pokemon;
    public int rarity;

    public PokemonRarity(PokemonSpecification pokemon, int rarity) {
        this.pokemon = pokemon;
        this.rarity = rarity;
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.pokemon.toString());
        buffer.writeInt(this.rarity);
    }

    public void writeToList(ListTag list) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("pokemon", (Tag)this.pokemon.write(new CompoundTag()));
        nbt.m_128405_("rarity", this.rarity);
        list.add((Object)nbt);
    }

    public ResourceLocation getSprite() {
        Species species = this.pokemon.getValue(SpeciesRequirement.class).orElse(PixelmonSpecies.BULBASAUR).getValueUnsafe();
        Stats form = this.pokemon.getValue(FormRequirement.class).map(species::getForm).orElse(species.getDefaultForm());
        Gender gender = this.pokemon.getValue(GenderRequirement.class).orElse(form.getDefaultGender());
        String palette = this.pokemon.getValue(PaletteRequirement.class).orElseGet(() -> this.pokemon.getValue(ShinyRequirement.class).filter(b -> b).map(b -> "shiny").orElse("none"));
        PaletteProperties paletteProperties = form.getGenderProperties(gender).getPalette(palette);
        if (paletteProperties == null) {
            return form.getGenderProperties(gender).getDefaultPalette().getSprite();
        }
        return paletteProperties.getSprite();
    }

    public static List<PokemonRarity> fromNbt(CompoundTag nbt) {
        ArrayList specs = Lists.newArrayList();
        if (!nbt.m_128441_("specs")) {
            return specs;
        }
        ListTag specs1 = nbt.m_128437_("specs", 10);
        for (Tag inbt : specs1) {
            CompoundTag spec = (CompoundTag)inbt;
            PokemonSpecification pokemonSpec = PokemonSpecificationProxy.fromNbt(spec.m_128469_("pokemon")).get();
            int rarity = spec.m_128451_("rarity");
            specs.add(new PokemonRarity(pokemonSpec, rarity));
        }
        return specs;
    }

    public static void addToNbt(CompoundTag nbt, List<PokemonRarity> rarities) {
        ListTag list = new ListTag();
        for (PokemonRarity rarity : rarities) {
            rarity.writeToList(list);
        }
        nbt.m_128365_("specs", (Tag)list);
    }

    public static PokemonRarity readFromBuffer(FriendlyByteBuf buffer) {
        return new PokemonRarity(PokemonSpecificationProxy.create(buffer.m_130277_()).get(), buffer.readInt());
    }
}

