/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.enums.MultiBlockPosition;
import com.pixelmonmod.pixelmon.blocks.tileentity.PCTileEntity;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc.ClientChangeOpenPCPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PCBlock
extends MultiBlock
implements IBlockHasOwner {
    private DyeColor color;

    public PCBlock(DyeColor color) {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60978_(5.0f).m_278166_(PushReaction.BLOCK).m_60999_().m_284180_(MapColor.f_283906_), 1, 2.0, 1);
        this.color = color;
    }

    public RenderShape m_7514_(BlockState state) {
        if (state.m_61143_(MultiBlock.MULTIPOS) == MultiBlockPosition.BASE) {
            return RenderShape.MODEL;
        }
        return super.m_7514_(state);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        pos = this.findBaseBlock((BlockGetter)world, new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), state);
        if (!(player.f_36096_ instanceof InventoryMenu)) {
            return InteractionResult.FAIL;
        }
        PCTileEntity tileEntityPC = BlockHelper.getTileEntity(PCTileEntity.class, (LevelReader)world, pos);
        PCStorage pc = StorageProxy.getPCNow((ServerPlayer)player, tileEntityPC);
        StorageProxy.getPartyNow((ServerPlayer)player).retrieveAll("BlockInteract");
        NetworkHelper.sendPacket(new ClientChangeOpenPCPacket(pc.uuid), (ServerPlayer)player);
        OpenScreenPacket.open(player, EnumGuiScreen.PC, new int[0]);
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistration.PC.get(), SoundSource.BLOCKS, 0.7f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    @Override
    public void setOwner(BlockPos pos, Player playerIn) {
        UUID playerID = playerIn.m_20148_();
        PCTileEntity tileEntityPC = BlockHelper.getTileEntity(PCTileEntity.class, (LevelReader)playerIn.m_20193_(), pos);
        tileEntityPC.setOwner(playerID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState p_220080_1_, BlockGetter p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    @Override
    protected Optional<BlockEntity> getTileEntity(BlockPos pos, BlockState state) {
        return Optional.of(new PCTileEntity(pos, state));
    }

    @Override
    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }

    public static Block getPCBlock(DyeColor dyeColor) {
        switch (dyeColor) {
            default: {
                return PixelmonBlocks.white_pc;
            }
            case BLACK: {
                return PixelmonBlocks.black_pc;
            }
            case RED: {
                return PixelmonBlocks.red_pc;
            }
            case GREEN: {
                return PixelmonBlocks.green_pc;
            }
            case BROWN: {
                return PixelmonBlocks.brown_pc;
            }
            case BLUE: {
                return PixelmonBlocks.blue_pc;
            }
            case PURPLE: {
                return PixelmonBlocks.purple_pc;
            }
            case CYAN: {
                return PixelmonBlocks.cyan_pc;
            }
            case LIGHT_GRAY: {
                return PixelmonBlocks.light_gray_pc;
            }
            case GRAY: {
                return PixelmonBlocks.gray_pc;
            }
            case PINK: {
                return PixelmonBlocks.pink_pc;
            }
            case LIME: {
                return PixelmonBlocks.lime_pc;
            }
            case YELLOW: {
                return PixelmonBlocks.yellow_pc;
            }
            case LIGHT_BLUE: {
                return PixelmonBlocks.light_blue_pc;
            }
            case MAGENTA: {
                return PixelmonBlocks.magenta_pc;
            }
            case ORANGE: 
        }
        return PixelmonBlocks.orange_pc;
    }
}

