/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.HealerEvent;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.tileentity.HealerTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.eventbus.api.Event;

public class HealerBlock
extends BaseEntityBlock
implements IBlockHasOwner {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final AABB AABB = new AABB(0.03125, 0.0, 0.03125, 0.96875, 0.875, 0.96875);

    public HealerBlock(DyeColor color) {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60978_(3.5f).m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283906_));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return HealerBlock.m_152132_(entityType, (BlockEntityType)((BlockEntityType)TileEntityRegistration.HEALER.get()), HealerTileEntity::tick);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83064_((AABB)AABB);
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_6843_(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.m_61124_((Property)FACING, (Comparable)p_185499_2_.m_55954_((Direction)p_185499_1_.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_ || handIn == InteractionHand.OFF_HAND) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(handIn);
        HealerTileEntity healer = (HealerTileEntity)worldIn.m_7702_(pos);
        if (healer == null) {
            return InteractionResult.FAIL;
        }
        DyeColor dyeColor = DyeColor.getColor((ItemStack)heldItem);
        if (dyeColor == null) {
            if (healer.beingUsed) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.healer", new Object[0]);
                return InteractionResult.FAIL;
            }
            boolean post = Pixelmon.EVENT_BUS.post((Event)new HealerEvent.Pre(player, pos, false));
            if (post) {
                return InteractionResult.FAIL;
            }
            healer.use(player);
            return InteractionResult.CONSUME;
        }
        if (!Objects.equals(healer.getOwnerUUID(), player.m_20148_())) {
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.healer.ownership", new Object[0]);
            return InteractionResult.FAIL;
        }
        if (player.m_21120_(handIn).m_41720_() instanceof DyeItem) {
            BlockState st = HealerBlock.getHealerBlock(dyeColor).m_49966_();
            if ((st = (BlockState)st.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))) != state) {
                worldIn.m_46597_(pos, st);
                this.setOwner(pos, player);
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void setOwner(BlockPos pos, Player playerIn) {
        UUID playerID = playerIn.m_20148_();
        HealerTileEntity healer = BlockHelper.getTileEntity(HealerTileEntity.class, (LevelReader)playerIn.m_20193_(), pos);
        if (healer == null) {
            return;
        }
        healer.setOwner(playerID);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(worldIn, pos, state, player);
        if (worldIn.f_46443_) {
            return;
        }
        HealerTileEntity healer = BlockHelper.getTileEntity(HealerTileEntity.class, (LevelReader)worldIn, pos);
        if (healer != null && healer.beingUsed && healer.player != null) {
            healer.player.m_6915_();
        }
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        HealerTileEntity healer = (HealerTileEntity)blockAccess.m_7702_(pos);
        if (healer == null || !healer.beingUsed) {
            return 0;
        }
        return 15;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new HealerTileEntity(blockPos, blockState);
    }

    public static Block getHealerBlock(DyeColor dyeColor) {
        switch (dyeColor) {
            default: {
                return PixelmonBlocks.white_healer;
            }
            case BLACK: {
                return PixelmonBlocks.black_healer;
            }
            case RED: {
                return PixelmonBlocks.red_healer;
            }
            case GREEN: {
                return PixelmonBlocks.green_healer;
            }
            case BROWN: {
                return PixelmonBlocks.brown_healer;
            }
            case BLUE: {
                return PixelmonBlocks.blue_healer;
            }
            case PURPLE: {
                return PixelmonBlocks.purple_healer;
            }
            case CYAN: {
                return PixelmonBlocks.cyan_healer;
            }
            case LIGHT_GRAY: {
                return PixelmonBlocks.light_gray_healer;
            }
            case GRAY: {
                return PixelmonBlocks.gray_healer;
            }
            case PINK: {
                return PixelmonBlocks.pink_healer;
            }
            case LIME: {
                return PixelmonBlocks.lime_healer;
            }
            case YELLOW: {
                return PixelmonBlocks.yellow_healer;
            }
            case LIGHT_BLUE: {
                return PixelmonBlocks.light_blue_healer;
            }
            case MAGENTA: {
                return PixelmonBlocks.magenta_healer;
            }
            case ORANGE: 
        }
        return PixelmonBlocks.orange_healer;
    }
}

