/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.FossilMachineEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.enums.MultiBlockPosition;
import com.pixelmonmod.pixelmon.blocks.tileentity.FossilMachineTileEntity;
import com.pixelmonmod.pixelmon.enums.items.EnumFossils;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.FossilItem;
import com.pixelmonmod.pixelmon.items.PokeBallItem;
import com.pixelmonmod.pixelmon.items.PokeBallPart;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class FossilMachineBlock
extends MultiBlock {
    public FossilMachineBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60978_(1.0f).m_284180_(MapColor.f_283906_), 1, 2.0, 1);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return FossilMachineBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)TileEntityRegistration.FOSSIL_MACHINE.get()), FossilMachineTileEntity::tick);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        FossilMachineTileEntity machine;
        if (state.m_61143_(MultiBlock.MULTIPOS) == MultiBlockPosition.BASE && (machine = BlockHelper.getTileEntity(FossilMachineTileEntity.class, (LevelReader)world, pos)) != null && machine.fossilProgress > 1.0f && machine.pokemonProgress < 3200.0f) {
            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12287_, SoundSource.BLOCKS, 0.01f, random.m_188501_() * 0.4f + 0.8f, true);
        }
    }

    public void capturePokemonInMachine(Level world, BlockPos pos, Player player) {
        FossilMachineTileEntity tile = (FossilMachineTileEntity)world.m_7702_(pos);
        if (tile != null) {
            PokemonSpecification spec = PokemonSpecificationProxy.create(tile.currentPokemon + " pokemonLevel:1").get();
            Pokemon pokemon = spec.create();
            pokemon.setPalette(tile.isShiny ? "shiny" : "");
            pokemon.setBall(tile.pokeball);
            boolean hasSummer = false;
            for (Pokemon p : StorageProxy.getPartyNow((ServerPlayer)player).getTeam()) {
                if (p == null || !p.isPalette("summer")) continue;
                hasSummer = true;
            }
            if (hasSummer && pokemon.hasPalette("summer")) {
                pokemon.setPalette("summer");
            }
            if (Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent((ServerPlayer)player, pokemon, "Fossil"))) {
                return;
            }
            StorageProxy.getPartyNow((ServerPlayer)player).add(pokemon);
            pokemon.setFriendship(pokemon.getForm().getSpawn().getBaseFriendship());
            ((ServerLevel)world).m_7726_().m_8450_(pos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean obtainedPokemon;
        if (world.m_5776_() || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        pos = this.findBaseBlock((BlockGetter)world, pos.m_122032_(), state);
        FossilMachineTileEntity tile = BlockHelper.getTileEntity(FossilMachineTileEntity.class, (LevelReader)world, pos);
        ServerChunkCache playerChunkMap = ((ServerLevel)world).m_7726_();
        Item heldItemType = null;
        if (!heldItem.m_41619_()) {
            heldItemType = heldItem.m_41720_();
        }
        boolean heldItemIsFossil = heldItemType instanceof FossilItem;
        boolean heldItemIsPokeBall = heldItemType instanceof PokeBallItem;
        boolean bl = obtainedPokemon = tile.pokeball != null && tile.pokemonOccupied && tile.pokemonProgress == 3200.0f;
        if (!obtainedPokemon) {
            FossilMachineEvent.RemovePokeball event;
            if (tile.pokeball != null && !heldItemIsFossil && !Pixelmon.EVENT_BUS.post((Event)(event = new FossilMachineEvent.RemovePokeball((ServerPlayer)player, tile.pokeball, tile)))) {
                DropItemHelper.giveItemStack((ServerPlayer)player, event.getPokeball().getBallItem(), false);
                tile.pokeball = null;
            }
            EnumFossils prevFossil = tile.currentFossil;
            if (tile.currentFossil != null && !heldItemIsPokeBall) {
                boolean dropExisting;
                boolean bl2 = dropExisting = prevFossil != EnumFossils.NULL;
                if (heldItemIsFossil) {
                    FossilItem itemFossil = (FossilItem)heldItemType;
                    if (tile.currentFossil == EnumFossils.BIRD) {
                        if (itemFossil.fossil == EnumFossils.DRAKE) {
                            tile.currentFossil = EnumFossils.DZ;
                            if (!player.m_7500_()) {
                                heldItem.m_41774_(1);
                            }
                            playerChunkMap.m_8450_(pos);
                            dropExisting = false;
                        }
                        if (itemFossil.fossil == EnumFossils.DINO) {
                            tile.currentFossil = EnumFossils.AZ;
                            if (!player.m_7500_()) {
                                heldItem.m_41774_(1);
                            }
                            playerChunkMap.m_8450_(pos);
                            dropExisting = false;
                        }
                    }
                    if (tile.currentFossil == EnumFossils.FISH) {
                        if (itemFossil.fossil == EnumFossils.DRAKE) {
                            tile.currentFossil = EnumFossils.DV;
                            if (!player.m_7500_()) {
                                heldItem.m_41774_(1);
                            }
                            playerChunkMap.m_8450_(pos);
                            dropExisting = false;
                        }
                        if (itemFossil.fossil == EnumFossils.DINO) {
                            tile.currentFossil = EnumFossils.AV;
                            if (!player.m_7500_()) {
                                heldItem.m_41774_(1);
                            }
                            playerChunkMap.m_8450_(pos);
                            dropExisting = false;
                        }
                    }
                    if (tile.currentFossil == EnumFossils.DRAKE) {
                        if (itemFossil.fossil == EnumFossils.FISH) {
                            tile.currentFossil = EnumFossils.DV;
                            if (!player.m_7500_()) {
                                heldItem.m_41774_(1);
                            }
                            playerChunkMap.m_8450_(pos);
                            dropExisting = false;
                        }
                        if (itemFossil.fossil == EnumFossils.BIRD) {
                            tile.currentFossil = EnumFossils.DZ;
                            if (!player.m_7500_()) {
                                heldItem.m_41774_(1);
                            }
                            playerChunkMap.m_8450_(pos);
                            dropExisting = false;
                        }
                    }
                    if (tile.currentFossil == EnumFossils.DINO) {
                        if (itemFossil.fossil == EnumFossils.FISH) {
                            tile.currentFossil = EnumFossils.AV;
                            if (!player.m_7500_()) {
                                heldItem.m_41774_(1);
                            }
                            playerChunkMap.m_8450_(pos);
                            dropExisting = false;
                        }
                        if (itemFossil.fossil == EnumFossils.BIRD) {
                            tile.currentFossil = EnumFossils.AZ;
                            if (!player.m_7500_()) {
                                heldItem.m_41774_(1);
                            }
                            playerChunkMap.m_8450_(pos);
                            dropExisting = false;
                        }
                    }
                }
                if (dropExisting) {
                    FossilMachineEvent.RemoveFossil event2;
                    EnumFossils[] fossilItems = new EnumFossils[2];
                    if (prevFossil.getIndex() < -1) {
                        switch (prevFossil) {
                            default: {
                                break;
                            }
                            case AV: {
                                fossilItems[0] = EnumFossils.FISH;
                                fossilItems[1] = EnumFossils.DINO;
                                break;
                            }
                            case AZ: {
                                fossilItems[0] = EnumFossils.BIRD;
                                fossilItems[1] = EnumFossils.DINO;
                                break;
                            }
                            case DV: {
                                fossilItems[0] = EnumFossils.FISH;
                                fossilItems[1] = EnumFossils.DRAKE;
                                break;
                            }
                            case DZ: {
                                fossilItems[0] = EnumFossils.DRAKE;
                                fossilItems[1] = EnumFossils.BIRD;
                                break;
                            }
                        }
                    } else {
                        fossilItems[0] = prevFossil;
                        fossilItems[1] = null;
                    }
                    if (!Pixelmon.EVENT_BUS.post((Event)(event2 = new FossilMachineEvent.RemoveFossil((ServerPlayer)player, fossilItems, tile)))) {
                        for (EnumFossils fossilItem : fossilItems) {
                            if (fossilItem == null) continue;
                            DropItemHelper.giveItemStack((ServerPlayer)player, new ItemStack((ItemLike)fossilItem.getItem()), false);
                        }
                        tile.currentFossil = EnumFossils.NULL;
                        tile.fossilProgress = 0.0f;
                        tile.pokemonProgress = 0.0f;
                    }
                }
            }
            if (!heldItem.m_41619_()) {
                if (heldItemIsPokeBall && tile.pokeball == null) {
                    PokeBall pokeballToPut = PokeBallPart.getPokeBall(player.m_21205_()).get();
                    if (!Pixelmon.EVENT_BUS.post((Event)new FossilMachineEvent.PutPokeball((ServerPlayer)player, pokeballToPut, tile))) {
                        tile.pokeball = pokeballToPut;
                        heldItem.m_41774_(1);
                        playerChunkMap.m_8450_(pos);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (heldItemIsFossil && tile.currentFossil == EnumFossils.NULL && !tile.pokemonOccupied && prevFossil == EnumFossils.NULL) {
                    FossilMachineEvent.PutFossil event3 = new FossilMachineEvent.PutFossil((ServerPlayer)player, heldItem.m_41720_(), tile);
                    if (!Pixelmon.EVENT_BUS.post((Event)event3)) {
                        tile.currentFossil = ((FossilItem)heldItemType).fossil;
                        if (!player.m_7500_()) {
                            heldItem.m_41774_(1);
                        }
                        playerChunkMap.m_8450_(pos);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (obtainedPokemon) {
            this.capturePokemonInMachine(world, pos, player);
        }
        if (obtainedPokemon || !tile.pokemonOccupied && !heldItemIsFossil && !heldItemIsPokeBall) {
            tile.pokemonOccupied = false;
            tile.fossilProgress = 0.0f;
            tile.pokemonProgress = 0.0f;
            tile.currentFossil = EnumFossils.NULL;
            tile.currentPokemon = "";
            tile.pokeball = null;
            tile.completionRate = 0;
            playerChunkMap.m_8450_(pos);
            return InteractionResult.SUCCESS;
        }
        playerChunkMap.m_8450_(pos);
        return InteractionResult.FAIL;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @Override
    protected Optional<BlockEntity> getTileEntity(BlockPos pos, BlockState state) {
        return Optional.of(new FossilMachineTileEntity(pos, state));
    }
}

