/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.FossilCleanerEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.FossilCleanerTileEntity;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.items.CoveredFossilItem;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class FossilCleanerBlock
extends MultiBlock {
    public FossilCleanerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_60955_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283906_), 1, 1.0, 1);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return FossilCleanerBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)TileEntityRegistration.FOSSIL_CLEANER.get()), FossilCleanerTileEntity::tick);
    }

    @Override
    protected Optional<BlockEntity> getTileEntity(BlockPos pos, BlockState state) {
        return Optional.of(new FossilCleanerTileEntity(pos, state));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_ || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.SUCCESS;
        }
        FossilCleanerTileEntity fossilCleaner = BlockHelper.getTileEntity(FossilCleanerTileEntity.class, (LevelReader)world, pos);
        ServerChunkCache playerChunkMap = ((ServerLevel)world).m_7726_();
        if (fossilCleaner != null) {
            if (!fossilCleaner.m_7983_()) {
                Item item = fossilCleaner.getItemInCleaner();
                FossilCleanerEvent.ObtainingCleanFossil event = new FossilCleanerEvent.ObtainingCleanFossil((ServerPlayer)player, fossilCleaner, item);
                if (!Pixelmon.EVENT_BUS.post((Event)event)) {
                    fossilCleaner.setItemInCleaner(null);
                    DropItemHelper.giveItemStack((ServerPlayer)player, new ItemStack((ItemLike)event.getFossil()), false);
                }
            } else {
                FossilCleanerEvent.PutFossil event;
                ItemStack heldItem = player.m_21120_(hand);
                if (!heldItem.m_41619_() && heldItem.m_41720_() instanceof CoveredFossilItem && !Pixelmon.EVENT_BUS.post((Event)(event = new FossilCleanerEvent.PutFossil((ServerPlayer)player, fossilCleaner, heldItem.m_41720_())))) {
                    fossilCleaner.setItemInCleaner(heldItem.m_41720_());
                    heldItem.m_41774_(1);
                    if (heldItem.m_41613_() <= 0) {
                        player.m_21008_(hand, ItemStack.f_41583_);
                    }
                }
            }
            playerChunkMap.m_8450_(pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!player.m_7500_()) {
            this.m_6786_((LevelAccessor)world, pos, world.m_8055_(pos));
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void m_6786_(LevelAccessor world, BlockPos pos, BlockState state) {
        FossilCleanerTileEntity fossilCleaner;
        if (!world.m_5776_() && (fossilCleaner = BlockHelper.getTileEntity(FossilCleanerTileEntity.class, (LevelReader)world, pos)) != null && fossilCleaner.getItemInCleaner() != null) {
            ItemEntity entityItem = new ItemEntity((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_() + 1.3, (double)pos.m_123343_(), new ItemStack((ItemLike)fossilCleaner.getItemInCleaner()));
            entityItem.m_32010_(10);
            world.m_7967_((Entity)entityItem);
        }
        super.m_6786_(world, pos, state);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        FossilCleanerTileEntity tile = (FossilCleanerTileEntity)blockAccess.m_7702_(pos);
        if (tile != null && tile.isOn()) {
            if (tile.timer == 360) {
                return 15;
            }
            return tile.timer / 24 + 1;
        }
        return 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }
}

