/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.machines;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.CloningMachineTileEntity;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CloningMachineBlock
extends MultiBlock {
    public CloningMachineBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_60955_().m_284180_(MapColor.f_283906_), 5, 3.0, 1);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return CloningMachineBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TileEntityRegistration.CLONING_MACHINE.get()), CloningMachineTileEntity::tick);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_() || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        BlockPos loc = this.findBaseBlock((BlockGetter)world, pos.m_122032_(), state);
        CloningMachineTileEntity te = BlockHelper.getTileEntity(CloningMachineTileEntity.class, (LevelReader)world, loc);
        if (te != null) {
            te.activate(player, heldItem);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected Optional<BlockEntity> getTileEntity(BlockPos pos, BlockState state) {
        return Optional.of(new CloningMachineTileEntity(pos, state));
    }

    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        CloningMachineTileEntity ranchBlock = (CloningMachineTileEntity)world.m_7702_(pos);
        if (ranchBlock == null || ranchBlock.owner == null || player.m_20148_().equals(ranchBlock.owner) || player.m_7500_()) {
            return super.m_5880_(state, player, world, pos);
        }
        return -1.0f;
    }

    @Override
    public void m_6810_(BlockState blockState, Level level, BlockPos pos, BlockState newState, boolean p_196243_5_) {
        if (!blockState.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = level.m_7702_(pos);
            if (tileentity instanceof CloningMachineTileEntity) {
                ItemStack itemStack = null;
                ((CloningMachineTileEntity)tileentity).onDestroy();
                itemStack = ((CloningMachineTileEntity)tileentity).isBroken ? new ItemStack((ItemLike)PixelmonItems.aluminium_ingot.m_5456_(), 1) : new ItemStack((ItemLike)PixelmonBlocks.cloning_machine.m_5456_(), 1);
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), itemStack);
                level.m_7967_((Entity)itemEntity);
            }
            super.m_6810_(blockState, level, pos, newState, p_196243_5_);
        }
    }
}

