/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.furniture;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.enums.GymSignType;
import com.pixelmonmod.pixelmon.blocks.tileentity.GymSignTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.init.registry.BlockRegistration;
import com.pixelmonmod.pixelmon.items.GymSignItem;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GymSignBlock
extends GenericRotatableModelBlock
implements IBlockHasOwner {
    public static final VoxelShape HANGING_SHAPE_NORTH = Block.m_49796_((double)1.0, (double)1.0, (double)6.0, (double)15.0, (double)16.0, (double)10.0);
    public static final VoxelShape HANGING_SHAPE_SOUTH = Block.m_49796_((double)1.0, (double)1.0, (double)6.0, (double)15.0, (double)16.0, (double)10.0);
    public static final VoxelShape HANGING_SHAPE_EAST = Block.m_49796_((double)6.0, (double)1.0, (double)1.0, (double)10.0, (double)16.0, (double)15.0);
    public static final VoxelShape HANGING_SHAPE_WEST = Block.m_49796_((double)6.0, (double)1.0, (double)1.0, (double)10.0, (double)16.0, (double)15.0);
    public static final VoxelShape WALL_SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape WALL_SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    public static final VoxelShape WALL_SHAPE_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    public static final VoxelShape WALL_SHAPE_WEST = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final GymSignType gymSignType;

    public GymSignBlock(GymSignType gymSignType) {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_60918_(SoundType.f_56743_).m_284180_(MapColor.f_283906_));
        this.gymSignType = gymSignType;
        this.m_49959_((BlockState)this.f_49792_.m_61090_());
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        DyeColor color = ((GymSignItem)context.m_43722_().m_41720_()).getDyeColor();
        BlockState potentialBlockstate = super.m_5573_(context);
        Direction direction = (Direction)potentialBlockstate.m_61143_((Property)FACING);
        if (context.m_43719_() == Direction.DOWN) {
            potentialBlockstate = (BlockState)((Block)BlockRegistration.HANGING_GYM_SIGNS.get(color.m_41065_().toLowerCase(Locale.ROOT)).get()).m_49966_().m_61124_((Property)FACING, (Comparable)direction);
        } else if (context.m_43719_() == Direction.UP) {
            potentialBlockstate = (BlockState)((Block)BlockRegistration.FLOOR_GYM_SIGNS.get(color.m_41065_().toLowerCase(Locale.ROOT)).get()).m_49966_().m_61124_((Property)FACING, (Comparable)direction);
        } else {
            direction = context.m_43719_();
            potentialBlockstate = (BlockState)((Block)BlockRegistration.WALL_GYM_SIGNS.get(color.m_41065_().toLowerCase(Locale.ROOT)).get()).m_49966_().m_61124_((Property)FACING, (Comparable)direction);
        }
        Level iworldreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockState chosenBlockstate = null;
        if (potentialBlockstate.m_60710_((LevelReader)iworldreader, blockpos)) {
            chosenBlockstate = potentialBlockstate;
        }
        return chosenBlockstate != null && iworldreader.m_45752_(chosenBlockstate, blockpos, CollisionContext.m_82749_()) ? chosenBlockstate : null;
    }

    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new GymSignTileEntity(this.gymSignType, blockPos, blockState);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (this.gymSignType == GymSignType.HANGING) {
            switch (direction) {
                default: {
                    return HANGING_SHAPE_NORTH;
                }
                case SOUTH: {
                    return HANGING_SHAPE_SOUTH;
                }
                case EAST: {
                    return HANGING_SHAPE_EAST;
                }
                case WEST: 
            }
            return HANGING_SHAPE_WEST;
        }
        if (this.gymSignType == GymSignType.WALL) {
            switch (direction) {
                default: {
                    return WALL_SHAPE_NORTH;
                }
                case SOUTH: {
                    return WALL_SHAPE_SOUTH;
                }
                case EAST: {
                    return WALL_SHAPE_EAST;
                }
                case WEST: 
            }
            return WALL_SHAPE_WEST;
        }
        return super.m_5940_(state, p_220053_2_, p_220053_3_, p_220053_4_);
    }

    @Override
    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (placer instanceof Player && !worldIn.f_46443_) {
            this.setOwner(pos, (Player)placer);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_() || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        GymSignTileEntity gymSign = BlockHelper.getTileEntity(GymSignTileEntity.class, (LevelReader)world, pos);
        if (gymSign == null) {
            return InteractionResult.SUCCESS;
        }
        if (!player.m_20148_().equals(gymSign.getOwnerUUID())) {
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.gymsign.ownership", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        Item playerItem = null;
        if (!heldItem.m_41619_()) {
            playerItem = heldItem.m_41720_();
        }
        boolean itemUsed = false;
        if (playerItem instanceof DyeItem) {
            String dyeName;
            DyeColor dyeColor = DyeColor.getColor((ItemStack)heldItem);
            String currentColour = gymSign.getColour();
            if (!currentColour.equals(dyeName = dyeColor.m_7912_())) {
                gymSign.setColour(dyeName);
                ((ServerLevel)world).m_7726_().m_8450_(pos);
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
                itemUsed = true;
            }
        }
        if (!itemUsed) {
            ItemStack signStack = gymSign.getItemInSign();
            ItemStack putting = null;
            if (!heldItem.m_41619_() && signStack != null && heldItem.m_41720_() == signStack.m_41720_()) {
                putting = null;
            }
            if (!heldItem.m_41619_()) {
                putting = heldItem.m_41777_();
                putting.m_41764_(1);
                if (!player.m_7500_()) {
                    heldItem.m_41620_(1);
                }
            }
            if (signStack != null && signStack != ItemStack.f_41583_ && !player.m_7500_()) {
                DropItemHelper.giveItemStack((ServerPlayer)player, signStack, false);
            }
            gymSign.setItemInSign(putting);
            ((ServerLevel)world).m_7726_().m_8450_(pos);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        GymSignTileEntity tile = BlockHelper.getTileEntity(GymSignTileEntity.class, (LevelReader)world, pos);
        if (!player.m_7500_()) {
            this.m_6786_((LevelAccessor)world, pos, world.m_8055_(pos));
            if (tile != null && tile.getItemInSign() != null && tile.isDroppable()) {
                Containers.m_19010_((Level)world, (BlockPos)pos, tile.getContents());
                tile.setItemInSign(null);
            }
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void m_6810_(BlockState newState, Level world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
        if (!newState.m_60713_(oldState.m_60734_())) {
            GymSignTileEntity tile = BlockHelper.getTileEntity(GymSignTileEntity.class, (LevelReader)world, pos);
            if (tile != null && tile.getItemInSign() != null && tile.isDroppable()) {
                Containers.m_19010_((Level)world, (BlockPos)pos, tile.getContents());
                tile.setItemInSign(null);
            }
            super.m_6810_(newState, world, pos, oldState, p_196243_5_);
        }
    }

    @Override
    public void setOwner(BlockPos pos, Player playerIn) {
        GymSignTileEntity gymSign = BlockHelper.getTileEntity(GymSignTileEntity.class, (LevelReader)playerIn.m_20193_(), pos);
        gymSign.setOwner(playerIn.m_20148_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState p_220080_1_, LevelReader p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState p_49928_, BlockGetter p_49929_, BlockPos p_49930_) {
        return true;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }

    public static Block getGymSignBlock(DyeColor dyeColor) {
        switch (dyeColor) {
            default: {
                return PixelmonBlocks.white_floor_gym_sign;
            }
            case BLACK: {
                return PixelmonBlocks.black_floor_gym_sign;
            }
            case RED: {
                return PixelmonBlocks.red_floor_gym_sign;
            }
            case GREEN: {
                return PixelmonBlocks.green_floor_gym_sign;
            }
            case BROWN: {
                return PixelmonBlocks.brown_floor_gym_sign;
            }
            case BLUE: {
                return PixelmonBlocks.blue_floor_gym_sign;
            }
            case PURPLE: {
                return PixelmonBlocks.purple_floor_gym_sign;
            }
            case CYAN: {
                return PixelmonBlocks.cyan_floor_gym_sign;
            }
            case LIGHT_GRAY: {
                return PixelmonBlocks.light_gray_floor_gym_sign;
            }
            case GRAY: {
                return PixelmonBlocks.gray_floor_gym_sign;
            }
            case PINK: {
                return PixelmonBlocks.pink_floor_gym_sign;
            }
            case LIME: {
                return PixelmonBlocks.lime_floor_gym_sign;
            }
            case YELLOW: {
                return PixelmonBlocks.yellow_floor_gym_sign;
            }
            case LIGHT_BLUE: {
                return PixelmonBlocks.light_blue_floor_gym_sign;
            }
            case MAGENTA: {
                return PixelmonBlocks.magenta_floor_gym_sign;
            }
            case ORANGE: 
        }
        return PixelmonBlocks.orange_floor_gym_sign;
    }
}

