/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.furniture;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.ClockTileEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClockBlock
extends GenericRotatableModelBlock {
    private static final AABB AABB_EAST = new AABB(0.0, 0.0, 0.0, 0.1, 1.0, 1.0);
    private static final AABB AABB_WEST = new AABB(0.9, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AABB AABB_SOUTH = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1);
    private static final AABB AABB_NORTH = new AABB(0.0, 0.0, 0.9, 1.0, 1.0, 1.0);
    private DyeColor color;

    public ClockBlock(DyeColor color) {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_60918_(SoundType.f_56743_).m_284180_(MapColor.f_283906_));
        this.color = color;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ClockTileEntity(pos, state);
    }

    @Override
    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5939_(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return Shapes.m_83064_((AABB)this.getBlockBounds(p_220071_1_));
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return Shapes.m_83064_((AABB)this.getBlockBounds(p_220053_1_));
    }

    private AABB getBlockBounds(BlockState blockState) {
        Direction enumfacing = (Direction)blockState.m_61143_((Property)FACING);
        switch (enumfacing) {
            case EAST: {
                return AABB_EAST;
            }
            case WEST: {
                return AABB_WEST;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
            case NORTH: {
                return AABB_NORTH;
            }
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (player.m_21120_(hand).m_41720_() instanceof DyeItem) {
            DyeColor dyeColor = DyeColor.getColor((ItemStack)heldItem);
            if (dyeColor == null) {
                return InteractionResult.PASS;
            }
            BlockState clockBlockState = ClockBlock.getClockBlock(dyeColor).m_49966_();
            if ((clockBlockState = (BlockState)clockBlockState.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))) != state) {
                world.m_46597_(pos, clockBlockState);
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos = ctx.m_8083_().m_121955_(ctx.m_43719_().m_122424_().m_122436_());
        BlockState state = ctx.m_43725_().m_8055_(pos);
        boolean sturdy = state.m_60783_((BlockGetter)ctx.m_43725_(), pos, ctx.m_43719_()) && state.m_60734_().m_7514_(state) != RenderShape.INVISIBLE;
        return !sturdy || ctx.m_43719_().m_122434_() == Direction.Axis.Y ? null : super.m_5573_(ctx);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public static Block getClockBlock(DyeColor dyeColor) {
        switch (dyeColor) {
            default: {
                return PixelmonBlocks.white_clock;
            }
            case BLACK: {
                return PixelmonBlocks.black_clock;
            }
            case RED: {
                return PixelmonBlocks.red_clock;
            }
            case GREEN: {
                return PixelmonBlocks.green_clock;
            }
            case BROWN: {
                return PixelmonBlocks.brown_clock;
            }
            case BLUE: {
                return PixelmonBlocks.blue_clock;
            }
            case PURPLE: {
                return PixelmonBlocks.purple_clock;
            }
            case CYAN: {
                return PixelmonBlocks.cyan_clock;
            }
            case LIGHT_GRAY: {
                return PixelmonBlocks.light_gray_clock;
            }
            case GRAY: {
                return PixelmonBlocks.gray_clock;
            }
            case PINK: {
                return PixelmonBlocks.pink_clock;
            }
            case LIME: {
                return PixelmonBlocks.lime_clock;
            }
            case YELLOW: {
                return PixelmonBlocks.yellow_clock;
            }
            case LIGHT_BLUE: {
                return PixelmonBlocks.light_blue_clock;
            }
            case MAGENTA: {
                return PixelmonBlocks.magenta_clock;
            }
            case ORANGE: 
        }
        return PixelmonBlocks.orange_clock;
    }
}

