/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.furniture;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableSittableModelBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ArmchairBlock
extends GenericRotatableSittableModelBlock {
    private static final AABB AABB = new AABB((double)0.1f, 0.0, (double)0.1f, (double)0.9f, (double)0.55f, (double)0.9f);
    private DyeColor color;

    public ArmchairBlock(DyeColor color) {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283930_));
        this.color = color;
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83064_((AABB)AABB);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_41720_() instanceof DyeItem) {
            DyeColor dyeColor = DyeColor.getColor((ItemStack)player.m_21120_(hand));
            if (dyeColor == null) {
                return InteractionResult.PASS;
            }
            BlockState armchairBlockState = ArmchairBlock.getArmchairBlock(dyeColor).m_49966_();
            if ((armchairBlockState = (BlockState)armchairBlockState.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))) != state) {
                world.m_46597_(pos, armchairBlockState);
                player.m_21120_(hand).m_41764_(player.m_21120_(hand).m_41613_() - 1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public float getSittingHeight() {
        return 0.6f;
    }

    public static Block getArmchairBlock(DyeColor dyeColor) {
        switch (dyeColor) {
            default: {
                return PixelmonBlocks.white_armchair;
            }
            case BLACK: {
                return PixelmonBlocks.black_armchair;
            }
            case RED: {
                return PixelmonBlocks.red_armchair;
            }
            case GREEN: {
                return PixelmonBlocks.green_armchair;
            }
            case BROWN: {
                return PixelmonBlocks.brown_armchair;
            }
            case BLUE: {
                return PixelmonBlocks.blue_armchair;
            }
            case PURPLE: {
                return PixelmonBlocks.purple_armchair;
            }
            case CYAN: {
                return PixelmonBlocks.cyan_armchair;
            }
            case LIGHT_GRAY: {
                return PixelmonBlocks.light_gray_armchair;
            }
            case GRAY: {
                return PixelmonBlocks.gray_armchair;
            }
            case PINK: {
                return PixelmonBlocks.pink_armchair;
            }
            case LIME: {
                return PixelmonBlocks.lime_armchair;
            }
            case YELLOW: {
                return PixelmonBlocks.yellow_armchair;
            }
            case LIGHT_BLUE: {
                return PixelmonBlocks.light_blue_armchair;
            }
            case MAGENTA: {
                return PixelmonBlocks.magenta_armchair;
            }
            case ORANGE: 
        }
        return PixelmonBlocks.orange_armchair;
    }
}

