/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.enums;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.world.item.DyeColor;

public enum ColorEnum {
    BLUE(11),
    RED(14),
    GREEN(13),
    ORANGE(1),
    PINK(6),
    PURPLE(10),
    YELLOW(4),
    WHITE(0, 2, 3, 5, 8),
    BROWN(12),
    BLACK(15),
    GRAY(7),
    CYAN(9);

    private static final Map<Integer, ColorEnum> FROM_DYE;
    private final int[] dyeColourIndex;

    private ColorEnum(int ... dyeColourIndex) {
        this.dyeColourIndex = dyeColourIndex;
    }

    public static ColorEnum fromDye(DyeColor dyeColor) {
        return FROM_DYE.getOrDefault(dyeColor.m_41060_(), WHITE);
    }

    static {
        FROM_DYE = Maps.newHashMap();
        for (ColorEnum value : ColorEnum.values()) {
            for (int dyeColourIndex : value.dyeColourIndex) {
                FROM_DYE.put(dyeColourIndex, value);
            }
        }
    }
}

