/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.decorative;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeDisplayTileEntity;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.PokeDisplayOpenPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class PokeDisplayBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty UPSIDE_DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty RETURN = BooleanProperty.m_61465_((String)"return");

    public PokeDisplayBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56744_).m_60978_(2.0f).m_60971_((p_test_1_, p_test_2_, p_test_3_) -> false).m_60955_().m_284180_(MapColor.f_283808_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)RETURN, (Comparable)Boolean.valueOf(true)));
    }

    public FluidState m_5888_(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_204507_1_);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_8055_(context.m_8083_()).m_60819_().m_76170_()))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(context.m_43719_().m_122430_() == -1))).m_61124_((Property)RETURN, (Comparable)Boolean.valueOf(true));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.m_7926_(p_206840_1_);
        p_206840_1_.m_61104_(new Property[]{WATERLOGGED, FACING, UPSIDE_DOWN, RETURN});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new PokeDisplayTileEntity(p_153215_, p_153216_);
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.INVISIBLE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult traceResult) {
        if (world.f_46443_ || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        PokeDisplayTileEntity blockEntity = (PokeDisplayTileEntity)world.m_7702_(pos);
        if (blockEntity.isLocked()) {
            return InteractionResult.PASS;
        }
        PlayerPartyStorage party = StorageProxy.getPartyNow((ServerPlayer)player);
        if (party == null || party.countAblePokemon() < 2 && !blockEntity.getStoredPoke().isPresent()) {
            player.m_213846_((Component)Component.m_237115_((String)"poke.display.block.party.size"));
            return InteractionResult.PASS;
        }
        blockEntity.setLocked(player);
        NetworkHelper.sendPacket((ServerPlayer)player, new PokeDisplayOpenPacket(pos));
        return InteractionResult.SUCCESS;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (world.f_46443_) {
            return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof PokeDisplayTileEntity) {
            if (!((Boolean)state.m_61143_((Property)RETURN)).booleanValue()) {
                return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
            PlayerPartyStorage party = StorageProxy.getPartyNow((ServerPlayer)player);
            PokeDisplayTileEntity pokeDisplayTileEntity = (PokeDisplayTileEntity)blockEntity;
            if (pokeDisplayTileEntity.getStoredPoke().isPresent()) {
                Pokemon storedPoke = pokeDisplayTileEntity.getStoredPoke().get();
                if (pokeDisplayTileEntity.getOriginalForm() != null) {
                    storedPoke.setForm(pokeDisplayTileEntity.getOriginalForm());
                }
                if (pokeDisplayTileEntity.getOriginalPalette() != null) {
                    storedPoke.setPalette(pokeDisplayTileEntity.getOriginalPalette());
                }
                party.add(storedPoke);
            }
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }
}

