/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.decorative;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.blocks.decorative.LetterBoxBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MailBoxBlock
extends LetterBoxBlock {
    private static final AABB NORTH_AABB = new AABB(0.2, 0.0, 0.1, 0.75, 0.5, 0.95);
    private static final AABB SOUTH_AABB = new AABB(0.25, 0.0, 0.05, 0.8, 0.5, 0.9);
    private static final AABB EAST_AABB = new AABB(0.05, 0.0, 0.2, 0.9, 0.5, 0.75);
    private static final AABB WEST_AABB = new AABB(0.1, 0.0, 0.25, 0.95, 0.5, 0.8);

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult HitResult2) {
        if (world.m_5776_() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (player.m_21120_(hand).m_41720_() instanceof DyeItem) {
            DyeColor dyeColor = DyeColor.getColor((ItemStack)heldItem);
            if (dyeColor == null) {
                return InteractionResult.PASS;
            }
            Block mailBoxBlock = MailBoxBlock.getMailBoxBlock(dyeColor);
            BlockState st = mailBoxBlock.m_49966_();
            if ((st = (BlockState)st.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))) != state) {
                world.m_46597_(pos, st);
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public static Block getMailBoxBlock(DyeColor dyeColor) {
        switch (dyeColor) {
            default: {
                return PixelmonBlocks.white_mail_box;
            }
            case BLACK: {
                return PixelmonBlocks.black_mail_box;
            }
            case RED: {
                return PixelmonBlocks.red_mail_box;
            }
            case GREEN: {
                return PixelmonBlocks.green_mail_box;
            }
            case BROWN: {
                return PixelmonBlocks.brown_mail_box;
            }
            case BLUE: {
                return PixelmonBlocks.blue_mail_box;
            }
            case PURPLE: {
                return PixelmonBlocks.purple_mail_box;
            }
            case CYAN: {
                return PixelmonBlocks.cyan_mail_box;
            }
            case LIGHT_GRAY: {
                return PixelmonBlocks.light_gray_mail_box;
            }
            case GRAY: {
                return PixelmonBlocks.gray_mail_box;
            }
            case PINK: {
                return PixelmonBlocks.pink_mail_box;
            }
            case LIME: {
                return PixelmonBlocks.lime_mail_box;
            }
            case YELLOW: {
                return PixelmonBlocks.yellow_mail_box;
            }
            case LIGHT_BLUE: {
                return PixelmonBlocks.light_blue_mail_box;
            }
            case MAGENTA: {
                return PixelmonBlocks.magenta_mail_box;
            }
            case ORANGE: 
        }
        return PixelmonBlocks.orange_mail_box;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> Shapes.m_83064_((AABB)SOUTH_AABB);
            case Direction.EAST -> Shapes.m_83064_((AABB)EAST_AABB);
            case Direction.WEST -> Shapes.m_83064_((AABB)WEST_AABB);
            default -> Shapes.m_83064_((AABB)NORTH_AABB);
        };
    }
}

