/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.daycare;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.client.gui.daycare.DayCareContainer;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DayCareBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty EGG_PRESENT = BooleanProperty.m_61465_((String)"egg");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);

    public DayCareBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60978_(2.5f).m_60977_().m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283927_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)EGG_PRESENT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public FluidState m_5888_(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_204507_1_);
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_().m_7494_());
        if (!blockState.m_60629_(context)) {
            return null;
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)EGG_PRESENT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_8055_(context.m_8083_()).m_60819_().m_76170_()));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.m_7926_(p_206840_1_);
        p_206840_1_.m_61104_(new Property[]{EGG_PRESENT, WATERLOGGED, FACING});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!(player instanceof ServerPlayer) || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        if (!PixelmonConfigProxy.getBreeding().isAllowBreeding()) {
            ChatHandler.sendChat((Entity)player, "pixelmon.general.disabledblock", new Object[0]);
            return InteractionResult.FAIL;
        }
        PlayerPartyStorage party = StorageProxy.getPartyNow((ServerPlayer)player);
        party.retrieveAll("BlockInteract");
        SimpleMenuProvider containerProvider = new SimpleMenuProvider((a, b, c) -> new DayCareContainer(a, player.m_150109_()), (Component)Component.m_237119_());
        player.m_5893_((MenuProvider)containerProvider);
        return InteractionResult.SUCCESS;
    }

    public BlockState m_6843_(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.m_61124_((Property)FACING, (Comparable)p_185499_2_.m_55954_((Direction)p_185499_1_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    public static Block getDayCareBlock(DyeColor dyeColor) {
        switch (dyeColor) {
            default: {
                return PixelmonBlocks.white_day_care;
            }
            case BLACK: {
                return PixelmonBlocks.black_day_care;
            }
            case RED: {
                return PixelmonBlocks.red_day_care;
            }
            case GREEN: {
                return PixelmonBlocks.green_day_care;
            }
            case BROWN: {
                return PixelmonBlocks.brown_day_care;
            }
            case BLUE: {
                return PixelmonBlocks.blue_day_care;
            }
            case PURPLE: {
                return PixelmonBlocks.purple_day_care;
            }
            case CYAN: {
                return PixelmonBlocks.cyan_day_care;
            }
            case LIGHT_GRAY: {
                return PixelmonBlocks.light_gray_day_care;
            }
            case GRAY: {
                return PixelmonBlocks.gray_day_care;
            }
            case PINK: {
                return PixelmonBlocks.pink_day_care;
            }
            case LIME: {
                return PixelmonBlocks.lime_day_care;
            }
            case YELLOW: {
                return PixelmonBlocks.yellow_day_care;
            }
            case LIGHT_BLUE: {
                return PixelmonBlocks.light_blue_day_care;
            }
            case MAGENTA: {
                return PixelmonBlocks.magenta_day_care;
            }
            case ORANGE: 
        }
        return PixelmonBlocks.orange_day_care;
    }
}

