/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.blocks.TumblestoneBlockEvent;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.items.HammerItem;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.eventbus.api.Event;

public class TumblestoneBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61408_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty DESTROYED = IntegerProperty.m_61631_((String)"destroyed", (int)0, (int)3);

    public TumblestoneBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56744_).m_60977_().m_60999_().m_60913_(5.0f, 1000.0f).m_60988_().m_60955_().m_60953_(value -> {
            if (!value.m_61138_((Property)AGE)) {
                return 0;
            }
            if ((Integer)value.m_61143_((Property)DESTROYED) > 0) {
                return 3;
            }
            return 3 * (Integer)value.m_61143_((Property)AGE);
        }).m_60991_((p_test_1_, p_test_2_, p_test_3_) -> true).m_284180_(MapColor.f_283927_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DESTROYED, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack m_7397_(BlockGetter p_49823_, BlockPos p_49824_, BlockState p_49825_) {
        return new ItemStack((ItemLike)PixelmonItems.tumblestone);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE, WATERLOGGED, DESTROYED});
    }

    public FluidState m_5888_(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_204507_1_);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_8055_(context.m_8083_()).m_60819_().m_76170_()));
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        int destroyedState = (Integer)state.m_61143_((Property)DESTROYED);
        if (destroyedState == 3) {
            TumblestoneBlockEvent.PreCooldownEnd cooldownPreEvent = new TumblestoneBlockEvent.PreCooldownEnd((Level)level, state, pos, PixelmonConfigProxy.getDimensions().getTumblestoneRestoreChance());
            if (Pixelmon.EVENT_BUS.post((Event)cooldownPreEvent)) {
                return;
            }
            boolean success = false;
            if (RandomHelper.getRandomChance(cooldownPreEvent.getChance())) {
                state = this.m_49966_();
                level.m_7731_(pos, state, 2);
                success = true;
            }
            Pixelmon.EVENT_BUS.post((Event)new TumblestoneBlockEvent.PostCooldownEnd((Level)level, state, pos, success, cooldownPreEvent.getChance()));
            return;
        }
        int i = (Integer)state.m_61143_((Property)AGE);
        float chance = PixelmonConfigProxy.getDimensions().getTumblestoneGrowthChance();
        TumblestoneBlockEvent.PreGrow growthEvent = new TumblestoneBlockEvent.PreGrow((Level)level, state, pos, chance);
        if (Pixelmon.EVENT_BUS.post((Event)growthEvent)) {
            return;
        }
        if (i < 5 && RandomHelper.getRandomChance(growthEvent.getChance())) {
            state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.m_7731_(pos, state, 2);
            Pixelmon.EVENT_BUS.post((Event)new TumblestoneBlockEvent.PostGrow((Level)level, state, pos, growthEvent.getChance()));
        }
        super.m_213898_(state, level, pos, rand);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (player.m_7500_()) {
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        if (level.f_46443_) {
            return false;
        }
        ItemStack itemInHand = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!(itemInHand.m_41720_() instanceof HammerItem)) {
            return false;
        }
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 5) {
            return false;
        }
        int destroyed = (Integer)state.m_61143_((Property)DESTROYED);
        if (destroyed == 3) {
            return false;
        }
        TumblestoneBlockEvent.PreBlockDestroy destroyEvent = new TumblestoneBlockEvent.PreBlockDestroy(level, state, pos, player, itemInHand);
        if (Pixelmon.EVENT_BUS.post((Event)destroyEvent)) {
            return false;
        }
        ++destroyed;
        if (Objects.equals(itemInHand.m_41720_(), PixelmonItems.beef_hammer)) {
            destroyed = 3;
        }
        if (destroyed > 3) {
            destroyed = 3;
        }
        state = (BlockState)state.m_61124_((Property)DESTROYED, (Comparable)Integer.valueOf(destroyed));
        level.m_7731_(pos, state, 2);
        level.m_7260_(pos, state, state, 11);
        level.m_5518_().m_7174_(pos);
        if (destroyed == 3) {
            LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)itemInHand);
            List drops = this.m_49635_(state, lootcontext$builder);
            TumblestoneBlockEvent.PreBlockBroke breakEvent = new TumblestoneBlockEvent.PreBlockBroke(level, state, pos, player, itemInHand, drops);
            if (Pixelmon.EVENT_BUS.post((Event)breakEvent)) {
                return false;
            }
            level.m_7731_(pos, state, 2);
            for (ItemStack drop : breakEvent.getDrops()) {
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), drop);
                breakEvent.getWorld().m_7967_((Entity)itemEntity);
            }
            Pixelmon.EVENT_BUS.post((Event)new TumblestoneBlockEvent.PostBlockBroke(level, state, pos, player, itemInHand, breakEvent.getDrops()));
        }
        Pixelmon.EVENT_BUS.post((Event)new TumblestoneBlockEvent.PostBlockDestroy(level, state, pos, player, itemInHand));
        return false;
    }

    public float m_5880_(BlockState state, Player p_180647_2_, BlockGetter p_180647_3_, BlockPos p_180647_4_) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 5 || (Integer)state.m_61143_((Property)DESTROYED) >= 3) {
            return 0.0f;
        }
        ItemStack itemInHand = p_180647_2_.m_21120_(InteractionHand.MAIN_HAND);
        if (Objects.equals(itemInHand.m_41720_(), PixelmonItems.beef_hammer)) {
            return 0.9f;
        }
        return super.m_5880_(state, p_180647_2_, p_180647_3_, p_180647_4_);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        if ((Integer)state.m_61143_((Property)AGE) > 3 && (Integer)state.m_61143_((Property)DESTROYED) < 3) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)2.0, (double)1.0);
        }
        return Shapes.m_83144_();
    }
}

