/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class TemplePillarBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final EnumProperty<State> NORTH = EnumProperty.m_61587_((String)"north", State.class);
    public static final EnumProperty<State> EAST = EnumProperty.m_61587_((String)"east", State.class);
    public static final EnumProperty<State> SOUTH = EnumProperty.m_61587_((String)"south", State.class);
    public static final EnumProperty<State> WEST = EnumProperty.m_61587_((String)"west", State.class);
    public static final EnumProperty<State> UP = EnumProperty.m_61587_((String)"up", State.class);
    public static final EnumProperty<State> DOWN = EnumProperty.m_61587_((String)"down", State.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public TemplePillarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(NORTH, (Comparable)((Object)State.AIR))).m_61124_(EAST, (Comparable)((Object)State.AIR))).m_61124_(SOUTH, (Comparable)((Object)State.AIR))).m_61124_(WEST, (Comparable)((Object)State.AIR))).m_61124_(UP, (Comparable)((Object)State.AIR))).m_61124_(DOWN, (Comparable)((Object)State.AIR))).m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public FluidState m_5888_(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_204507_1_);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.calculate((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)context.m_43719_().m_122434_()), (LevelAccessor)context.m_43725_(), context.m_8083_(), context.m_43719_());
    }

    private BlockState calculate(BlockState state, LevelAccessor level, BlockPos pos, Direction clickedFace) {
        EnumProperty<State> backwardProperty;
        EnumProperty<State> forwardProperty;
        if (clickedFace.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL) {
            if (clickedFace.m_122434_() == Direction.Axis.X) {
                if (clickedFace == Direction.EAST) {
                    forwardProperty = EAST;
                    backwardProperty = WEST;
                } else {
                    forwardProperty = WEST;
                    backwardProperty = EAST;
                }
            } else if (clickedFace == Direction.NORTH) {
                forwardProperty = NORTH;
                backwardProperty = SOUTH;
            } else {
                forwardProperty = SOUTH;
                backwardProperty = NORTH;
            }
        } else if (clickedFace == Direction.UP) {
            forwardProperty = UP;
            backwardProperty = DOWN;
        } else {
            forwardProperty = DOWN;
            backwardProperty = UP;
        }
        BlockPos forward = pos.m_5487_(clickedFace.m_122434_(), clickedFace.m_122436_().m_123304_(clickedFace.m_122434_()));
        BlockPos backward = pos.m_5487_(clickedFace.m_122434_(), -clickedFace.m_122436_().m_123304_(clickedFace.m_122434_()));
        BlockState forwardState = level.m_8055_(forward);
        BlockState backwardState = level.m_8055_(backward);
        state = (BlockState)((BlockState)state.m_61124_(forwardProperty, (Comparable)((Object)this.calcTempleState(level, clickedFace, forward, forwardState)))).m_61124_(backwardProperty, (Comparable)((Object)this.calcTempleState(level, clickedFace.m_122424_(), backward, backwardState)));
        if (level.m_8055_(pos).m_60819_().m_76170_()) {
            state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private State calcTempleState(LevelAccessor level, Direction direction, BlockPos pos, BlockState state) {
        if (state.m_60713_(Blocks.f_50016_)) {
            return State.AIR;
        }
        if (state.m_60713_((Block)PixelmonBlocks.temple_pillar) || state.m_60713_((Block)PixelmonBlocks.temple_pillar_fractured)) {
            return State.PILLAR;
        }
        if (state.m_60783_((BlockGetter)level, pos, direction.m_122424_())) {
            return State.SOLID;
        }
        return State.AIR;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.m_7926_(p_206840_1_);
        p_206840_1_.m_61104_(new Property[]{AXIS, NORTH, EAST, SOUTH, WEST, UP, DOWN, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState state, Rotation direction) {
        return this.rotate(state, null, null, direction);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        block0 : switch (direction) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case X: {
                        state = (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                        break block0;
                    }
                    case Z: {
                        state = (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
            }
        }
        State oldNorth = (State)((Object)state.m_61143_(NORTH));
        switch (direction) {
            case COUNTERCLOCKWISE_90: {
                state = (BlockState)state.m_61124_(NORTH, (Comparable)((Object)((State)((Object)state.m_61143_(EAST)))));
                state = (BlockState)state.m_61124_(EAST, (Comparable)((Object)((State)((Object)state.m_61143_(SOUTH)))));
                state = (BlockState)state.m_61124_(SOUTH, (Comparable)((Object)((State)((Object)state.m_61143_(WEST)))));
                state = (BlockState)state.m_61124_(WEST, (Comparable)((Object)oldNorth));
                break;
            }
            case CLOCKWISE_90: {
                state = (BlockState)state.m_61124_(NORTH, (Comparable)((Object)((State)((Object)state.m_61143_(WEST)))));
                state = (BlockState)state.m_61124_(WEST, (Comparable)((Object)((State)((Object)state.m_61143_(SOUTH)))));
                state = (BlockState)state.m_61124_(SOUTH, (Comparable)((Object)((State)((Object)state.m_61143_(EAST)))));
                state = (BlockState)state.m_61124_(EAST, (Comparable)((Object)oldNorth));
                break;
            }
            case CLOCKWISE_180: {
                state = (BlockState)state.m_61124_(NORTH, (Comparable)((Object)((State)((Object)state.m_61143_(SOUTH)))));
                state = (BlockState)state.m_61124_(SOUTH, (Comparable)((Object)oldNorth));
                State oldWest = (State)((Object)state.m_61143_(WEST));
                state = (BlockState)state.m_61124_(WEST, (Comparable)((Object)((State)((Object)state.m_61143_(EAST)))));
                state = (BlockState)state.m_61124_(EAST, (Comparable)((Object)oldWest));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorType) {
        switch (mirrorType) {
            case FRONT_BACK: {
                State oldWest = (State)((Object)state.m_61143_(WEST));
                state = (BlockState)state.m_61124_(WEST, (Comparable)((Object)((State)((Object)state.m_61143_(EAST)))));
                state = (BlockState)state.m_61124_(EAST, (Comparable)((Object)oldWest));
                break;
            }
            case LEFT_RIGHT: {
                State oldNorth = (State)((Object)state.m_61143_(NORTH));
                state = (BlockState)state.m_61124_(NORTH, (Comparable)((Object)((State)((Object)state.m_61143_(SOUTH)))));
                state = (BlockState)state.m_61124_(SOUTH, (Comparable)((Object)oldNorth));
            }
        }
        return state;
    }

    public static enum State implements StringRepresentable
    {
        SOLID,
        AIR,
        PILLAR;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

