/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.blocks.tileentity.ScrollTileEntity;
import com.pixelmonmod.pixelmon.init.registry.BlockRegistration;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ScrollBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)15);
    protected static final VoxelShape STANDING_AABB = Shapes.m_83064_((AABB)new AABB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75));

    public ScrollBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283825_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, ROTATION});
    }

    public VoxelShape m_5939_(BlockState p_60572_, BlockGetter p_60573_, BlockPos p_60574_, CollisionContext p_60575_) {
        return Shapes.m_83040_();
    }

    public boolean isFullCube(BlockState state) {
        return false;
    }

    public boolean isPassable(LevelAccessor worldIn, BlockPos pos) {
        return true;
    }

    public boolean isPossibleToRespawnInThis() {
        return true;
    }

    private ItemStack getTileDataItemStack(Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        return te instanceof ScrollTileEntity ? ((ScrollTileEntity)te).getItem() : ItemStack.f_41583_;
    }

    public ItemStack getItem(Level worldIn, BlockPos pos, BlockState state) {
        ItemStack itemstack = this.getTileDataItemStack(worldIn, pos);
        return itemstack.m_41619_() ? new ItemStack((ItemLike)Items.f_42728_) : itemstack;
    }

    public boolean canPlaceBlockAt(Level worldIn, BlockPos pos) {
        return !this.hasInvalidNeighbor(worldIn, pos);
    }

    protected boolean isInvalidNeighbor(Level worldIn, BlockPos pos, Direction facing) {
        return worldIn.m_8055_(pos.m_121945_(facing)).m_60734_() instanceof ScrollBlock;
    }

    protected boolean hasInvalidNeighbor(Level worldIn, BlockPos pos) {
        return this.isInvalidNeighbor(worldIn, pos, Direction.NORTH) || this.isInvalidNeighbor(worldIn, pos, Direction.SOUTH) || this.isInvalidNeighbor(worldIn, pos, Direction.WEST) || this.isInvalidNeighbor(worldIn, pos, Direction.EAST);
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        if (!worldIn.f_46443_) {
            if (te instanceof ScrollTileEntity) {
                ScrollTileEntity scroll = (ScrollTileEntity)te;
                scroll.m_7651_();
                ScrollBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)scroll.getItem());
            } else {
                super.m_6240_(worldIn, player, pos, state, null, stack);
            }
        } else {
            super.m_6240_(worldIn, player, pos, state, null, stack);
        }
    }

    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        BlockEntity te = blockGetter.m_7702_(blockPos);
        if (te instanceof ScrollTileEntity) {
            ScrollTileEntity scroll = (ScrollTileEntity)te;
            return scroll.getItem();
        }
        return ItemStack.f_41583_;
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ScrollTileEntity(blockPos, blockState, Type.WATERS);
    }

    public static enum Type implements ITranslatable
    {
        WATERS("scroll_of_waters", "pixelmon:textures/entity/scroll/scroll_of_waters.png"),
        DARKNESS("scroll_of_darkness", "pixelmon:textures/entity/scroll/scroll_of_darkness.png");

        private final String name;
        private final String defaultResource;

        private Type(String name, String defaultResource) {
            this.name = name;
            this.defaultResource = defaultResource;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultResource() {
            return this.defaultResource;
        }

        @Override
        public String getTranslationKey() {
            return "block.pixelmon." + this.getName();
        }

        @Override
        public String getLocalizedName() {
            return Component.m_237115_((String)this.getTranslationKey()).getString();
        }
    }

    public static class ScrollBlockStanding
    extends ScrollBlock {
        public ScrollBlockStanding() {
            this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0));
        }

        public VoxelShape getShape(BlockState state, LevelReader reader, BlockPos pos, CollisionContext ctx) {
            return STANDING_AABB;
        }

        public BlockState m_6843_(BlockState state, Rotation rot) {
            return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rot.m_55949_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 16)));
        }

        public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
            return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(mirrorIn.m_54843_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 16)));
        }

        public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
            if (!worldIn.m_8055_(pos.m_7495_()).m_280296_()) {
                worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)this.m_5456_())));
                worldIn.m_7471_(pos, false);
            }
            super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        }
    }

    public static class ScrollBlockHanging
    extends ScrollBlock {
        protected static final VoxelShape NORTH_AABB = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0));
        protected static final VoxelShape SOUTH_AABB = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125));
        protected static final VoxelShape WEST_AABB = Shapes.m_83064_((AABB)new AABB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0));
        protected static final VoxelShape EAST_AABB = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0));

        public ScrollBlockHanging() {
            this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
        }

        public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
            Direction direction = (Direction)blockState.m_61143_((Property)FACING);
            switch (direction) {
                default: {
                    return NORTH_AABB;
                }
                case SOUTH: {
                    return SOUTH_AABB;
                }
                case WEST: {
                    return WEST_AABB;
                }
                case EAST: 
            }
            return EAST_AABB;
        }

        public BlockState m_6843_(BlockState state, Rotation rot) {
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
        }

        public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirrorIn.m_54848_((Direction)state.m_61143_((Property)FACING)));
        }

        public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
            Direction enumfacing = (Direction)state.m_61143_((Property)FACING);
            if (!worldIn.m_8055_(pos.m_121945_(enumfacing.m_122424_())).m_280296_()) {
                worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)BlockRegistration.getItemFromBlock((Block)this))));
                worldIn.m_7471_(pos, false);
            }
            super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        }
    }
}

