/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.block.EggBlockEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PokemonEggBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final IntegerProperty EGG = IntegerProperty.m_61631_((String)"eggs", (int)1, (int)3);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape ONE_EGG_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)12.0);
    private static final VoxelShape MULTIPLE_EGGS_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);

    public PokemonEggBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(0.1f).m_284180_(MapColor.f_283942_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)EGG, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{EGG, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        return blockstate.m_60713_((Block)this) ? (BlockState)blockstate.m_61124_((Property)EGG, (Comparable)Integer.valueOf(Math.min(3, (Integer)blockstate.m_61143_((Property)EGG) + 1))) : super.m_5573_(context);
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return (Integer)p_220053_1_.m_61143_((Property)EGG) > 1 ? MULTIPLE_EGGS_AABB : ONE_EGG_AABB;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return context.m_43722_().m_41720_() == this.m_5456_() && (Integer)state.m_61143_((Property)EGG) < 3 || super.m_6864_(state, context);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.decreaseEggs(level, pos, level.m_8055_(pos));
        this.sendPlayerFlying(pos, (Entity)player);
        this.spawnBoss(level, state, pos, player);
        return false;
    }

    public void m_142072_(Level level, BlockState blockState, BlockPos blockPos, Entity entity, float p_152430_) {
        super.m_142072_(level, blockState, blockPos, entity, p_152430_);
        if (!(entity instanceof Player)) {
            return;
        }
        this.decreaseEggs(level, blockPos, level.m_8055_(blockPos));
        if (!level.m_5776_()) {
            this.sendPlayerFlying(blockPos, entity);
            ServerLifecycleHooks.getCurrentServer().execute(() -> this.spawnBoss(level, blockState, blockPos, (Player)entity));
        }
    }

    public void m_141947_(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        this.decreaseEggs(level, blockPos, level.m_8055_(blockPos));
        if (!level.m_5776_()) {
            this.sendPlayerFlying(blockPos, entity);
            ServerLifecycleHooks.getCurrentServer().execute(() -> this.spawnBoss(level, blockState, blockPos, (Player)entity));
        }
    }

    private void decreaseEggs(Level world, BlockPos pos, BlockState state) {
        if (!state.m_61138_((Property)EGG)) {
            return;
        }
        world.m_5594_(null, pos, SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + RandomHelper.getRandom().nextFloat() * 0.2f);
        int i = (Integer)state.m_61143_((Property)EGG);
        if (i <= 1) {
            world.m_46961_(pos, false);
        } else {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)EGG, (Comparable)Integer.valueOf(i - 1)), 2);
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
    }

    private void spawnBoss(Level level, BlockState blockState, BlockPos pos, Player player) {
        if (level.m_5776_() || player.m_7500_()) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getPartyNow((ServerPlayer)player);
        if (party.getFirstBattleReadyPokemon() == null) {
            return;
        }
        Species species = this.getSpecies((Holder<Biome>)level.m_204166_(pos));
        EggBlockEvent.SelectSpecies.Pre pre = new EggBlockEvent.SelectSpecies.Pre(level, pos, level.m_8055_(pos), species);
        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
            Pixelmon.EVENT_BUS.post((Event)new EggBlockEvent.SelectSpecies.Post(level, pos, pre.getState(), pre.getSpecies()));
            return;
        }
        Pixelmon.EVENT_BUS.post((Event)new EggBlockEvent.SelectSpecies.Post(level, pos, pre.getState(), pre.getSpecies()));
        if (species == null) {
            return;
        }
        Pokemon pokemon = PokemonBuilder.builder().species(pre.getSpecies()).level(100).build();
        PixelmonEntity pixelmon = new PixelmonEntity(level, pokemon);
        pixelmon.setBossTier(BossTierRegistry.getBossTierUnsafe("epic"));
        pixelmon.m_21530_();
        pixelmon.m_6034_(pos.m_7494_().m_123341_(), pos.m_7494_().m_123342_(), pos.m_7494_().m_123343_());
        EggBlockEvent.BeginFight.Pre preFight = new EggBlockEvent.BeginFight.Pre(level, pos, level.m_8055_(pos), pixelmon);
        if (Pixelmon.EVENT_BUS.post((Event)preFight)) {
            return;
        }
        level.m_7967_((Entity)preFight.getEntity());
        Pokemon firstBattleReadyPokemon = party.getFirstBattleReadyPokemon();
        firstBattleReadyPokemon.getOrSpawnPixelmon((Entity)player);
        preFight.getEntity().startBattle(new WildPixelmonParticipant(preFight.getEntity()), new PlayerParticipant((ServerPlayer)player, firstBattleReadyPokemon));
        Pixelmon.EVENT_BUS.post((Event)new EggBlockEvent.BeginFight.Post(level, pos, preFight.getState(), preFight.getEntity()));
    }

    @Nullable
    private Species getSpecies(Holder<Biome> biome) {
        ResourceKey biomeResourceKey = biome.m_203543_().orElse(null);
        if (biomeResourceKey == null) {
            return null;
        }
        String biomeName = biomeResourceKey.m_135782_().m_135815_();
        if (biomeName.equalsIgnoreCase("ultra_crater")) {
            return PixelmonSpecies.CELESTEELA.orElse(PixelmonSpecies.BULBASAUR);
        }
        if (biomeName.equalsIgnoreCase("ultra_plant")) {
            return PixelmonSpecies.XURKITREE.orElse(PixelmonSpecies.BULBASAUR);
        }
        if (biomeName.equalsIgnoreCase("ultra_jungle")) {
            return PixelmonSpecies.BUZZWOLE.orElse(PixelmonSpecies.BULBASAUR);
        }
        if (biomeName.equalsIgnoreCase("ultra_desert")) {
            return PixelmonSpecies.PHEROMOSA.orElse(PixelmonSpecies.BULBASAUR);
        }
        if (biomeName.equalsIgnoreCase("ultra_forest")) {
            return PixelmonSpecies.KARTANA.orElse(PixelmonSpecies.BULBASAUR);
        }
        if (biomeName.equalsIgnoreCase("ultra_deep_sea")) {
            return PixelmonSpecies.NIHILEGO.orElse(PixelmonSpecies.BULBASAUR);
        }
        return null;
    }

    private void sendPlayerFlying(BlockPos blockPos, Entity entity) {
        Vec3 movementVector = entity.m_20182_().m_82546_(new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5));
        movementVector = movementVector.m_82541_();
        Vec3 extraVerticalMovementVector = new Vec3(movementVector.m_7096_(), Math.max(movementVector.m_7098_(), 0.3), movementVector.m_7094_());
        entity.m_19920_(2.0f, extraVerticalMovementVector);
    }
}

