/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.drops.CustomDropScreenFactory;
import com.pixelmonmod.pixelmon.api.enums.PositionTriState;
import com.pixelmonmod.pixelmon.api.events.PokeStopEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeStopTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.eventbus.api.Event;

public class PokeStopBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private Color color;
    private ResourceLocation lootTable;

    public PokeStopBlock(Color color, ResourceLocation lootTable) {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(-1.0f, 6000000.0f).m_284180_(MapColor.f_283821_));
        this.color = color;
        this.lootTable = lootTable;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        LootParams.Builder lootcontext$builder;
        LootParams ctx;
        if (world.m_5776_() || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        if (!(tileEntity instanceof PokeStopTileEntity)) {
            return InteractionResult.SUCCESS;
        }
        PokeStopTileEntity pokestop = (PokeStopTileEntity)tileEntity;
        UUID playerID = player.m_20148_();
        ServerPlayer playerMP = (ServerPlayer)player;
        PokeStopEvent.CooldownCheck.Pre cooldownCheckPre = new PokeStopEvent.CooldownCheck.Pre(playerMP, pokestop);
        if (Pixelmon.EVENT_BUS.post((Event)cooldownCheckPre)) {
            return InteractionResult.SUCCESS;
        }
        if (cooldownCheckPre.isShouldCheckCooldown() && !pokestop.canClaim((Player)playerMP)) {
            if (pokestop.isOneTimeUse()) {
                ChatHandler.sendChat((Entity)player, "block.pixelmon.claimedpokestop", new Object[0]);
            } else {
                ChatHandler.sendChat((Entity)player, "block.pixelmon.timedpokestop", new Object[0]);
            }
            return InteractionResult.SUCCESS;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokeStopEvent.CooldownCheck.PostCalculate(playerMP, pokestop))) {
            return InteractionResult.SUCCESS;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokeStopEvent.CooldownCheck.Post(playerMP, pokestop))) {
            return InteractionResult.SUCCESS;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokeStopEvent.Use.Pre(playerMP, pokestop))) {
            return InteractionResult.SUCCESS;
        }
        LootTable loottable = world.m_7654_().m_278653_().m_278676_(pokestop.getLootTable());
        Object drops = loottable.m_287195_(ctx = (lootcontext$builder = this.createLootContext(world, state, playerMP, pokestop)).m_287235_(LootContextParamSet.m_165477_().m_81405_()));
        PokeStopEvent.Drops.Pre getDropsEvent = new PokeStopEvent.Drops.Pre(playerMP, pokestop, (List<ItemStack>)drops);
        if (!Pixelmon.EVENT_BUS.post((Event)getDropsEvent)) {
            drops = getDropsEvent.getDrops();
            ItemStack firstDrop = ItemStack.f_41583_;
            CustomDropScreenFactory.builder().setTitle((Component)Component.m_237115_((String)"block.pixelmon.pokestop")).addItems((Collection<ItemStack>)drops).escapeDoesNotClose().dropHandler((clickDrop, itemStack) -> DropItemHelper.giveItemStack((ServerPlayer)player, itemStack, false)).setButtonText(PositionTriState.CENTER, (Component)Component.m_237115_((String)"block.pixelmon.pokestop.exit")).sendTo(playerMP);
            String itemName = drops.size() == 0 || firstDrop.m_41619_() ? "tile.pokestop" : firstDrop.m_41720_().m_5671_(firstDrop);
            ChatHandler.sendChat((Entity)player, "block.pixelmon.pokestop.use", Component.m_237115_((String)itemName));
            Pixelmon.EVENT_BUS.post((Event)new PokeStopEvent.Drops.Post(playerMP, pokestop, (List<ItemStack>)drops));
        }
        pokestop.removeClaimer(playerID);
        pokestop.addClaimer(playerID);
        pokestop.m_6596_();
        pokestop.m_58904_().m_151543_(pokestop.m_58899_());
        ((ServerPlayer)player).f_8906_.m_141995_((Packet)pokestop.getUpdatePacket());
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistration.POKELOOT_OBTAINED.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
        Pixelmon.EVENT_BUS.post((Event)new PokeStopEvent.Use.Post(playerMP, pokestop));
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity te = world.m_7702_(pos);
        float scale = 1.0f;
        if (te instanceof PokeStopTileEntity) {
            scale = ((PokeStopTileEntity)te).getScale();
        }
        float dXZ = 0.1f * scale;
        AABB aabb = new AABB((double)(0.5f - dXZ), 0.0, (double)(0.5f - dXZ), (double)(0.5f + dXZ), (double)(1.5f * scale), (double)(0.5f + dXZ));
        return Shapes.m_83064_((AABB)aabb);
    }

    protected LootParams.Builder createLootContext(Level world, BlockState state, ServerPlayer player, PokeStopTileEntity pokestop) {
        BlockPos pos = pokestop.m_58899_();
        return new LootParams.Builder((ServerLevel)world).m_287286_(LootContextParams.f_81462_, (Object)pokestop).m_287286_(LootContextParams.f_81460_, (Object)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_287286_(LootContextParams.f_81461_, (Object)state).m_287286_(LootContextParams.f_81463_, (Object)player.m_21205_()).m_287286_(LootContextParams.f_81458_, (Object)player).m_287286_(LootContextParams.f_81459_, (Object)player).m_287286_(LootContextParams.f_81456_, (Object)player).m_287239_(player.m_36336_());
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_49967_() {
        return true;
    }

    protected void m_142387_(Level p_152422_, Player p_152423_, BlockPos p_152424_, BlockState p_152425_) {
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        PokeStopTileEntity tileEntity = new PokeStopTileEntity(blockPos, blockState);
        tileEntity.setLootTable(this.lootTable);
        tileEntity.setColor(this.color);
        return tileEntity;
    }
}

