/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileentity.EnumPokegiftType;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeGiftTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class PokeGiftBlock
extends BaseEntityBlock
implements IBlockHasOwner {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final AABB AABB = new AABB((double)0.29f, 0.0, (double)0.29f, (double)0.72f, (double)0.44f, (double)0.72f);
    protected String itemName = "item.pixelmon.pokeGift";
    protected double xVel = 0.1;
    protected double yVel = 0.2;
    protected double zVel = 0.1;
    protected EnumPokegiftType type;

    public PokeGiftBlock(EnumPokegiftType type) {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_284180_(MapColor.f_283808_));
        this.type = type;
        this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
    }

    public PokeGiftBlock() {
        this(EnumPokegiftType.GIFT);
    }

    public BlockState m_6843_(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.m_61124_((Property)FACING, (Comparable)p_185499_2_.m_55954_((Direction)p_185499_1_.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (worldIn.f_46443_ || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.SUCCESS;
        }
        PokeGiftTileEntity tile = BlockHelper.getTileEntity(PokeGiftTileEntity.class, (LevelReader)worldIn, pos);
        if (tile == null) {
            return InteractionResult.SUCCESS;
        }
        if (!Objects.equals(player.m_20148_(), tile.getOwner())) {
            if (!tile.canClaim(player.m_20148_())) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.claimedloot", new Object[0]);
                return InteractionResult.SUCCESS;
            }
            if (tile.shouldBreakBlock()) {
                if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(worldIn, pos, state, player))) {
                    return InteractionResult.SUCCESS;
                }
                worldIn.m_7471_(pos, false);
                if (worldIn.m_8055_(pos).m_60734_() == this) {
                    return InteractionResult.SUCCESS;
                }
            }
            if (tile.getPokemon() == null) {
                ChatHandler.sendChat((Entity)player, "pixelutilities.blocks.emptygift", Component.m_237115_((String)this.itemName));
                worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11797_, SoundSource.BLOCKS, 0.8f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (tile.getPokemon().hasFlag("untradeable")) {
                ChatHandler.sendChat((Entity)player, "pixelutilities.blocks.untradablegift", new Object[0]);
                return InteractionResult.SUCCESS;
            }
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestfound", Component.m_237115_((String)this.itemName));
            PlayerPartyStorage party = StorageProxy.getPartyNow((ServerPlayer)player);
            if (Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent((ServerPlayer)player, tile.getPokemon(), "PokeBall"))) {
                return InteractionResult.SUCCESS;
            }
            Pokemon pokemon = tile.getPokemon();
            pokemon.setUUID(UUID.randomUUID());
            party.add(pokemon);
            tile.addClaimer(player.m_20148_());
            worldIn.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistration.POKELOOT_OBTAINED.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
        } else {
            if (player.m_6144_()) {
                if (tile.getPokemon() != null && player.m_7500_()) {
                    tile.setOwner(null);
                    ChatHandler.sendChat((Entity)player, "pixelmon.blocks.ownerchanged", new Object[0]);
                    return InteractionResult.SUCCESS;
                }
                if (player.m_7500_()) {
                    ChatHandler.sendChat((Entity)player, "pixelmon.blocks.fillmefirst", new Object[0]);
                }
                return InteractionResult.FAIL;
            }
            ServerPlayer playerMP = (ServerPlayer)player;
            Pokemon pokemon = tile.getPokemon();
            if (pokemon != null) {
                if (!player.m_7500_()) {
                    ChatHandler.sendChat((Entity)player, "pixelmon.blocks.alreadyfilled", new Object[0]);
                    return InteractionResult.SUCCESS;
                }
                String mode = "";
                if (tile.getChestMode() && tile.getDropMode()) {
                    tile.setChestOneTime(false);
                    tile.setDropOneTime(true);
                    mode = "pixelmon.blocks.chestmodePL1D";
                } else {
                    tile.setDropOneTime(true);
                    tile.setChestOneTime(true);
                    mode = "pixelmon.blocks.chestmodeFCFS";
                }
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestmode", Component.m_237115_((String)mode));
                return InteractionResult.SUCCESS;
            }
            PlayerPartyStorage party = StorageProxy.getPartyNow(playerMP);
            if (party.inTemporaryMode()) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.intemporarymode", new Object[0]);
                return InteractionResult.FAIL;
            }
            if (party.countPokemon() <= 1) {
                ChatHandler.sendChat((Entity)playerMP, "pixelmon.blocks.lastpoke", new Object[0]);
                return InteractionResult.FAIL;
            }
            Pokemon firstPokeinWorld = null;
            for (int i = 0; i < 6; ++i) {
                Pokemon partypoke = party.get(i);
                if (partypoke == null || !partypoke.getPixelmonEntity().isPresent()) continue;
                firstPokeinWorld = partypoke;
                break;
            }
            if (firstPokeinWorld == null) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.nothingtoadd", new Object[0]);
                return InteractionResult.FAIL;
            }
            firstPokeinWorld.ifEntityExists(pixelmonEntity -> pixelmonEntity.retrieve("Forced"));
            int position = party.getPosition((Pokemon)firstPokeinWorld).order;
            party.set(position, null);
            firstPokeinWorld.setStorage(null, null);
            tile.setPokemon(firstPokeinWorld);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        PokeGiftTileEntity tile = (PokeGiftTileEntity)worldIn.m_7702_(pos);
        if (tile.getOwner() == null || Objects.equals(tile.getOwner(), player.m_20148_())) {
            return super.m_5880_(state, player, worldIn, pos);
        }
        return -1.0f;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!level.f_46443_) {
            PokeGiftTileEntity tile = BlockHelper.getTileEntity(PokeGiftTileEntity.class, (LevelReader)level, pos);
            Pokemon pokemon = tile.getPokemon();
            if (pokemon != null && tile.getOwner() != null) {
                PlayerPartyStorage storage = StorageProxy.getPartyNow(tile.getOwner());
                pokemon.setUUID(UUID.randomUUID());
                storage.add(pokemon);
            } else {
                DropItemHelper.giveItemStack((ServerPlayer)player, new ItemStack((ItemLike)PixelmonBlocks.poke_gift), false);
            }
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        return false;
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        PokeGiftTileEntity tile = BlockHelper.getTileEntity(PokeGiftTileEntity.class, (LevelReader)serverLevel, blockPos);
        if (tile.getVisibility() == EnumPokechestVisibility.Hidden) {
            float rand = random.m_188501_() * 0.5f + 1.0f;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123751_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 1, this.xVel * (double)rand, this.yVel * (double)rand, this.zVel * (double)rand, 0.05);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83064_((AABB)AABB);
    }

    @Override
    public void setOwner(BlockPos pos, Player playerIn) {
        PokeGiftTileEntity tile = BlockHelper.getTileEntity(PokeGiftTileEntity.class, (LevelReader)playerIn.f_19853_, pos);
        tile.setOwner(playerIn.m_20148_());
        if (PixelmonConfigProxy.getGeneral().isPokeGiftReusable()) {
            tile.setChestOneTime(false);
        }
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new PokeGiftTileEntity(blockPos, blockState);
    }
}

