/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.PokeLootEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokeChestType;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeChestTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class PokeChestBlock
extends BaseEntityBlock
implements IBlockHasOwner {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final AABB AABB = new AABB((double)0.29f, 0.0, (double)0.29f, (double)0.72f, (double)0.44f, (double)0.72f);
    private final EnumPokeChestType type;

    public PokeChestBlock(EnumPokeChestType type) {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60913_(-1.0f, 6000000.0f).m_284180_(MapColor.f_283808_));
        this.type = type;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public boolean m_6724_(BlockState p_149653_1_) {
        return true;
    }

    public BlockState m_6843_(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.m_61124_((Property)FACING, (Comparable)p_185499_2_.m_55954_((Direction)p_185499_1_.m_61143_((Property)FACING)));
    }

    protected ItemStack getChestDrop() {
        switch (this.type) {
            case POKEBALL: {
                return DropItemRegistry.getTier1Drop();
            }
            case ULTRABALL: {
                return DropItemRegistry.getTier2Drop();
            }
            case MASTERBALL: {
                return DropItemRegistry.getTier3Drop();
            }
            case BEASTBALL: {
                return DropItemRegistry.getUltraSpaceDrop();
            }
        }
        return null;
    }

    private ItemStack getHiddenDrop() {
        int num = RandomHelper.getRandom().nextInt(100);
        if (num <= 50) {
            return DropItemRegistry.getTier1Drop();
        }
        if (num < 85) {
            return DropItemRegistry.getTier2Drop();
        }
        return DropItemRegistry.getTier3Drop();
    }

    private ItemStack[] getRandomDrops(EnumPokechestVisibility visibility) {
        if (visibility == EnumPokechestVisibility.Visible) {
            return new ItemStack[]{this.getChestDrop()};
        }
        return new ItemStack[]{this.getHiddenDrop()};
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_() || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        if (!(tileEntity instanceof PokeChestTileEntity)) {
            return InteractionResult.SUCCESS;
        }
        PokeChestTileEntity pokeChest = (PokeChestTileEntity)tileEntity;
        UUID blockOwner = pokeChest.getOwner();
        UUID playerID = player.m_20148_();
        if (playerID.equals(blockOwner)) {
            if (player.m_6144_()) {
                pokeChest.setOwner(null);
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.ownerchanged", new Object[0]);
                return InteractionResult.SUCCESS;
            }
            ItemStack itemStack = player.m_21205_();
            if (!itemStack.m_41619_()) {
                pokeChest.setCustomDrops(itemStack);
                pokeChest.setOwner(null);
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestset", Component.m_237115_((String)itemStack.m_41778_()));
                return InteractionResult.SUCCESS;
            }
            EnumPokechestVisibility visibility = pokeChest.getVisibility();
            String metaMode = "";
            if (visibility == EnumPokechestVisibility.Hidden) {
                pokeChest.setVisibility(EnumPokechestVisibility.Visible);
                metaMode = "Normal";
            } else {
                pokeChest.setVisibility(EnumPokechestVisibility.Hidden);
                metaMode = "Hidden";
            }
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.visible", metaMode);
            return InteractionResult.FAIL;
        }
        if (!pokeChest.canClaim(playerID)) {
            if (pokeChest.isTimeEnabled()) {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timedclaim", new Object[0]);
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.claimedloot", new Object[0]);
            }
            return InteractionResult.SUCCESS;
        }
        ServerPlayer playerMP = (ServerPlayer)player;
        if (Pixelmon.EVENT_BUS.post((Event)new PokeLootEvent.Claim(playerMP, pokeChest))) {
            return InteractionResult.SUCCESS;
        }
        if (pokeChest.shouldBreakBlock()) {
            if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, player))) {
                return InteractionResult.SUCCESS;
            }
            world.m_7471_(pos, false);
        }
        ItemStack[] drops = pokeChest.isCustomDrop() ? pokeChest.getCustomDrops() : this.getRandomDrops(pokeChest.getVisibility());
        PokeLootEvent.GetDrops getDropsEvent = new PokeLootEvent.GetDrops(playerMP, pokeChest, drops);
        Pixelmon.EVENT_BUS.post((Event)getDropsEvent);
        drops = getDropsEvent.getDrops();
        ItemStack firstDrop = ItemStack.f_41583_;
        for (ItemStack drop : drops) {
            ItemStack newDrop;
            PokeLootEvent.Drop dropEvent;
            if (drop == null || Pixelmon.EVENT_BUS.post((Event)(dropEvent = new PokeLootEvent.Drop(playerMP, pokeChest, newDrop = drop.m_41777_())))) continue;
            if (firstDrop.m_41619_()) {
                firstDrop = dropEvent.getDrop().m_41777_();
            }
            DropItemHelper.giveItemStack(playerMP, dropEvent.getDrop(), false);
        }
        String itemName = drops.length == 0 || firstDrop.m_41619_() ? "tile.poke_chest" : firstDrop.m_41720_().m_7626_(firstDrop).getString();
        ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestfound", Component.m_237115_((String)itemName));
        pokeChest.removeClaimer(playerID);
        pokeChest.addClaimer(playerID);
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistration.POKELOOT_OBTAINED.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public void m_6256_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        if (worldIn.m_5776_()) {
            return;
        }
        PokeChestTileEntity pokeChest = (PokeChestTileEntity)worldIn.m_7702_(pos);
        if (pokeChest == null || !Objects.equals(pokeChest.getOwner(), player.m_20148_())) {
            return;
        }
        Object mode = "pixelmon.blocks.chestmode";
        boolean chestMode = pokeChest.getChestMode();
        boolean dropMode = pokeChest.getDropMode();
        boolean timeEnabled = pokeChest.isTimeEnabled();
        if (!(chestMode || dropMode || timeEnabled)) {
            pokeChest.setChestOneTime(false);
            pokeChest.setDropOneTime(true);
            pokeChest.setTimeEnabled(false);
            mode = (String)mode + "PL1D";
        } else if (!chestMode && dropMode && !timeEnabled) {
            pokeChest.setDropOneTime(true);
            pokeChest.setChestOneTime(false);
            pokeChest.setTimeEnabled(true);
            mode = (String)mode + "TD";
        } else if (timeEnabled) {
            pokeChest.setTimeEnabled(false);
            pokeChest.setDropOneTime(true);
            pokeChest.setChestOneTime(true);
            mode = (String)mode + "FCFS";
        } else if (chestMode && dropMode && !timeEnabled) {
            pokeChest.setChestOneTime(false);
            pokeChest.setDropOneTime(false);
            pokeChest.setTimeEnabled(false);
            mode = (String)mode + "PUD";
        }
        ChatHandler.sendChat((Entity)player, "pixelmon.blocks.chestmode", Component.m_237115_((String)mode));
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new PokeChestTileEntity(blockPos, blockState);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        PokeChestTileEntity tile = BlockHelper.getTileEntity(PokeChestTileEntity.class, (LevelReader)world, pos);
        if (tile == null) {
            return;
        }
        if (tile.getVisibility() == EnumPokechestVisibility.Hidden) {
            float rand = random.m_188501_() * 0.5f + 1.0f;
            double xVel = 0.1;
            double yVel = 0.2;
            double zVel = 0.1;
            world.m_8767_((ParticleOptions)ParticleTypes.f_123751_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, xVel * (double)rand, yVel * (double)rand, zVel * (double)rand, 0.5);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83064_((AABB)AABB);
    }

    @Override
    public void setOwner(BlockPos pos, Player playerIn) {
        UUID playerID = playerIn.m_20148_();
        PokeChestTileEntity tile = BlockHelper.getTileEntity(PokeChestTileEntity.class, (LevelReader)playerIn.f_19853_, pos);
        tile.setOwner(playerID);
    }
}

