/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.blocks.GenericModelBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.PicketFenceNormalTileEntity;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PicketFenceBlock
extends GenericModelBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final AABB[] BOUNDING_BOXES = new AABB[]{new AABB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625), new AABB(0.375, 0.0, 0.375, 0.625, 1.0, 1.0), new AABB(0.0, 0.0, 0.375, 0.625, 1.0, 0.625), new AABB(0.0, 0.0, 0.375, 0.625, 1.0, 1.0), new AABB(0.375, 0.0, 0.0, 0.625, 1.0, 0.625), new AABB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0), new AABB(0.0, 0.0, 0.0, 0.625, 1.0, 0.625), new AABB(0.0, 0.0, 0.0, 0.625, 1.0, 1.0), new AABB(0.375, 0.0, 0.375, 1.0, 1.0, 0.625), new AABB(0.375, 0.0, 0.375, 1.0, 1.0, 1.0), new AABB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625), new AABB(0.0, 0.0, 0.375, 1.0, 1.0, 1.0), new AABB(0.375, 0.0, 0.0, 1.0, 1.0, 0.625), new AABB(0.375, 0.0, 0.0, 1.0, 1.0, 1.0), new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.625), new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public static final AABB PILLAR_AABB = new AABB(0.375, 0.0, 0.375, 0.625, 1.5, 0.625);
    public static final AABB SOUTH_AABB = new AABB(0.375, 0.0, 0.625, 0.625, 1.5, 1.0);
    public static final AABB WEST_AABB = new AABB(0.0, 0.0, 0.375, 0.375, 1.5, 0.625);
    public static final AABB NORTH_AABB = new AABB(0.375, 0.0, 0.0, 0.625, 1.5, 0.375);
    public static final AABB EAST_AABB = new AABB(0.625, 0.0, 0.375, 1.0, 1.5, 0.625);
    protected final VoxelShape[] collisionShapeByIndex;
    private final Object2IntMap<BlockState> stateToIndex = new Object2IntOpenHashMap();

    public PicketFenceBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_60918_(SoundType.f_56736_).m_284180_(MapColor.f_283811_));
        this.collisionShapeByIndex = this.makeShapes(2.0f, 2.0f, 16.0f, 0.0f, 16.0f);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape[] makeShapes(float p_196408_1_, float p_196408_2_, float p_196408_3_, float p_196408_4_, float p_196408_5_) {
        float f = 8.0f - p_196408_1_;
        float f1 = 8.0f + p_196408_1_;
        float f2 = 8.0f - p_196408_2_;
        float f3 = 8.0f + p_196408_2_;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)p_196408_3_, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)p_196408_4_, (double)0.0, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)p_196408_4_, (double)f2, (double)16.0, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape5 = Shapes.m_83110_((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{Shapes.m_83040_(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }

    private static int indexFor(Direction p_196407_0_) {
        return 1 << p_196407_0_.m_122416_();
    }

    protected int getAABBIndex(BlockState p_196406_1_) {
        return this.stateToIndex.computeIntIfAbsent((Object)p_196406_1_, p_223007_0_ -> {
            int i = 0;
            if (((Boolean)p_223007_0_.m_61143_((Property)NORTH)).booleanValue()) {
                i |= PicketFenceBlock.indexFor(Direction.NORTH);
            }
            if (((Boolean)p_223007_0_.m_61143_((Property)EAST)).booleanValue()) {
                i |= PicketFenceBlock.indexFor(Direction.EAST);
            }
            if (((Boolean)p_223007_0_.m_61143_((Property)SOUTH)).booleanValue()) {
                i |= PicketFenceBlock.indexFor(Direction.SOUTH);
            }
            if (((Boolean)p_223007_0_.m_61143_((Property)WEST)).booleanValue()) {
                i |= PicketFenceBlock.indexFor(Direction.WEST);
            }
            return i;
        });
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return Shapes.m_83064_((AABB)BOUNDING_BOXES[PicketFenceBlock.getBoundingBoxIdx(state)]);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83064_((AABB)BOUNDING_BOXES[PicketFenceBlock.getBoundingBoxIdx(state)]);
    }

    private static int getBoundingBoxIdx(BlockState state) {
        int i = 0;
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            i |= 1 << Direction.NORTH.m_122416_();
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            i |= 1 << Direction.EAST.m_122416_();
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            i |= 1 << Direction.SOUTH.m_122416_();
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            i |= 1 << Direction.WEST.m_122416_();
        }
        return i;
    }

    public boolean canConnectTo(BlockGetter worldIn, BlockPos pos, Direction facing) {
        BlockState iblockstate = worldIn.m_8055_(pos);
        VoxelShape blockfaceshape = iblockstate.m_60655_(worldIn, pos, facing);
        Block block = iblockstate.m_60734_();
        return !PicketFenceBlock.isExcepBlockForAttachWithPiston(iblockstate) && blockfaceshape == Shapes.m_83144_() || block instanceof PicketFenceBlock;
    }

    protected static boolean isExcepBlockForAttachWithPiston(BlockState p_194142_0_) {
        return Block.m_152463_((BlockState)p_194142_0_) || p_194142_0_.m_60713_(Blocks.f_50375_) || p_194142_0_.m_60713_(Blocks.f_50186_) || p_194142_0_.m_60713_(Blocks.f_50133_);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return worldIn.f_46443_ ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level worldIn = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.m_122012_(), Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.m_122029_(), Direction.WEST)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.m_122019_(), Direction.NORTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)worldIn, pos.m_122024_(), Direction.EAST)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        switch (direction) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
        }
        return state;
    }

    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new PicketFenceNormalTileEntity(blockPos, blockState);
    }
}

