/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.OrbTileEntity;
import com.pixelmonmod.pixelmon.enums.items.EnumOrbShard;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OrbBlock
extends GenericRotatableModelBlock {
    private static final AABB AABB = new AABB(0.2, 0.0, 0.2, 0.8, 0.7, 0.8);
    public final EnumOrbShard shardType;

    public OrbBlock(EnumOrbShard shardType) {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56744_).m_284180_(MapColor.f_283808_));
        this.shardType = shardType;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83064_((AABB)AABB);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ItemStack m_7397_(BlockGetter p_49823_, BlockPos p_49824_, BlockState p_49825_) {
        switch (this.shardType) {
            case RED: {
                return new ItemStack((ItemLike)PixelmonItems.red_orb);
            }
            case BLUE: {
                return new ItemStack((ItemLike)PixelmonItems.blue_orb);
            }
            case JADE: {
                return new ItemStack((ItemLike)PixelmonItems.jade_orb);
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        OrbTileEntity tile = (OrbTileEntity)level.m_7702_(pos);
        if (tile == null) {
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        if (player.m_7500_()) {
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        byte pieces = tile.getPieces();
        ItemStack stack = null;
        if (this.shardType == EnumOrbShard.RED) {
            stack = pieces == 10 ? new ItemStack((ItemLike)PixelmonItems.red_orb, 1) : new ItemStack((ItemLike)PixelmonItems.omega_shard, (int)pieces);
        } else if (this.shardType == EnumOrbShard.BLUE) {
            stack = pieces == 10 ? new ItemStack((ItemLike)PixelmonItems.blue_orb, 1) : new ItemStack((ItemLike)PixelmonItems.alpha_shard, (int)pieces);
        } else if (this.shardType == EnumOrbShard.JADE) {
            ItemStack itemStack = stack = pieces == 10 ? new ItemStack((ItemLike)PixelmonItems.jade_orb, 1) : new ItemStack((ItemLike)PixelmonItems.delta_shard, (int)pieces);
        }
        if (stack != null && !level.f_46443_) {
            ItemEntity drops = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
            level.m_7967_((Entity)drops);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new OrbTileEntity(blockPos, blockState, 1);
    }
}

