/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.MysteryBoxTileEntity;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MysteryBoxBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public MysteryBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return MysteryBoxBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)TileEntityRegistration.MYSTERY_BOX.get()), MysteryBoxTileEntity::tick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos newPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, direction, newState, world, pos, newPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean unused) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = world.m_7702_(pos);
            if (tileentity instanceof Container) {
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, unused);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        MysteryBoxTileEntity tile;
        ItemStack heldItem = player.m_21120_(hand);
        if (!world.f_46443_ && hand != InteractionHand.OFF_HAND && (tile = BlockHelper.getTileEntity(MysteryBoxTileEntity.class, (LevelReader)world, pos)) != null) {
            tile.activate(player, state, heldItem);
            world.m_46717_(pos, state.m_60734_());
            world.m_46717_(pos, (Block)this);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        return te instanceof MysteryBoxTileEntity ? ((MysteryBoxTileEntity)te).getPower() : 0;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof MysteryBoxTileEntity) {
            MysteryBoxTileEntity te = (MysteryBoxTileEntity)tileentity;
            if (!world.f_46443_ && player.m_7500_()) {
                te.prepareForDrop();
                ItemStack itemstack = new ItemStack((ItemLike)state.m_60734_());
                CompoundTag compoundTag = new CompoundTag();
                te.m_183515_(compoundTag);
                if (!compoundTag.m_128456_()) {
                    itemstack.m_41700_("BlockEntityTag", (Tag)compoundTag);
                }
                ItemEntity itementity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                world.m_7967_((Entity)itementity);
            }
        }
        super.m_5707_(world, pos, state, player);
    }

    public ItemStack m_7397_(BlockGetter blockReader, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.m_7397_(blockReader, pos, state);
        MysteryBoxTileEntity te = (MysteryBoxTileEntity)blockReader.m_7702_(pos);
        CompoundTag compoundTag = new CompoundTag();
        te.m_183515_(compoundTag);
        if (!compoundTag.m_128456_()) {
            itemstack.m_41700_("BlockEntityTag", (Tag)compoundTag);
        }
        return itemstack;
    }

    public void m_6861_(BlockState p_220069_1_, Level p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (!p_220069_2_.m_183326_().m_183588_(p_220069_3_, (Object)this)) {
            p_220069_2_.m_186460_(p_220069_3_, (Block)this, 2);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new MysteryBoxTileEntity(blockPos, blockState);
    }
}

